*****c***1********2*******3********4********5********6********7********8
*
      program cutsphere
*
*****c***1********2*******3********4********5********6********7********8
*
* generation of coordinates of inside a sphere of any coordinate
*
*
*****c***1********2*******3********4********5********6********7********8
*
* m. winterer 3/10/98 darmstadt
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations 
*
       implicit none
* global variables
*
       integer natom,matom,nsphere,nmatrix
       parameter(matom=100000)
       integer typ(matom),mtyp,ntyp,styp(matom),matyp(matom)
       integer ttyp0,ttyp1
       real xco(matom),yco(matom),zco(matom)
       real srad,rad,tshell
       real xsp(matom),ysp(matom),zsp(matom),xa,ya,za
       real xma(matom),yma(matom),zma(matom)
       integer i,coun1,coun2,coun3,coun4,coun5,coun6
       character*128 filnam
*
*****c***1********2*******3********4********5********6********7********8
*
* input coordinates
*
       print *,'generation of coordinates inside a sphere'
       print *,' '
       print *,'input filname: '
       read(*,'(a)')filnam
       print *,' '
       print *,'sphere radius: '
       read(*,*)srad
       print *,' '
       print *,'thickness of termination shell: '
       read(*,*)tshell
       print *,'terminate by atom type (1 to 3): '
       read(*,*)ttyp0
       print *,'substitue terminating atom by type (1 to 3): '
       read(*,*)ttyp1
       print *,' '
       open(15,file=filnam,status='unknown')
       i=0
10     continue 
        i=i+1
        read(15,9000,end=20)i,typ(i),xco(i),yco(i),zco(i)
       goto 10
20     continue
       natom=i-1 
       close(15,status='keep')
       print *,'read number of atoms: ',natom
*
*****c***1********2*******3********4********5********6********7********8
*
* select only atoms inside sphere with radius srad
* and terminate with atoms 
*
       nsphere=0
       nmatrix=0
       coun1=0
       coun2=0
       coun3=0
       coun4=0
       coun5=0
       coun6=0
       do 800 i=1,natom
         xa=xco(i)
	 ya=yco(i)
	 za=zco(i) 
         rad=sqrt(xa*xa+ya*ya+za*za)
         if(rad.le.srad)then
          if(rad.gt.srad-tshell)then
           if(typ(i).eq.ttyp0)then
            nsphere=nsphere+1
            xsp(nsphere)=xa
            ysp(nsphere)=ya
            zsp(nsphere)=za
	    styp(nsphere)=ttyp1
            if(styp(nsphere).eq.1)coun1=coun1+1
            if(styp(nsphere).eq.2)coun2=coun2+1
            if(styp(nsphere).eq.3)coun3=coun3+1
           endif
          else
           nsphere=nsphere+1
           xsp(nsphere)=xa
           ysp(nsphere)=ya
           zsp(nsphere)=za
	   styp(nsphere)=typ(i)
           if(styp(nsphere).eq.1)coun1=coun1+1
           if(styp(nsphere).eq.2)coun2=coun2+1
           if(styp(nsphere).eq.3)coun3=coun3+1
          endif
         else
          nmatrix=nmatrix+1
          xma(nmatrix)=xa
          yma(nmatrix)=ya
          zma(nmatrix)=za
	  matyp(nmatrix)=typ(i)
          if(matyp(nmatrix).eq.1)coun4=coun4+1
          if(matyp(nmatrix).eq.2)coun5=coun5+1
          if(matyp(nmatrix).eq.3)coun6=coun6+1
         endif
800    continue
       write(*,*)'generated lattice points in sphere: ',nsphere
       write(*,*)'in sphere of radius: ',srad
       write(*,*)'number of atoms of type 1: ',coun1
       write(*,*)'number of atoms of type 2: ',coun2
       write(*,*)'number of atoms of type 3: ',coun3
       write(*,*)' '
       write(*,*)'generated lattice points in matrix: ',nmatrix
       write(*,*)'except central sphere of radius: ',srad
       write(*,*)'number of atoms of type 1: ',coun4
       write(*,*)'number of atoms of type 2: ',coun5
       write(*,*)'number of atoms of type 3: ',coun6
       
*****c***1********2*******3********4********5********6********7********8
*
* output atom coordinates 
*
*****c***1********2*******3********4********5********6********7********8
*
       print *,'output atom coordinates'

       open(15,file='sphere.coo',status='unknown')
       do 1001 i=1,nsphere
        write(15,9000)i,styp(i),xsp(i),ysp(i),zsp(i),0.0,1.0
1001   continue
       close(15,status='keep')

       open(15,file='matrix.coo',status='unknown')
       do 1002 i=1,nmatrix
        write(15,9000)i,matyp(i),xma(i),yma(i),zma(i),0.0,1.0
1002   continue
       close(15,status='keep')
9000   format(i6,1x,i2,5(1x,g13.6))
*
*****c***1********2*******3********4********5********6********7********8
*
      end
