*****c***1********2*******3********4********5********6********7********8
*
       subroutine xafscw(mdat,ndat,mhis,nhis,mtyp,nta,nte,mpdf,lisp,
     1                   conc,dens,wspc,mspec,nspec,nabs,gij,gam,
     2                   chitrunc,kpow,chi,deltar)
*
*****c***1********2*******3********4********5********6********7********8
*
* calculation of exafs spectrum for rmc 
* curved wave approximation: amplitude, phase and mean free path are
* dependent on coordination distance
* the r*r term is implicitly included in gam(k,l,j,nabs)
*
* source: S.J.Gurman and R.L McGreevy, J.Phys. Cond. Mat. 2 (1990), 9463
*
*****c***1********2*******3********4********5********6********7********8
*
* m. winterer 5/19/98 darmstadt
* calculate exafs kernel gam once at the beginning 01/25/06mw
* change normalization of gij (rho is already included in "pdfall")
*  average concentration is used in conc(j)
*  for accurate calculations of multiple phase systems 10/7/98
* add Hanning-Square window at end of gij 10/10(01mw)
*
* changes due to multisite 06/09/20mw
*
*****c***1********2*******3********4********5********6********7********8
*
* global variables
*       mdat,ndat           maximum and actual number of spectral points
*       mhis,nhis           maximum and actual number of histogram points
*       mtyp,ntyp           maximum and actual number of atom types
*       rad(mhis)           histogram radius
*       conc(mtyp)          atomic fractions
*       wpfd(mpdf)          weights of pPDFs due to multiple absorbers
*                           contributing to a single spectrum
*       gij(mhis,mtyp)      partial radial distribution function
*       gam(mdat,mhis,mtyp,mspec)
*                           exafs kernel computed in gamx
*       kpow(mdat)          k**(n-1)
*       chi(mdat)           exafs signal
*       rho                 number density
*       deltar              interval of histogram radius 
*       pi                  3.14...
* local variables
*       j,k,l               loop indices
*       chiij               storage for spectral summation
*
* files used:               none
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations 
*
       implicit none
* global variables
       integer mdat,ndat,mhis,nhis,mtyp,mpdf,mspec,nspec
       integer lisp(mtyp,mtyp),nabs,nta,nte
       real gij(mhis,mpdf),conc(mtyp),wspc(mtyp),dens(mtyp)
       real gam(mdat,mhis,mtyp,mtyp),chitrunc(mdat,mtyp,mtyp)
       real kpow(mdat,mspec),chi(mdat,mtyp)
       real pi,deltar
       common /const/pi
* local variables
       integer j,k,l
       real chiij,chij
*
*****c***1********2*******3********4********5********6********7********8
*
* loop over k-vector
       do 120 k=1,ndat
        chiij=0.0
	chi(k,nabs)=0.0
* sum over all types of neighbours
         do 110 j=nta,nte
	  chij=0.0
          do 100 l=1,nhis
* numerical integration over distance
           chij=chij+gij(l,lisp(nabs,j))*gam(k,l,j,nabs)
     1          *dens(j)*wspc(nabs)
100       continue
          chiij=chiij+chij+chitrunc(k,j,nabs)*
     1                     dens(j)*wspc(nabs)
110       continue
        chi(k,nabs)=chiij*4.0*pi*kpow(k,nspec)
120    continue
       return
       end

