*****c***1********2*******3********4********5********6********7********8
*
       subroutine gamx(mdat,ndat,mhis,nhis,mtyp,nta,nte,nabs,
     1  mspec,nspec,rad,vec,amp,pha,laminv,gam,deltar)
*
*****c***1********2*******3********4********5********6********7********8
*
* calculation of exafs kernel for rmc 
* curved wave approximation: amplitude, phase and mean free path are
* dependent on coordination distance
*
* source: S.J.Gurman and R.L McGreevy, J.Phys. Cond. Mat. 2 (1990), 9463
*
*****c***1********2*******3********4********5********6********7********8
*
* m. winterer 01/25/06 duisburg
*
* changes due to multisite 06/11/20mw
*
*****c***1********2*******3********4********5********6********7********8
*
* global variables
*       mdat,ndat           maximum and actual number of spectral points
*       mhis,nhis           maximum and actual number of histogram points
*       mtyp,ntyp           maximum and actual number of atom types
*       rad(mhis)           histogram radius
*       vec(mdat,ntyp)      k-vector
*       amp(mdat,ntyp)      amplitude
*       pha(mdat,ntyp)      phase
*       laminv(mdat,ntyp)   inverse of mean free path
*       gam(mdat,mhis,mtyp,mspec) 
*                           exafs kernel
*       deltar              interval of histogram radius 
*       pi                  3.14...
* local variables
*       j,k,l,n             loop indices
*
* files used:               none
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations 
*
       implicit none
* global variables
       integer mdat,ndat,mhis,nhis,mtyp,mspec,nspec,nabs
       integer nta,nte
       real rad(mhis)
       real vec(mdat,mspec)
       real amp(mdat,mhis,mtyp,mtyp),pha(mdat,mhis,mtyp,mtyp)
       real laminv(mdat,mhis,mtyp,mtyp)
       real gam(mdat,mhis,mtyp,mtyp)
       real pi,deltar
       common /const/ pi
* local variables
       integer j,k,l
       integer mmax
       real pih,rmax
*
*****c***1********2*******3********4********5********6********7********8
*
       mmax=int(2.0/deltar)
       rmax=rad(nhis)
       pih=0.5*pi 
* loop over k-vector k
       do 120 k=1,ndat
* sum over all types of neighbours j
         do 110 j=nta,nte
* loop over PDF radius l
          do 100 l=1,nhis
* 
           gam(k,l,j,nabs)=amp(k,l,j,nabs)
     1                *exp(-2.0*rad(l)*laminv(k,l,j,nabs))
     2                *sin(2.0*vec(k,nspec)*rad(l)+pha(k,l,j,nabs))
     3                *deltar
100       continue
110       continue
c        write(nabs+30,*)vec(k,nspec),gam(k,10,1,nabs)
120    continue
       return
       end

