*****c***1********2*******3********4********5********6********7********8
       program extract
*****c***1********2*******3********4********5********6********7********8
*
* separate peaks and background
*
*****c***1********2*******3********4********5********6********7********8
* declarations
*
      implicit none
      integer i,l,n,ndat,ncom,ntit,ncolx,ncoly,mdat,np,n1
      parameter(mdat=1024)
      real d(mdat),xp(mdat),m1(mdat),x1(mdat)
      real w,x,y,xm2,xm1,x0,xp1,xp2,ym2,ym1,y0,yp1,yp2,threshy,threshd
      real pf,dydx1,dydx2
      character*256 filein
      character*80 buffer,title
*****c***1********2*******3********4********5********6********7********8
*
* input parameters
*
       open(15,file='extract.par',status='unknown')
        read(15,'(a)')filein
        print *,'data file: ',filein
        read(15,*)ncom,ntit,ncolx,ncoly
        print *,'ncom,ntit,ncolx,ncoly ',ncom,ntit,ncolx,ncoly
        read(15,*)threshy,threshd,w
        print *,'threshold,width ',w
       close(15,status='keep')
       if((ncolx.gt.mdat).or.(ncoly.gt.mdat))stop 'too many columns'
*
* open data set
*      
       open(20,file=filein,status='unknown')
* read header
       do n=1,ncom
        read(20,'(a)')buffer
        if(n.eq.ntit)title=buffer
       enddo
* count number of data
        ndat=0
1       continue
         read(20,*,end=10)d(1)
         ndat=ndat+1
        goto 1
10      continue        
       close(20,status='keep')
       print *,'number of data points ',ndat
*
* find peaks 
*
       open(20,file=filein,status='unknown')
       do n=1,ncom
        read(20,'(a)')buffer
       enddo
       l=0
       pf=1.0
        do n=1,ndat
         if(ncolx.lt.ncoly)then
          read(20,*)
     1     (d(i),i=1,ncolx-1),x,(d(i),i=ncolx+1,ncoly-1),y
         else
          read(20,*)
     1     (d(i),i=1,ncoly-1),y,(d(i),i=ncoly+1,ncolx-1),x
         endif
*
         if(n.eq.1)then
          xm2=x
          ym2=y
         elseif(n.eq.2)then
          xm1=x
          ym1=y
         elseif(n.eq.3)then
          x0=x
          y0=y
         elseif(n.eq.4)then
          xp1=x
          yp1=y
         elseif(n.eq.5)then
          xp2=x
          yp2=y
         elseif(n.gt.5)then
* reshuffle
          xm2=xm1
          xm1=x0
          x0=xp1
          xp1=xp2
          ym2=ym1
          ym1=y0
          y0=yp1
          yp1=yp2
* new data point
          xp2=x
          yp2=y
         endif
         if(n.ge.5)then
* 
          dydx1=(y0-ym2)/(x0-xm2)
          dydx2=(yp2-y0)/(xp2-x0)
          pf=dydx1*dydx2
*
         endif
*
         if((pf.lt.0.0).and.(dydx1.gt.0.0).and.(dydx2.lt.0.0)
     1    .and.(y0.gt.threshy).and.(abs(pf).gt.threshd))then
          l=l+1
          xp(l)=x0
c          write(25,'(1x,i6,5(1x,g13.6))')l,xp(l),y0,dydx1,dydx2,pf
          pf=1.0
         endif
        enddo
       np=l
       print *,'number of peaks: ',np
       close(20,status='keep')
* remove degeneracy and output peak positions
       open(25,file='peakm.dat',status='unknown')
        n1=0
        do l=1,mdat
         x1(l)=0.0
         m1(l)=0.0
        enddo
        do l=2,np
         if(xp(l).ge.(xp(l-1)-w).and.xp(l).lt.(xp(l-1)+w))then
          n1=n1+1
          x1(n1)=x1(n1)+xp(l)
          m1(n1)=m1(n1)+1.0
         endif
        enddo
        do l=1,n1
         if(m1(l).eq.0.0)m1(l)=1.0
         x1(l)=x1(l)/m1(l)
         write(25,'(1x,i6,(1x,g13.6))')l,xp(l)
        enddo
       close(25,status='keep')
       print *,'number of non-degenerate peaks: ',n1
*
* extract peaks and background data
*
       open(30,file='backg.dat',status='unknown')
       open(35,file='peaks.dat',status='unknown')
       open(20,file=filein,status='unknown')
        do n=1,ncom
         read(20,'(a)')buffer
        enddo
        do n=1,ndat
         if(ncolx.lt.ncoly)then
          read(20,*)
     1     (d(i),i=1,ncolx-1),x,(d(i),i=ncolx+1,ncoly-1),y
         else
          read(20,*)
     1     (d(i),i=1,ncoly-1),y,(d(i),i=ncoly+1,ncolx-1),x
         endif
* selection
         do l=1,n1
*  peaks
          if((x.ge.(x1(l)-w)).and.(x.le.(x1(l)+w)))then
           write(35,'(2(1x,g13.6),1x,i6)')x,y,l
*  background
          elseif((x.lt.(x1(l)-w)).and.(l.eq.1))then
           write(30,'(2(1x,g13.6),1x,i6,1x,i2)')x,y,l,1
          elseif((x.lt.(x1(l)-w)).and.(x.gt.(x1(l-1)+w))
     1                           .and.(l.gt.1).and.(l.lt.n1))then
           write(30,'(2(1x,g13.6),1x,i6,1x,i2)')x,y,l,2
          elseif((x.gt.(x1(l)+w)).and.(l.eq.n1))then
           write(30,'(2(1x,g13.6),1x,i6,1x,i2)')x,y,l,3
          endif 
         enddo
*
       enddo
       close(20,status='keep')
       close(30,status='keep')
       close(35,status='keep')
*****c***1********2*******3********4********5********6********7********8
       end
