*****c***1********2*******3********4********5********6********7********8
*
       program double
*
*****c***1********2*******3********4********5********6********7********8
*
* input atom coordinates and double linear dimension of simulation box
*
*****c***1********2*******3********4********5********6********7********8
*
* m. winterer 2/27/97 darmstadt
*
*****c***1********2*******3********4********5********6********7********8
*
* global variables
*
* local variables
*
* files used:              rmc.coo, unit 15
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations 
*
       implicit none
* global variables
       integer matom,matomd,natom,natomd,num1,num2
       parameter(matom=10000,matomd=8*matom)
       integer typ(matom),typd(matomd)
       real xco(matom),yco(matom),zco(matom),rms(matom)
       real xcd(matomd),ycd(matomd),zcd(matomd),rmsd(matomd)
       character*31 filcoo
       character*1 mode
* local variables
       integer ios,i,j,h,k,l,hn,kn,ln,n
       real box,boxh
*
*****c***1********2*******3********4********5********6********7********8
*
* input original coordinates: xco(i),yco(i),zco(i)
*
       print *,'double simulation box: 8 times more atoms and volume'
       print *,' '
       print *,'filnam: '
       read(*,'(a)')filcoo
       print *,'(r)mcxas file or (e)lse (rmca): '
       print *,'rmcxas: cartesian box; rmca: [-1,1['
       read(*,'(a)')mode
       print *,'input original coordinates from: ',filcoo
       print *,' '
       print *,'original box length (total!): '
       read (*,*)box
       if(mode.ne.'r')then
        print *,'number of atoms of type 1: '
        read(*,*)num1
        print *,'number of atoms of type 2: '
        read(*,*)num2
       endif
       i=0
       open(15,file=filcoo,status='unknown',err=9997,iostat=ios)
100    continue
        i=i+1
        if(mode.eq.'r')then
        read(15,9000,err=9998,end=200)j,typ(i),
     1                                xco(i),yco(i),zco(i),rms(i)
        else
        read(15,*,err=9998,end=200)xco(i),yco(i),zco(i)
c        print *,i,xco(i),yco(i),zco(i)
        endif
       goto 100
200    continue
       natom=i-1
       close(15,status='keep')
       print *,'incoo: number of atoms',natom
       if(mode.ne.'r')then
        if((num1+num2).ne.natom)then
         print *,'inconsistent number of atoms: ',num1+num2,' /= ',natom
         stop
        endif
       endif
*****c***1********2*******3********4********5********6********7********8
*
* double simulation box: 8 times more atoms and volume
*
* translations:
*
       hn=2
       kn=2
       ln=2
       natomd=0
       if(mode.eq.'r')then
       do 600 h=0,hn-1
        do 500 k=0,kn-1
	 do 400 l=0,ln-1
	  do 300 n=1,natom
          natomd=natomd+1
	   xcd(natomd)=xco(n)+float(h)*box
	   ycd(natomd)=yco(n)+float(k)*box
	   zcd(natomd)=zco(n)+float(l)*box
	   rmsd(natomd)=rms(n)
	   typd(natomd)=typ(n)
300       continue
400      continue
500     continue
600    continue
       else
       do 610 h=0,hn-1
        do 510 k=0,kn-1
	 do 410 l=0,ln-1
	  do 310 n=1,num1
          natomd=natomd+1
	   xcd(natomd)=xco(n)+float(h)*box
	   ycd(natomd)=yco(n)+float(k)*box
	   zcd(natomd)=zco(n)+float(l)*box
310       continue
410      continue
510     continue
610    continue
       do 620 h=0,hn-1
        do 520 k=0,kn-1
	 do 420 l=0,ln-1
	  do 320 n=num1+1,natom
          natomd=natomd+1
	   xcd(natomd)=xco(n)+float(h)*box
	   ycd(natomd)=yco(n)+float(k)*box
	   zcd(natomd)=zco(n)+float(l)*box
320       continue
420      continue
520     continue
620    continue
       endif
*
*  shift by new boxh=box(old)*0.5
*
       boxh=box*0.5
       print *,'new box length ',2.*box
       if(mode.eq.'r')then
        do 700 i=1,natomd
	 xcd(i)=xcd(i)-boxh
	 ycd(i)=ycd(i)-boxh
	 zcd(i)=zcd(i)-boxh 
700     continue
       else
        do 710 i=1,natomd
	 xcd(i)=0.5*(xcd(i)-boxh)
	 ycd(i)=0.5*(ycd(i)-boxh)
	 zcd(i)=0.5*(zcd(i)-boxh) 
710     continue
       endif
       print *,'generated ',natomd,' new lattice points'
*
* output new coordinates
*
       filcoo='rmc.coo.dbl'
       print *,'save new coordinates in: ',filcoo
       open(15,file=filcoo,status='unknown',err=9997,iostat=ios)
       if(mode.eq.'r')then
       do 800 i=1,natomd
        write(15,9000,err=9998)i,typd(i),xcd(i),ycd(i),zcd(i),
     1                         rmsd(i),1.0
800    continue
       else
       do 810 i=1,natomd
        write(15,*,err=9998)xcd(i),ycd(i),zcd(i)
810    continue
       endif
       close(15,status='keep')
       pause 'end double'
       stop
*
*****c***1********2*******3********4********5********6********7********8
9000   format(i6,1x,i2,5(1x,g13.6))
*
9997  print *,'incoo: open file error',ios
      pause
      stop
9998  print *,'incoo: input error'
      pause
      stop
      end
