*****c***1********2*******3********4********5********6********7********8
*
      program cutcylinder
*
*****c***1********2*******3********4********5********6********7********8
*
* generation of coordinates inside a cylinder and termination
*
*
*****c***1********2*******3********4********5********6********7********8
*
* m. winterer 12/5/12 Duisburg + termination 4/25/17
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations 
*
       implicit none
* global variables
*
       integer natom,matom,ncyl,nmatrix,mtyp
       parameter(matom=100000,mtyp=10)
       integer typ(matom),ntyp,ctyp(matom),matyp(matom)
       integer ttyp0,ttyp1
       real xco(matom),yco(matom),zco(matom)
       real crad,cheight,rad,hei,tshell
       real xcy(matom),ycy(matom),zcy(matom),xa,ya,za
       real xma(matom),yma(matom),zma(matom)
       integer idum
       real ranf,rx,ry,rz,tdis,rt3i,dis0,xt,yt,zt,trad
       real gasdev,sig(mtyp)
       external ranf,gasdev
       integer i,coun1,coun2,coun3,coun4,coun5,coun6,count
       character*128 filnam
* initialize randum number generator
       idum=-1
       do i=1,100000
        rx=ranf(idum)
       enddo
       rt3i=sqrt(1./3.)
*
*****c***1********2*******3********4********5********6********7********8
*
* input coordinates
*
       print *,'generation of coordinates inside a cylinder'
       print *,'add terminating atoms to selected atom types'
       print *,' '
       print *,'input filname: '
       read(*,'(a)')filnam
       print *,' '
       print *,'cylinder radius (in a and b direction: '
       read(*,*)crad
       print *,' '
       print *,'cylinder height (in c direction): '
       read(*,*)cheight
       print *,' '
       print *,'thickness of termination shell: '
       read(*,*)tshell
       print *,'terminate atom type: '
       read(*,*)ttyp0
       print *,'by atom type: '
       read(*,*)ttyp1
       print *,'at a distance of: '
       read(*,*)tdis
       print *,'number of types of atoms: '
       read(*,*)ntyp
       print *,'root mean square displacement of atom types: '
       read(*,*)(sig(i),i=1,ntyp)
       print *,' '
       open(15,file=filnam,status='unknown')
       i=0
10     continue 
        i=i+1
        read(15,9000,end=20)i,typ(i),xco(i),yco(i),zco(i)
       goto 10
20     continue
       natom=i-1 
       close(15,status='keep')
       print *,'read number of atoms: ',natom
*
*****c***1********2*******3********4********5********6********7********8
*
* select only atoms inside sphere with radius srad
* and terminate with atoms 
*
       hei=abs(cheight*0.5)
       ncyl=0
       nmatrix=0
       coun1=0
       coun2=0
       coun3=0
       coun4=0
       coun5=0
       coun6=0
       count=0
       do 800 i=1,natom
         xa=xco(i)
	 ya=yco(i)
	 za=zco(i) 
         rad=sqrt(xa*xa+ya*ya)
         if((abs(za).le.hei).and.(rad.le.crad))then
          if((abs(za).gt.(hei-tshell)).or.(rad.gt.(crad-tshell)))then
           if(typ(i).eq.ttyp0)then
            ncyl=ncyl+1
            xcy(ncyl)=xa
            ycy(ncyl)=ya
            zcy(ncyl)=za
	    ctyp(ncyl)=typ(i)
            if(ctyp(ncyl).eq.3)then
             coun3=coun3+1
            else
             print *,'error in atom assignment in shell'
            endif
* terminating by atom typ 4 (e.g. hydrogen)
700         continue
            xt=(2.0*ranf(idum)-1.0)*rt3i
            yt=(2.0*ranf(idum)-1.0)*rt3i
            zt=(2.0*ranf(idum)-1.0)*rt3i 
            trad=sqrt(xt*xt+yt*yt+zt*zt)
            xt=xt*tdis/trad
            yt=yt*tdis/trad
            zt=zt*tdis/trad 
            trad=sqrt(xt*xt+yt*yt+zt*zt)
c            print *,trad
            xt=xt+xa
            yt=yt+ya
            zt=zt+za 
            trad=sqrt(xt*xt+yt*yt+zt*zt)
            dis0=sqrt(xa*xa+ya*ya+za*za)
            if(trad.gt.dis0)then
             ncyl=ncyl+1
             xcy(ncyl)=xt
             ycy(ncyl)=yt
             zcy(ncyl)=zt
             ctyp(ncyl)=ttyp1
             count=count+1
            else
             goto 700
            endif
           endif
          else
           ncyl=ncyl+1
           xcy(ncyl)=xa
           ycy(ncyl)=ya
           zcy(ncyl)=za
	   ctyp(ncyl)=typ(i)
           if(ctyp(ncyl).eq.1)coun1=coun1+1
           if(ctyp(ncyl).eq.2)coun2=coun2+1
           if(ctyp(ncyl).eq.3)coun3=coun3+1
          endif
         else
          nmatrix=nmatrix+1
          xma(nmatrix)=xa
          yma(nmatrix)=ya
          zma(nmatrix)=za
	  matyp(nmatrix)=typ(i)
          if(matyp(nmatrix).eq.1)coun4=coun4+1
          if(matyp(nmatrix).eq.2)coun5=coun5+1
          if(matyp(nmatrix).eq.3)coun6=coun6+1
         endif
800    continue
       write(*,*)'generated lattice points in cylinder: ',ncyl
       write(*,*)'cylinder radius: ',crad
       write(*,*)'cylinder height: ',cheight
       write(*,*)'shell thickness: ',tshell
       write(*,*)'number of atoms of type 1:   ',coun1
       write(*,*)'number of atoms of type 2:   ',coun2
       write(*,*)'number of atoms of type 3:   ',coun3
       write(*,*)'number of terminating atoms: ',count
       write(*,*)' '
       write(*,*)'generated lattice points in matrix: ',nmatrix
       write(*,*)'number of atoms of type 1: ',coun4
       write(*,*)'number of atoms of type 2: ',coun5
       write(*,*)'number of atoms of type 3: ',coun6
       
*****c***1********2*******3********4********5********6********7********8
*
* output atom coordinates 
*
*****c***1********2*******3********4********5********6********7********8
*
       print *,'output atom coordinates to cylinder.coo'

       open(15,file='cylinder.coo',status='unknown')
       do 1001 i=1,ncyl
        xcy(i)=xcy(i)+gasdev(idum)*sig(ctyp(i))
        ycy(i)=ycy(i)+gasdev(idum)*sig(ctyp(i))
        zcy(i)=zcy(i)+gasdev(idum)*sig(ctyp(i))
        write(15,9000)i,ctyp(i),xcy(i),ycy(i),zcy(i),0.0,1.0
1001   continue
       close(15,status='keep')

       open(15,file='matrix.coo',status='unknown')
       do 1002 i=1,nmatrix
        write(15,9000)i,matyp(i),xma(i),yma(i),zma(i),0.0,1.0
1002   continue
       close(15,status='keep')
9000   format(i6,1x,i2,5(1x,g13.6))
*
*****c***1********2*******3********4********5********6********7********8
*
      end
      real function ranf(idum)
*
* random number generator ran3 from numerical recipes
*
      parameter (mbig=1000000000,mseed=161803398,mz=0,fac=1.e-9)
      dimension ma(55)
      data iff /0/
      if(idum.lt.0.or.iff.eq.0)then
        iff=1
        mj=mseed-iabs(idum)
        mj=mod(mj,mbig)
        ma(55)=mj
        mk=1
        do 11 i=1,54
          ii=mod(21*i,55)
          ma(ii)=mk
          mk=mj-mk
          if(mk.lt.mz)mk=mk+mbig
          mj=ma(ii)
11      continue
        do 13 k=1,4
          do 12 i=1,55
            ma(i)=ma(i)-ma(1+mod(i+30,55))
            if(ma(i).lt.mz)ma(i)=ma(i)+mbig
12        continue
13      continue
        inext=0
        inextp=31
        idum=1
      endif
      inext=inext+1
      if(inext.eq.56)inext=1
      inextp=inextp+1
      if(inextp.eq.56)inextp=1
      mj=ma(inext)-ma(inextp)
      if(mj.lt.mz)mj=mj+mbig
      ma(inext)=mj
      ranf=mj*fac
      return
      end
       
*****c***1********2*******3********4********5********6********7********8
*
       function gasdev(idum)
*
*****c***1********2*******3********4********5********6********7********8
*
* gaussian deviate  (Numerical Recipes p.203)
*
*
*****c***1********2*******3********4********5********6********7********8
*
* m. winterer 2/4/97 darmstadt
*
*****c***1********2*******3********4********5********6********7********8
        external ranf
        data iset/0/
	if(iset.eq.0)then
1        v1=2.*ranf(idum)-1.
         v2=2.*ranf(idum)-1.
	 r=v1*v1+v2*v2
	 if(r.ge.1.0)goto 1
	 fac=sqrt(-2.*log(r)/r)
	 gset=v1*fac
	 gasdev=v2*fac
	 iset=1
	else
	 gasdev=gset
	 iset=0
	endif
	return
	end



