*****c***1********2*******3********4********5********6********7********8
*
       program transfo
*
*****c***1********2*******3********4********5********6********7********8
*
* coordinate transfortions
*
* m. winterer 12/9/98, generalized on 12/30/98
* revised 11/28/14mw
*
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       integer hn,kn,ln,iol,matom,natom,i,j,num1,num2,n
       parameter(matom=100000)
       integer typ(matom)
       real alatt,blatt,clatt
       real alpha,beta,gamma
       real alphad,betad,gammad
       real xc(matom),yc(matom),zc(matom),a(matom),b(matom),c(matom) 
       real volume,hmat(3,3),hinv(3,3)
       real volume1,hmat1(3,3),hinv1(3,3)
       real pi
       character*1 tmode,imode,omode
       character*1 dum
       character*256 filnam
       
       pi=4.*atan(1.0)
*
* input modes:
*
*   input rmc(x)as coordinates
*   input rmc(a) coordinates
*
* transformation modes
*
*   convert (c)artesian coordinates to orthogonal
*   convert (o)rthogonal coordinates to cartesian
*

       iol=10
       print *,'transformation of coordinates'
       print *,' '
       open (unit=iol,file='transfo.par',status='unknown')

        read(iol,'(a)')filnam
        read(iol,'(a)')imode
        read(iol,'(a)')tmode
        read(iol,'(a)')omode

        read(iol,*)num1,num2

        read(iol,*)alatt
        read(iol,*)blatt
        read(iol,*)clatt
       
        read(iol,*)hn
        read(iol,*)kn
        read(iol,*)ln
       
        read(iol,*)alphad
        read(iol,*)betad
        read(iol,*)gammad
       close(iol,status='keep')

       print *,' '
       print *,'INPUT'
       print *,' '
       print *,'input mode:          ',imode
       print *,'transformation mode: ',tmode
       print *,'output mode:         ',omode
       print *,' '
       print *,'alatt= ',alatt
       print *,'blatt= ',blatt
       print *,'clatt= ',clatt
       print *,'hn ',hn
       print *,'kn ',kn
       print *,'ln ',ln
       print *,'alpha= ',alphad
       print *,'beta= ',betad
       print *,'gamma= ',gammad
       print *,' '
*
* input coordinates
*
       open(unit=16,file=filnam,status='unknown')

        if(imode.eq.'x')then
        i=0
99      continue
         i=i+1
         if(tmode.eq.'c')then
          read(16,*,end=100)j,typ(i),xc(i),yc(i),zc(i)
         elseif(tmode.eq.'o')then
          read(16,*,end=100)j,typ(i),a(i),b(i),c(i)
         endif
        goto 99
100     continue

        elseif(imode.eq.'a')then
         do i=1,26
          read(16,'(a)')dum
c          print *,dum
         enddo
        i=0
101     continue
         i=i+1
         if(tmode.eq.'c')then
          read(16,*,end=102)xc(i),yc(i),zc(i)
         elseif(tmode.eq.'o')then
          read(16,*,end=102)a(i),b(i),c(i)
          a(i)=0.5*a(i)
          b(i)=0.5*b(i)
          c(i)=0.5*c(i)
         endif
         if(i.le.num1)then
          typ(i)=1
         else
          typ(i)=2
         endif
c         print *,i,typ(i),xc(i),yc(i),zc(i)
        goto 101 
102     continue
        else
         print *,'no such intput mode: ',imode
        endif
        natom=i-1         
       close(unit=16,status='keep')
       print *,'input atom coordinates: ',natom
       if(imode.eq.'a')then
        if(num1+num2.ne.natom)then
         print *,'number of atoms inconsistent: ',num1+num2,' /= ',natom
        stop
        endif
       endif
*
* create transformation matrices
*
       alpha=alphad*pi/180.
       beta= betad*pi/180.
       gamma=gammad*pi/180.

       print *,'TRANSFORMATION  11/28/14MW'
       print *,' '
       print *,'create transformation matrices'
       print *,' '

       call makehm(alatt,blatt,clatt,hn,kn,ln,
     1                   alpha,beta,gamma,volume,hmat)
       call makehi(alatt,blatt,clatt,hn,kn,ln,
     1                   alpha,beta,gamma,volume,hinv)
       print *,'volume:  ',volume
       print *,'density: ',float(natom)/volume

*
* transformation
*
       if(tmode.eq.'c')then

        do i=1,natom
         call tranco(xc(i),yc(i),zc(i),hinv,a(i),b(i),c(i))
c         print *,xc(i),yc(i),zc(i),a(i),b(i),c(i)
        enddo

       elseif(tmode.eq.'o')then
       
        do i=1,natom
         call tranco(a(i),b(i),c(i),hmat,xc(i),yc(i),zc(i))
        enddo

       else

         print *,'no such transformation mode: ',tmode

       endif
*
* output
*
       print *,' '
       print *,'OUTPUT'

       if(omode.eq.'x')then
        
        open(11,file='transfo.ort',status='unknown')
        do i=1,natom
         write(11,9000)i,typ(i),a(i),b(i),c(i),0.0
c         print *, i,typ(i),a(i),b(i),c(i),0.0
        enddo
        close(11,status='keep')

        open(11,file='transfo.coo',status='unknown')
        do i=1,natom
         write(11,9000)i,typ(i),xc(i),yc(i),zc(i),0.0
c         print *, i,typ(i),xc(i),yc(i),zc(i),0.0
        enddo
        close(11,status='keep')

       elseif(omode.eq.'a')then

        if(imode.eq.'a')then
         open(11,file='transfo.ort',status='unknown')
         do i=1,natom
          write(11,*)2.*a(i),2.*b(i),2.*c(i)
         enddo
         close(11,status='keep')

         open(11,file='transfo.coo',status='unknown')
         do i=1,natom
          write(11,*)xc(i),yc(i),zc(i)
         enddo
         close(11,status='keep')
        else
         open(11,file='transfo.ort',status='unknown')
          n=0
          do i=1,natom
           if(typ(i).eq.1)then
            n=n+1
            write(11,*)2.*a(i),2.*b(i),2.*c(i)
           endif
          enddo
          print *,'number of atoms of type 1: ',n
          n=0
          do i=1,natom
           if(typ(i).eq.2)then
            n=n+1
            write(11,*)2.*a(i),2.*b(i),2.*c(i)
           endif
          enddo
          print *,'number of atoms of type 2: ',n
         close(11,status='keep')

         open(11,file='transfo.coo',status='unknown')
          do i=1,natom
           if(typ(i).eq.1)then
            write(11,*)xc(i),yc(i),zc(i)
           endif
          enddo
          do i=1,natom
           if(typ(i).eq.2)then
            write(11,*)xc(i),yc(i),zc(i)
           endif
          enddo
         close(11,status='keep')
        endif
       else
        print *,'no such output mode: ',omode
       endif

9000   format(i6,1x,i2,4(1x,g13.6))

*       
       end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine makehm(alatt,blatt,clatt,hn,kn,ln,
     1                   alpha,beta,gamma,volume,hmat)
*
*****c***1********2*******3********4********5********6********7********8
*
* matrix algebra for Reverse Monte Carlo (Parinello-Rahman):
*
* make transformation matrix H for transformation 
* from cartesian to crystallographic coordinates
*
* source:  C. Giacovazzo, Fundamentals of Crystallography, 68pp.
*
* m. winterer 3/5/98
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       integer hn,kn,ln
       real alatt,blatt,clatt,alpha,beta,gamma
       real a,b,c
       real volume,cosa,cosb,cosg,sinb,sing,cosas,cs
       real hmat(3,3)
*
* geometric factors
*
       a=real(hn)*alatt
       b=real(kn)*blatt
       c=real(ln)*clatt
       
       cosa=sngl(dcos(dble(alpha)))
       cosb=sngl(dcos(dble(beta)))
       cosg=sngl(dcos(dble(gamma)))
       sinb=sngl(dsin(dble(beta)))
       sing=sngl(dsin(dble(gamma)))
       
       cosas=(cosb*cosg-cosa)/(sinb*sing)
       
       volume=a*b*c*
     1        sqrt(1.0-cosa*cosa-cosb*cosb-cosg*cosg
     2             + 2.0*cosa*cosb*cosg)
       
       cs=a*b*sing/volume
*
* matrix elements
*
       hmat(1,1)= a
       hmat(1,2)= 0.0
       hmat(1,3)= 0.0
       hmat(2,1)= b*cosg
       hmat(2,2)= b*sing
       hmat(2,3)= 0.0
       hmat(3,1)= c*cosb
       hmat(3,2)=-c*sinb*cosas 
       hmat(3,3)= 1.0/cs
              
       return
       end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine makehi(alatt,blatt,clatt,hn,kn,ln,
     1                   alpha,beta,gamma,volume,hinv)
*
*****c***1********2*******3********4********5********6********7********8
*
* matrix algebra for Reverse Monte Carlo (Parinello-Rahman):
*
* make inverse transformation matrix HI for transformation 
* from crystallographic to cartesian coordinates
*
* source:  C. Giacovazzo, Fundamentals of Crystallography, 68pp.
*
* m. winterer 3/5/98
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       integer hn,kn,ln
       real alatt,blatt,clatt,alpha,beta,gamma
       real a,b,c
       real volume,cosa,cosb,cosg,sina,sinb,sing
       real cosas,cosbs,as,bs,cs
       real hinv(3,3)
*
* geometric factors
*
       a=real(hn)*alatt
       b=real(kn)*blatt
       c=real(ln)*clatt
       
       cosa=sngl(dcos(dble(alpha)))
       cosb=sngl(dcos(dble(beta)))
       cosg=sngl(dcos(dble(gamma)))
       sina=sngl(dsin(dble(alpha)))
       sinb=sngl(dsin(dble(beta)))
       sing=sngl(dsin(dble(gamma)))
       cosas=(cosb*cosg-cosa)/(sinb*sing)
       cosbs=(cosa*cosg-cosb)/(sina*sing)
              
       as=b*c*sina/volume
       bs=a*c*sinb/volume
       cs=a*b*sing/volume
*
* matrix elements
*
       hinv(1,1)= 1./a
       hinv(1,2)= 0.0
       hinv(1,3)= 0.0
       hinv(2,1)=-cosg/(a*sing)
       hinv(2,2)= 1./(b*sing)
       hinv(2,3)= 0.0
       hinv(3,1)= as*cosbs
       hinv(3,2)= bs*cosas 
       hinv(3,3)= cs
              
       return
       end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine tranco(x,y,z,hmat,a,b,c)
*
*****c***1********2*******3********4********5********6********7********8
*
* matrix algebra for Reverse Monte Carlo (Parinello-Rahman):
*
* (tran)sformation from cartesian ( (o)rthogonal (x)
*                to                 (c)rystallographic (a) coordinates
* a = H.x
*
* source:  C. Giacovazzo, Fundamentals of Crystallography, 68pp.
* and:     M. Parrinello, and A. Rahman, J. Appl. Phys. 52 (1981), 7182
*
* m. winterer 3/5/98
* revised 11/28/14mw
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       real a,b,c,x,y,z,hmat(3,3)
*
*
* transformation 
*
c       a=x*hmat(1,1)
c       b=x*hmat(2,1)+y*hmat(2,2)
c       c=x*hmat(3,1)+y*hmat(3,2)+z*hmat(3,3)

        a=x*hmat(1,1)+y*hmat(2,1)+z*hmat(3,1)
        b=            y*hmat(2,2)+z*hmat(3,2)
        c=                        z*hmat(3,3)

              
       return
       end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine tranoc(a,b,c,hinv,x,y,z)
*
*****c***1********2*******3********4********5********6********7********8
*
* matrix algebra for Reverse Monte Carlo (Parinello-Rahman):
*
* (tran)sformation from (c)rystallographic (a) 
* to        cartesian ( (o)rthogonal       (x) coordinates
* x = HI.a
*
* source:  C. Giacovazzo, Fundamentals of Crystallography, 68pp.
* and:     M. Parrinello, and A. Rahman, J. Appl. Phys. 52 (1981), 7182
*
* m. winterer 3/5/98
* revised 11/28/14mw
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       real a,b,c,x,y,z,hinv(3,3)
*
*
* transformation
*
c       x=a*hinv(1,1)
c       y=a*hinv(2,1)+b*hinv(2,2)
c       z=a*hinv(3,1)+b*hinv(3,2)+c*hinv(3,3)

       x=a*hinv(1,1)+b*hinv(2,1)+c*hinv(3,1)
       y=            b*hinv(2,2)+c*hinv(3,2)
       z=                        c*hinv(3,3)

              
       return
       end

