*****c***1********2*******3********4********5********6********7********8
*
      program rmc2fef 
*
*****c***1********2*******3********4********5********6********7********8
*
* select and convert coordinates form rmc results to feff input 
*
*****c***1********2*******3********4********5********6********7********8
*
* m. winterer 4/21/98 darmstadt
* include sorting according to distance from central atom mw5/21/01
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations 
*
       implicit none
* global variables
*
       integer natom,matom,nsphere
       parameter(matom=100000)
       integer typ(matom),mtyp,ntyp,styp(matom),list(matom)
       real xco(matom),yco(matom),zco(matom),dist(matom)
       integer ic,tc,nc,l
       real xc,yc,zc,xs,ys,zs
       real xsl,ysl,zsl,xsu,ysu,zsu,box,search
       real srad,rad
       real xsp(matom),ysp(matom),zsp(matom),xa,ya,za
       integer i,coun1,coun2
       character*128 filnam
       logical found
*****c***1********2*******3********4********5********6********7********8
*
       print *,'select and convert rmc coordinates to feff input '
       print *,' '
       print *,'input filname: '
       read(*,'(a)')filnam
       print *,' '
       print *,'sphere radius: '
       read(*,*)srad
       print *,' '
       print *,'central atom coordinate (x,y,z),itype:'
       read(*,*)xc,yc,zc,ic
       print *,'central atom search box:'
       read(*,*)search
       print *,' '
       open(15,file=filnam,status='unknown')
       i=0
       box=0.0
       found=.false.
       xsu=xc+search
       ysu=yc+search
       zsu=zc+search
       xsl=xc-search
       ysl=yc-search
       zsl=zc-search
10     continue 
        i=i+1
        read(15,9000,end=20)i,typ(i),xco(i),yco(i),zco(i)
        xa=xco(i)
        ya=yco(i)
        za=zco(i)
c        box=amax1(xa,box)
c        box=amax1(ya,box)
c        box=amax1(za,box)
        if((.not.found).and.(xa.le.xsu).and.(xa.ge.xsl).and.
     1     (ya.le.ysu).and.(ya.ge.ysl).and.
     2     (za.le.zsu).and.(za.ge.zsl).and.typ(i).eq.ic)then
           found=.true.
           nc=i
           tc=typ(i)
           typ(i)=0
           xc=xa
           yc=ya
           zc=za
        endif
       goto 10
20     continue
       natom=i-1 
       close(15,status='keep')
       print *,'read number of atoms: ',natom
       print *,' '
       if(found)then
        print *,'central atom: '
        print *,nc,xc,yc,zc,tc
       else
        stop 'no central atom found'
       endif
*
*****c***1********2*******3********4********5********6********7********8
*
* select only atoms inside sphere with radius srad
* and terminate with atoms 
*
       nsphere=0
       do 800 i=1,natom
         xa=xco(i)
	 ya=yco(i)
	 za=zco(i) 
         rad=sqrt((xa-xc)*(xa-xc)+(ya-yc)*(ya-yc)+(za-zc)*(za-zc))
         if(rad.le.srad)then
           nsphere=nsphere+1
           xsp(nsphere)=xa
           ysp(nsphere)=ya
           zsp(nsphere)=za
	   styp(nsphere)=typ(i)
           dist(nsphere)=rad
         endif
800    continue
       print *,'lattice points: ',nsphere
       print *,'in sphere of radius: ',srad
       print *,' '
*****c***1********2*******3********4********5********6********7********8
*
* sort by indexing
*
       call indexx(matom,nsphere,dist,list)
       print *,'sorted by distance from central atom'
*
*****c***1********2*******3********4********5********6********7********8
*
* output atom coordinates 
*
*****c***1********2*******3********4********5********6********7********8
*
       print *,'output coordinates in feff format to "feff.rmc"'
       print *,'and transform to have center at origin'
       print *,' '
       open(15,file='feff.rmc',status='unknown')
       do 1001 i=1,nsphere
        l=list(i)
        write(15,9001)xsp(l)-xc,ysp(l)-yc,zsp(l)-zc,styp(l),dist(l)
1001   continue
       close(15,status='keep')
9000   format(i6,1x,i2,4(1x,g13.6))
9001   format(3(1x,g13.6),1x,i2,1x,g13.6)
*
*****c***1********2*******3********4********5********6********7********8
*
      end
*****c***1********2*******3********4********5********6********7********8
*
      SUBROUTINE INDEXX(M,N,ARRIN,INDX)
      DIMENSION ARRIN(M),INDX(M)
      DO 11 J=1,N
        INDX(J)=J
11    CONTINUE
      L=N/2+1
      IR=N
10    CONTINUE
        IF(L.GT.1)THEN
          L=L-1
          INDXT=INDX(L)
          Q=ARRIN(INDXT)
        ELSE
          INDXT=INDX(IR)
          Q=ARRIN(INDXT)
          INDX(IR)=INDX(1)
          IR=IR-1
          IF(IR.EQ.1)THEN
            INDX(1)=INDXT
            RETURN
          ENDIF
        ENDIF
        I=L
        J=L+L
20      IF(J.LE.IR)THEN
          IF(J.LT.IR)THEN
            IF(ARRIN(INDX(J)).LT.ARRIN(INDX(J+1)))J=J+1
          ENDIF
          IF(Q.LT.ARRIN(INDX(J)))THEN
            INDX(I)=INDX(J)
            I=J
            J=J+J
          ELSE
            J=IR+1
          ENDIF
        GO TO 20
        ENDIF
        INDX(I)=INDXT
      GO TO 10
      END

