*****c***1********2*******3********4********5********6********7********8
*
       program pdf2xas
*
******c***1********2*******3********4********5********6********7********8
*
* compute EXAFS from (modified) pPDFs
*  using rmcxas code from 4/14/25
*
******c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
* additional variables for multiple phases
       integer mphas,nphas,np
       parameter(mphas=3)
       real xfrac(mphas),xfracn
* additional variables for multiple spectra
       integer mspec,nspec
       parameter(mspec=3)
* global variables for subroutine estima
       integer mdat,ndat(mspec),idat
       parameter(mdat=1024)
       real dat(mdat,mspec),sim(mdat,mspec),one(mspec)
       real resq(mspec),chisqx1(mspec),chisqx,chisq
       integer idum
* global variables for pdf
       integer iatom
       integer mhis,nhis,nhisx,nhisd,mtyp,ntyp,matom,natom(mphas)
       integer mpdf,npdf(mphas),npdfind(mphas)
       parameter(mhis=5000)
       parameter(mtyp=5)
       parameter(mpdf=(mtyp*mtyp+mtyp)/2)
       real rad(mhis),r,rdelta
       real deltar,rmax,rmaxx,rmaxd,rho(mphas),pi,close(mpdf)
       real dmin,dmax
* global variables for pdfini
       real gij(mhis,mpdf),conc(mtyp),cut,dens(mtyp)
* global variables for pdfcon
       real con(mhis,mpdf)
* global variables for xafscw
       real gam(mdat,mhis,mtyp,mtyp),chitrunc(mdat,mtyp,mtyp)
       real vec(mdat,mspec),amp(mdat,mhis,mtyp,mtyp)
       real pha(mdat,mhis,mtyp,mtyp),laminv(mdat,mhis,mtyp,mtyp)
       real kpow(mdat,mspec),weight(mtyp)
* global variables for inexp
       real ery(mdat,mspec)
       character*31 filexp(mspec)
       integer neh(mspec),nex(mspec),ney(mspec),nee(mspec)
       real vec1(mdat),dat1(mdat),ery1(mdat),errmod1
* global variables for intheo
       real s02(mspec),e0shft(mspec),e01
* global variables for outspe
       real rag(mspec) 
* global variables for inpar
       integer hn(mphas),kn(mphas),ln(mphas),ncyc,nout,nh
       real power,errmod(mspec),sig2(mspec)
       character*1 imode
       character*80 title,header
* variables for rmcxas
       integer i,j,ioc,iol,icyc,imove,nclose,naccpo,l,m
       integer lisp(mtyp,mtyp),list(2,mtyp*(mtyp+1)/2)
       real gijtry(mhis,mpdf)
       character*31 filspe,filpdf,fillog
       character*80 version
* variables to detect and save process identification number (PID)
c       integer*4 getpid,ipid
c       integer getpid,ipid
c       external getpid
       integer ipid
* additional variables for multisite absorbers
       integer nscat(mphas),nabs(mphas),listsit(mtyp),nabss,ispec
       integer listabs(mtyp),ntpa(mtyp),ntpe(mtyp),nta,nte,iabs
       integer npdftot,npdfcom,ipdfa(mphas),ipdfe(mphas),listpdf(mpdf)
       integer ipdfex(mphas),ipdfed(mphas),listpdfx(mpdf),listpdfd(mpdf)
       integer npdfd,npdfx
       real sitsim(mdat,mtyp),wspc(mtyp)
* variables for regions in PDF
       integer mr,nr,n
       parameter(mr=100)
       integer ng(mr)
       real r1(mr),r2(mr),gv(mr)
*
       logical ini
*
* common blocks
      common /const/ pi
* initialize pi
       pi=4.0*real(datan(1.0d0))
*
******c***1********2*******3********4********5********6********7********8
*
* initializations
*
        version='PDF2XAS 09/03/25mw mac silicon gf'
* get process ID
        ipid=getpid()
        print *,version
        print *,'PID ',ipid
        print *,' '
*
******c***1********2*******3********4********5********6********7********8
*
* open file for log book
*
        iol=16
        fillog='pdf2xas.log'
        open(unit=iol,file=fillog,status='unknown',err=9990)
        write(iol,*)version
        write(iol,*)' '
        write(iol,*)'PID: ',ipid
        write(iol,*)' '
        print *,'open log book'
*
* input 
*
        write(iol,*)' '
        print *,'Be AWARE that this procedure does NOT conserve '
        print *,' number density of atoms '
        print *,' '
        write(iol,*)'Be AWARE that this procedure does NOT conserve '
        write(iol,*)' number density of atoms and '
        write(iol,*)' integration of pPDFs is not updated'
        write(iol,*)' '
        write(iol,*)'INPUT PARAMETERS: '
        write(iol,*)' '

        call inpar(mphas,nphas,mspec,nspec,mtyp,ntyp,
     1  nscat,nabs,listsit,iol,title,rho,xfrac,conc,
     2  power,e0shft,s02,sig2,errmod,filexp,neh,nex,ney,nee,
     3  filpdf,mr,nr,ng,r1,r2,gv)
        print *,filpdf
        print *,filexp
*
        print *,'input parameters'
        write(iol,*)' '
        write(iol,*)'START COMPUTATION: '
        write(iol,*)' '
*
* normalize phase fractions provided by inpar
*
        xfracn=0.0
        do 200 m=1,nphas
         xfracn=xfracn+xfrac(m)
200     continue
        do 201 m=1,nphas
         xfrac(m)=xfrac(m)/xfracn
         write(iol,*)'molar fraction of phase  ',m,' : ',xfrac(m)
201     continue
       write(iol,*)' '
*
* input experiment(s)
*
       write(iol,*)' '
       write(iol,*)'INPUT EXAFS DATA'
*
*****c***1********2*******3********4********5********6********7********8
*
* EXAFS
*
       if(nspec.gt.0)then
       write(iol,*)' '
       write(iol,*)'EXAFS'
       call initd(mspec,mspec,one,1.0)
       call initd2(mdat,mdat,mspec,nspec,sim,0.0)
       call initd2(mdat,mdat,mspec,nspec,kpow,1.0)
       do 320 l=1,nspec
       print *,'input spectrum no. ',l,' from ',filexp(l)
       write(iol,*)'input spectrum no. ',l,' from ',filexp(l)
       errmod1=errmod(l)
       e01=e0shft(l)
       call indat(mdat,ndat(l),filexp(l),neh(l),nex(l),ney(l),nee(l),
     1            vec1,dat1,ery1,iol)
       call xasdat(mdat,ndat(l),vec1,dat1,ery1,resq(l),power,
     1             errmod1,e01,iol)
       do 310 i=1,ndat(l)
        vec(i,l)=vec1(i)
        dat(i,l)=dat1(i)
        ery(i,l)=ery1(i)
310    continue
       if(ndat(l).le.0)then
        write(iol,*)'ERROR: no experimental data found '
        stop
       endif
*
* initialize kpow (wheighting of theoretical spectrum)
*
       if(power.ne.0.0)then
        do 300 i=1,ndat(l)
	 r=vec(i,l)
         if(r.eq.0.0)then
           kpow(i,l)=1.0
         else
           kpow(i,l)=vec(i,l)**(power-1.0)
         endif
300     continue
       endif
320    continue
       endif
*
*****c***1********2*******3********4********5********6********7********8
*
* Initialize partial pair distribution functions
*
*****c***1********2*******3********4********5********6********7********8
       write(iol,*)' '
       write(iol,*)'Initialize pPDFs'
       write(iol,*)' '
*
* make matrix of labeling numbers of pdfs: lisp
*
       call lispdf(mphas,nphas,mtyp,ntyp,nscat,lisp,list,
     1             ntpa,ntpe,npdftot,iol)
*
       npdfcom=0 
       nabss=0
       npdfd=0
       do l=1,nphas
        nabss=nabss+nabs(l)
        npdfind(l)=nscat(l)*(nscat(l)+1)/2
        npdfd=npdfd+npdfind(l)
        npdf(l)=nscat(l)*(nscat(l)+1)/2-
     1         (nscat(l)-nabs(l))*((nscat(l)-nabs(l))+1)/2
        npdfcom=npdfcom+npdf(l)
        print *,'phase number ',l
        print *,'number of partial pair distribution ',
     1          'functions (pPDFs): ',npdf(l)
        write(iol,*)'phase number ',l
        write(iol,*)'number of independent pPDFs: ',npdfind(l)
        write(iol,*)' '
       enddo
       write(iol,*)'# of pPDFs to compute (EXAFS): ',npdfcom
       write(iol,*)' '
*****c***1********2*******3********4********5********6********7********8
*
      call inipdf(mphas,nphas,mtyp,ntyp,nspec,nscat,nabs,
     1            listsit,listabs,mhis,nhisx,mpdf,ipdfa,ipdfex,
     2            iol,listpdfx,rho,xfrac,conc,dens,weight,wspc)
*
*****c***1********2*******3********4********5********6********7********8
       nhis=nhisx
       npdfx=npdfcom
       do l=1,nphas
        ipdfe(l)=ipdfex(l)
       enddo
       do l=1,npdfcom
        listpdf(l)=listpdfx(l)
       enddo
       print *,'# of pPDFs to compute (EXAFS): ',npdfcom
       write(iol,*)'# of pPDFs to compute (EXAFS): ',npdfcom
       write(iol,*)' '
       write(iol,*)'total number of absorbers: ',nabss
       write(iol,*)' '
*
*****c***1********2*******3********4********5********6********7********8
*
      call initd2(mhis,mhis,mpdf,mpdf,gij,0.0)
      call initd2(mhis,mhis,mpdf,mpdf,con,0.0)
*
*****c***1********2*******3********4********5********6********7********8
*
       call inpdf(mhis,nhis,mtyp,ntyp,mpdf,npdfcom,rad,gij,con,
     1                listpdf,filpdf,iol)
       cut=rad(1)
       rmaxx=rad(nhis)
       rmax=rmaxx
       deltar=rad(2)-rad(1)
       rdelta=1.0/deltar
       nhisx=int((rmaxx-cut)*rdelta)+1
       print *,cut,rmaxx,deltar,rdelta
       if(nhisx.gt.mhis)then
        write(iol,*)'error: exafs',
     1  'number of bins exceeds physical storage: ',nhisx,' > ',mhis
        print *,'error: ',
     1  'number of bins exceeds physical storage: ',nhisx,' > ',mhis
       stop
      endif
*
*****c***1********2*******3********4********5********6********7********8
*
* Compute modified partial pair distribution functions
*
       do n=1,nr
        do m=1,nphas
         do j=ipdfa(m),ipdfe(m)
          do i=1,nhis
           if(j.eq.ng(n))then
            if((rad(i).ge.r1(n)).and.(rad(i).le.r2(n)))then
             gij(i,j)=gv(n)
            endif
           endif
          enddo
         enddo
        enddo
       enddo
*
* output distribution function 
*
       filpdf='                               '
       filpdf='rmc.pdf.sim'
       call outpdf(mhis,nhis,mtyp,ntyp,mpdf,npdfcom,rad,gij,con,
     1                listpdf,filpdf,iol)
       print *,'output modified pdf'
       write(iol,*)'output modified pdf to ',filpdf
*
*****c***1********2*******3********4********5********6********7********8
*
       chisq=0.0
*
* Initialize and compute initial EXAFS spectra
*
* 1. input theory from feff output (feff####.dat)
*
*****c***1********2*******3********4********5********6********7********8
*
      if(nspec.gt.0)then
      write(iol,*)' '
      write(iol,*)'EXAFS '
      write(iol,*)'INPUT THEORETICAL DATA (FEFF): '
      write(iol,*)' '
      write(iol,*)
     1 'Ispe Iabs Isca Zabs Zsca nleg  deg   reff       rs ',
     2 '       edge       file'
      print *,' '
      print *,'INPUT THEORETICAL DATA (FEFF): '
c      print *,' '
c      print *,
c     1 'Ispe Iabs Isca Zabs Zsca nleg  deg reff  rs edge file'

c      print *,'ff2chi ',nhisx
      call ff2chi(iol,mtyp,nabss,mtyp,ntyp,mhis,nhisx,listsit,
     1            listabs,mdat,ndat,s02,sig2,vec,rad,amp,pha,laminv)
*
*****c***1********2*******3********4********5********6********7********8
*
* exafs kernels 
*
*****c***1********2*******3********4********5********6********7********8
*
       print *,'exafs kernels'
       do l=1,nspec
        do n=1,nabss
         iabs=listabs(n)
         ispec=listsit(iabs)
         if(ispec.eq.l)then
         nta=ntpa(listabs(n))
         nte=ntpe(listabs(n))
c         print *,'gamx ',nhisx
         call gamx(mdat,ndat(l),mhis,nhisx,mtyp,nta,nte,iabs,
     1           mspec,l,rad,vec,amp,pha,laminv,gam,deltar)
c         print *,'gamt ',nhisx
         call gamt(mdat,ndat(l),mhis,nhisx,mtyp,nta,nte,iabs,mpdf,
     1            mspec,l,vec,rad,amp,pha,laminv,chitrunc,deltar) 
         endif
        enddo
       enddo 
*
*****c***1********2*******3********4********5********6********7********8
*
* calculate exafs spectrum from modified pdf and feff input
*
       do 410 l=1,nspec
        do idat=1,ndat(l)
         sim(idat,l)=0.0
        enddo
*
*  spectra: loop over all absorber sites contributing to 
*  spectrum l
*
       do n=1,nabss
        iabs=listabs(n)
        ispec=listsit(iabs) 
        if(ispec.eq.l)then
          nta=ntpa(listabs(n))
          nte=ntpe(listabs(n))
          call xafscw(mdat,ndat(l),mhis,nhisx,mtyp,nta,nte,mpdf,lisp,
     1                conc,dens,wspc,mspec,l,iabs,gij,gam,chitrunc,
     2                kpow,sitsim,deltar)
         do idat=1,ndat(l)
          sim(idat,l)=sim(idat,l)+
     1                            weight(iabs)*sitsim(idat,iabs)
         enddo
        endif
       enddo
*
       print *,'calculate initial spectrum'
*     
* maximum likelihood estimator chi-square:
*
* compute cost function
*
       call estima(mdat,ndat(l),mspec,l,dat,sim,resq,chisqx1(l))
       write(iol,*)' '
       write(iol,*)'INITIAL COMPUTATION'
       write(iol,*)' '
       write(iol,*)'initial chisq: ',chisqx1(l)
       print *,'calculate initial chisq ',chisqx1(l)
*
* output initial spectrum and distribution function 
*
       filspe='rmc.spe.sim.'//char(48+l)
       call outspe(mdat,ndat(l),mspec,l,vec,dat,sim,sim,sim,ery,
     1                                           rag(l),filspe,iol)
       print *,'output simulated spectra'
       write(iol,*)'output modified pdf to ',filspe
410    continue
*
       chisqx=0
       do 411 l=1,nspec
        chisqx=chisqx+chisqx1(l)
411    continue
       endif
*
* total initial chisq
*
       chisq=chisqx
*
* output general results to logbook
*
       if(nspec.gt.0)then
        write(iol,*)' '
        write(iol,*)'EXAFS '
        write(iol,*)'final chi-squared ',chisqx
        write(iol,*)'final R [%]: ',(rag(l),l=1,nspec)
       endif
******c***1********2*******3********4********5********6********7********8
*
       stop
9990   continue
       print *,'pdf2xas: open file error'
       stop
       end

