*****c***1********2*******3********4********5********6********7********8
*
      subroutine inipdf(mphas,nphas,mtyp,ntyp,nspec,nscat,nabs,
     1                  listsit,listabs,mhis,nhisx,mpdf,ipdfa,ipdfex,
     2                  iol,listpdfx,rho,xfrac,conc,dens,weight,wspc)
*
*****c***1********2*******3********4********5********6********7********8
*
* initialize concentrations etc.
*
*****c***1********2*******3********4********5********6********7********8
*
*     m. winterer 3/27/98 Darmstadt
*
* changes due to multisite 06/09/2020mw
*
* change normalization of weight for spectra (and absorber) only in
* one of multiple phases 2/1/22mw
*
* modified for pdf2xas 09/03/2025 mw
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
* global variables
*
      implicit none
      integer mphas,nphas,m,np,mspec,nspec
      integer mpdf,nhisx,nhisd,mhis,mtyp,ntyp
      integer i,iol,l,bin,ia,ie,na,ne,ied
      integer ipdfa(mphas),ipdfex(mphas)
      integer listpdfx(mpdf),nl,nld
      real conc(mtyp)
      real rlo,rad(mhis),weight(mtyp),xfrac(mphas),rho(mphas)
      real dens(mtyp)
* multisite
      integer maxtyp,maxphas,j,n,iabs,ispec
      parameter (maxtyp=20,maxphas=5,mspec=10)
      integer nscat(mphas),nabs(mphas),nabss
      integer listsit(mtyp),listabs(mtyp)
      real concs(maxtyp,maxphas)
      real wspc(mtyp),wsum(mspec)
      logical ini
*
      if(nspec.gt.mspec)then
       stop 'WARNING: nspec > mspec in inipdf'
      endif
      if(mtyp.gt.maxtyp)then
       stop 'WARNING: mtyp > maxtyp in inipdf'
      endif
      if(mphas.gt.maxphas)then
       stop 'WARNING: mphas > maxphas in inipdf'
      endif
*
*****c***1********2*******3********4********5********6********7********8
*
* initialization
*
      do m=1,mtyp
       listabs(m)=0
      enddo
      m=0
      do n=1,ntyp
       if(listsit(n).ne.0)then
        m=m+1
        listabs(m)=n
       endif
      enddo
      if(ini)then
      write(iol,*)' '
      write(iol,*)'list of absorber types '
      write(iol,*)' '
      write(iol,*)'i iabs ispec'
      write(iol,*)'------------ '
      endif
      nabss=0
      do np=1,nphas
       nabss=nabss+nabs(np)
      enddo
      if(ini)then
      do n=1,nabss
       write(iol,*)n,listabs(n),listsit(listabs(n))
      enddo
      write(iol,*)' '
      endif

* use only cutoffs of pdf's used for xafs!
      ia=0
      nl=0
      nld=0
      do 12 l=1,nphas
       ie=ia+nscat(l)*(nscat(l)+1)/2-
     1      (nscat(l)-nabs(l))*((nscat(l)-nabs(l))+1)/2
       ia=ia+1
       ipdfa(l)=ia
       ipdfex(l)=ie
* exafs
       do 10 i=ia,ie
        nl=nl+1
        listpdfx(nl)=i
10     continue
       ia=ia+nscat(l)*(nscat(l)+1)/2-1
12    continue
*
* calculate atom concentrations
*
* (to do, if nessary check here for consistent atom types,
*  atoms in all phases have to be of different type now)
*
      na=1
      ne=0
      do 52 m=1,nphas
      ne=ne+nscat(m)
      do 51 l=na,ne
       dens(l)=conc(l)*rho(m)
       weight(l)=xfrac(m)
       write(iol,*)'fraction of atom type ',
     1                              l,' in phase ',m,' = ',conc(l)
51     continue
      na=ne+1
52    continue
*
* weights of multiple absorbers in a single phase to a single spectrum
*
        do m=1,maxphas
         do i=1,maxtyp
          concs(i,m)=0.0
         enddo 
        enddo
        do i=1,mtyp
         wspc(i)=1.0
        enddo
*
        ia=1
        do np=1,nphas
         ie=ia+nscat(np)-1
         do i=ia,ie
          l=listsit(i)
          if(l.ne.0)then
           concs(l,np)=concs(l,np)+conc(i)
          endif
c          print *,np,ia,ie,i,l,conc(i),concs(l,np)
         enddo
         do i=ia,ie
          l=listsit(i)
          if(l.ne.0)then
           wspc(i)=conc(i)/concs(l,np)
c           print *,ia,ie,i,l,conc(i),concs(l,np),wspc(i)
          endif
         enddo
         ia=ie+1
        enddo
*
* contribution of absorbers in different phases to a single spectrum
*
        do n=1,nspec
         wsum(n)=0.0
        enddo
        do i=1,nabss
         iabs=listabs(i)
         ispec=listsit(iabs)
         do n=1,nspec
          if(ispec.eq.n)then
           wsum(n)=wsum(n)+weight(iabs)
c           print *,i,n,iabs,ispec,weight(iabs),wsum(n)
          endif
         enddo
        enddo
        do i=1,nabss
         iabs=listabs(i)
         ispec=listsit(iabs)
         if(wsum(ispec).ne.0.0)then
          if(weight(iabs)/wsum(ispec).eq.1.0)then
            weight(iabs)=1.0
          endif
         else
          weight(iabs)=0.0
         endif
        enddo

        if(nspec.gt.0)then 
        if(ini)then
        write(iol,*)' '
        write(iol,*)'weights of multiple absorbers'
        write(iol,*)'contributing to a single spectrum'
        write(iol,*)' '
        write(iol,*)'iabs  wspc  ispec  weight'
        write(iol,*)'--------------------------'
        do i=1,nabss
         j=listabs(i)
         l=listsit(j)
         write(iol,*)j,wspc(j),l,weight(j)
        enddo
        write(iol,*)' '
        write(iol,*)' '
        endif
        endif
*
      return
      end
