*****c***1********2*******3********4********5********6********7********8
      subroutine inexp(mdata,ndata,x,y,e,resq,filein,
     1                  power,errmod,e0shft,iol)
*****c***1********2*******3********4********5********6********7********8
*
* input exafs data ("xafs" format), wheight with power of k
* and calculate inverse squared errors
*
* include a shift of the k-vector due to an energy shift 6/23/98 m.w.
* improved e0-shift 12/20/02mw
*
*****c***1********2*******3********4********5********6********7********8
*
* m. winterer 1/26/97 darmstadt
*
*****c***1********2*******3********4********5********6********7********8
*
* global variables
*
* mdata                             maximum number of data
* ndata                             actual number of data 
* x,y,e                             abscissa, ordinate and errors values
* errmod                            switch for different modes to consider
*                                   experimental errors
* filein                            filename of experimental data   
*
* local variables
*
* i,ios                             index; I/O status number        
* dummy                             text dummy to skip header
* d                                 real dummy to skip columns in data
* r,resq,enorm                      aids in power wheighting and error
*                                   estimation
*
* files                              
*
* filein                            unit 15, experimental data
* rmxas.log                         unit 12, log book
*       
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations 
*
       implicit none
* global variables
*
      integer mdata,ndata,iol,maxdat
      parameter(maxdat=2048)
      real xi(maxdat),yi(maxdat),ei(maxdat)
      real x(mdata),y(mdata),e(mdata),power,errmod,resq,e0shft
      character*31 filein
* local variables
*
      integer i,j,ios
      real d,r
      real etok,kp,en
      character*1 dummy
*
* initialize
*
      call initd(mdata,mdata,x,0.0)
      call initd(mdata,mdata,y,0.0)
      call initd(mdata,mdata,e,1.0)
*
* open
*
      open(15,file=filein,iostat=ios,status='old',err=9999)
c      write(iol,'(a22,a31)')' input exp. data from: ',filein
*
* read header and column labels
*
      do 90 i=1,23
        read(15,9000,end=9997,err=9998)dummy
90    continue
*
* read data
*
      do 100 i=1,mdata
        read(15,9001,end=200,err=9998)x(i),y(i),d,d,e(i)
        ndata=i
100   continue
200   continue
      if(ndata.le.0)then
         write(iol,*)'inexp error: no data '
         print *,'inexp error: no data '
	 pause
	 stop
      endif
      if(ndata.gt.mdata)then
         write(iol,*)'inexp error: # data ',ndata,' > ',mdata
         print *,'inexp error: # data ',ndata,' > ',mdata
	 pause
	 stop
      endif
*
* close and save
*
      close(15,status='keep')
*
* shift of k-vector (k'=c*sqrt(k**2+e0)) due to shift of energy scale
*
      if(e0shft.ne.0.0)then
       write(iol,'(a31,g13.6)')' shift experimental k-scale by ',e0shft
       write(iol,'(a)')' '
       etok=0.512315
       j=0
c       print *,x(1)
       do 250 i=1,ndata
        xi(i)=x(i)
        yi(i)=y(i)
        ei(i)=e(i)
        en=e0shft+x(i)*x(i)/(etok*etok)
        if(en.gt.0.0)then
         j=j+1
         kp=etok*sqrt(en)
         x(j)=kp
         y(j)=yi(i)
         e(j)=ei(i)
        endif
250    continue
       ndata=j
c       print *,x(1)
      endif
*
* k-power weighting 
*
       if(power.ne.0.0)then
        do 300 i=1,ndata
         r=x(i)
	 d=y(i)
         if(r.eq.0.0)then
           y(i)=d
         else
           d=d*(r**power)
	   y(i)=d
         endif
300     continue
       endif
* calculate inverse squared errors of data
       if(errmod.eq.0.0)then
        call initd(mdata,ndata,e,1.0)
       elseif(errmod.gt.0.0)then
        do 400 i=1,ndata
	  e(i)=errmod
400     continue
        resq=0.0
        do 500 i=1,ndata
         resq=resq+y(i)*y(i)*e(i)*e(i)
500     continue
        resq=1./resq
       endif
       if(errmod.lt.0.0)then
        if(power.ne.0.0)then
         do i=1,ndata
          r=x(i)
	  d=e(i)
          if(r.eq.0.0)then
           e(i)=d
          else
           d=d*(r**power)
	   e(i)=d
          endif
         enddo
        endif
        resq=0.0
        do i=1,ndata
         resq=resq+e(i)*e(i)
        enddo
        resq=1./resq
       endif
      write(iol,'(a22,i6)')' number of data points ',ndata
*****c***1********2*******3********4********5********6********7********8
* 
* formats
*
9000  format(2x,a80)
9001  format(1x,5(g13.6,1x))
9002  format(1x,5(a13,1x))
9003  format(a80)
      return
9997  write(iol,'(a30)')'inexp error: end of file      '
      print *,'inexp error: end of file      '
      stop 
9998  write(iol,'(a30)')'inexp error: wrong file format'
      print *,'inexp error: wrong file format'
      stop
9999  write(iol,'(a30)')'inexp error: open file error  '
      print *,'inexp error: open file error  '
      stop
      end
