*****c***1********2*******3********4********5********6********7********8
      subroutine indat(mdata,ndata,fildat,nh,nx,ny,ne,x,y,e,iol)
*****c***1********2*******3********4********5********6********7********8
*
*     input data from column oriented format
*     up to 3 columns: independend variable x in column nx
*                      dependend variable   y in column ny
*                      error estimate       e in column ne
*
*      M. Winterer, Duisburg 05/17/2024
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       integer mdata,ndata,nh,nx,ny,ne,iol
       real x(mdata),y(mdata),e(mdata),d(mdata)
       character*31 fildat
       character*1 dummy
       integer i,n,ios
*
*****c***1********2*******3********4********5********6********7********8
*
* initialize
*
      call initd(mdata,mdata,x,0.0)
      call initd(mdata,mdata,y,0.0)
      call initd(mdata,mdata,e,1.0)
*
* open
*
      open(15,file=fildat,iostat=ios,status='old',err=9999)
*
* read header
*
       do n=1,nh
        read(15,*)dummy
       enddo
*
* read data
*
       if(ne.eq.0)then
        if(nx.lt.ny)then
         do n=1,mdata
          read(15,*,end=200,err=9998)(d(i),i=1,nx-1   ),x(n),
     1              (d(i),i=1,ny-nx-1),y(n)
          ndata=n
         enddo
        else
         do n=1,mdata
          read(15,*,end=200,err=9998)(d(i),i=1,ny-1   ),y(n),
     1              (d(i),i=1,nx-ny-1),x(n)
          ndata=n
         enddo
        endif
       else
        if((nx.lt.ny).and.(ny.lt.ne))then
         do n=1,mdata
          read(15,*,end=200,err=9998)(d(i),i=1,nx-1   ),x(n),
     1              (d(i),i=1,ny-nx-1),y(n),
     2              (d(i),i=1,ne-ny-1),e(n)
          ndata=n
         enddo
        elseif((nx.lt.ne).and.(ne.lt.ny))then
         do n=1,mdata
          read(15,*,end=200,err=9998)(d(i),i=1,nx-1   ),x(n),
     1              (d(i),i=1,ne-nx-1),e(n),
     2              (d(i),i=1,ny-ne-1),y(n)
          ndata=n
         enddo
        elseif((ny.lt.nx).and.(nx.lt.ne))then
         do n=1,mdata
          read(15,*,end=200,err=9998)(d(i),i=1,ny-1   ),y(n),
     1              (d(i),i=1,nx-ny-1),x(n),
     2              (d(i),i=1,ne-ne-1),e(n)
          ndata=n
         enddo
        elseif((ny.lt.ne).and.(ne.lt.nx))then
         do n=1,mdata
          read(15,*,end=200,err=9998)(d(i),i=1,ny-1   ),y(n),
     1              (d(i),i=1,ne-ny-1),e(n),
     2              (d(i),i=1,nx-ne-1),x(n)
          ndata=n
         enddo
        elseif((ne.lt.nx).and.(nx.lt.ny))then
         do n=1,mdata
          read(15,*,end=200,err=9998)(d(i),i=1,ne-1   ),e(n),
     1              (d(i),i=1,nx-ne-1),x(n),
     2              (d(i),i=1,ny-nx-1),y(n)
          ndata=n
         enddo
        elseif((ne.lt.ny).and.(ny.lt.nx))then
         do n=1,mdata
          read(15,*,end=200,err=9998)(d(i),i=1,ne-1   ),e(n),
     1              (d(i),i=1,ny-ne-1),y(n),
     2              (d(i),i=1,nx-ny-1),x(n)
          ndata=n
         enddo
        endif
       endif
200    continue
*
      if(ndata.le.0)then
         write(iol,*)'indat error: no data '
         print *,'inexp error: no data '
c	 pause
	 stop
      else
         write(iol,*)'number of data ',ndata
         write(iol,*)' '
      endif
      if(ndata.gt.mdata)then
         write(iol,*)'inexp error: # data ',ndata,' > ',mdata
         print *,'inexp error: # data ',ndata,' > ',mdata
c	 pause
	 stop
      endif
      close(15,status='keep')
*
*****c***1********2*******3********4********5********6********7********8
* 
* formats
*
9000  format(2x,a80)
9001  format(1x,5(g13.6,1x))
9002  format(1x,5(a13,1x))
9003  format(a80)
      return
9997  write(iol,'(a30)')'indat error: end of file      '
      print *,'inexp error: end of file      '
      stop 
9998  write(iol,'(a30)')'indat error: wrong file format'
      print *,'inexp error: wrong file format'
      stop
9999  write(iol,'(a30)')'indat error: open file error  '
      print *,'inexp error: open file error  '
      stop
      end

*****c***1********2*******3********4********5********6********7********8
      subroutine xasdat(mdata,ndata,x,y,e,resq,power,errmod,e0shft,iol)
*****c***1********2*******3********4********5********6********7********8
*
* convert exafs data: wheight with power of k
* and calculate inverse squared errors
*
*     set error mode for scattering data
*     error mode = 0 : e(i)=1.0
*                < 0 : e(i) from data column
*                > 0 : e(i)=errmod
*
* include a shift of the k-vector due to an energy shift 6/23/98 m.w.
* improved e0-shift 12/20/02mw
*
* m. winterer 1/26/97 darmstadt
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations 
*
      implicit none
      integer mdata,ndata,iol,maxdat
      parameter(maxdat=2048)
      real xi(maxdat),yi(maxdat),ei(maxdat)
      real x(mdata),y(mdata),e(mdata),power,errmod,resq,e0shft
      integer i,j
      real d,r
      real etok,kp,en
*
* shift of k-vector (k'=c*sqrt(k**2+e0)) due to shift of energy scale
*
      if(e0shft.ne.0.0)then
       write(iol,'(a31,g13.6)')' shift experimental k-scale by ',e0shft
       write(iol,'(a)')' '
       etok=0.512315
       j=0
       do 250 i=1,ndata
        xi(i)=x(i)
        yi(i)=y(i)
        ei(i)=e(i)
        en=e0shft+x(i)*x(i)/(etok*etok)
        if(en.gt.0.0)then
         j=j+1
         kp=etok*sqrt(en)
         x(j)=kp
         y(j)=yi(i)
         e(j)=ei(i)
        endif
250    continue
       ndata=j
      endif
*
* k-power weighting 
*
       if(power.ne.0.0)then
        do 300 i=1,ndata
         r=x(i)
	 d=y(i)
         if(r.eq.0.0)then
           y(i)=d
         else
           d=d*(r**power)
	   y(i)=d
         endif
300     continue
       endif
* calculate inverse squared errors of data
       if(errmod.eq.0.0)then
        call initd(mdata,ndata,e,1.0)
       elseif(errmod.gt.0.0)then
        do 400 i=1,ndata
	  e(i)=errmod
400     continue
        resq=0.0
        do 500 i=1,ndata
         resq=resq+y(i)*y(i)*e(i)*e(i)
500     continue
        resq=1./resq
       endif
       if(errmod.lt.0.0)then
        if(power.ne.0.0)then
         do i=1,ndata
          r=x(i)
	  d=e(i)
          if(r.eq.0.0)then
           e(i)=d
          else
           d=d*(r**power)
	   e(i)=d
          endif
         enddo
        endif
        resq=0.0
        do i=1,ndata
         resq=resq+e(i)*e(i)
        enddo
        resq=1./resq
       endif
      end
*****c***1********2*******3********4********5********6********7********8
      subroutine scadat(mdatd,ndatd,errmod,x,y,e,iol)
*****c***1********2*******3********4********5********6********7********8
*
*     set error mode for scattering data
*     error mode = 0 : e(i)=1.0
*                < 0 : e(i)=sqrt(y(i))
*                = 1 : e(i) from data column
*                > 0 (not 1) e(i)=errmod
*
*     M. Winterer, Duisburg, 05/16/2024
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations 
*
      implicit none
      integer mdatd,ndatd,iol,i
      real x(mdatd),y(mdatd),e(mdatd),errmod
*
* set errmod
*
      if(errmod.eq.0.0)then
       call initd(mdatd,ndatd,e,1.0)
      elseif((errmod.ne.0.0).or.(errmod.ne.1.0))then
       do i=1,ndatd
        e(i)=errmod
       enddo
      endif
      if(errmod.lt.0.0)then
       do i=1,ndatd
        e(i)=sqrt(y(i))
       enddo
      endif
      end
