******c***1********2*******3********4********5********6********7********8
*
       program totalpdf
*
******c***1********2*******3********4********5********6********7********8
*
* compute total pair distribution function from pPDF
*
******c***1********2*******3********4********5********6********7********8
* 
* declarations
*
       implicit none
       integer mtyp,ntyp,mpdf,npdf,mhis,nhis,i,j,k
       parameter(mtyp=3)
       parameter(mpdf=(mtyp*mtyp+mtyp)/2)
       parameter(mhis=100000)
       real conc(mtyp),cicj(mpdf)
       real rad(mhis),gij(mhis,mpdf),gtot(mhis),deltar
       character*80 version,filtot,filpdf
*
       version='totalpdf 05/11/2022mw'
*****c***1********2*******3********4********5********6********7********8
*      input
*****c***1********2*******3********4********5********6********7********8
*
* initializations / input
*
       write(*,*)'TOTALPDF'
       write(*,*)version
       write(*,*)' '
       write(*,*)'number of atom types: '
       read(*,*)ntyp
       npdf=ntyp*(ntyp+1)/2
       write(*,*)' '
       write(*,*)'number of PDFs: ',npdf
       write(*,*)' '
       write(*,*)'input partial pair distributions from: '
       read(*,*)filpdf 
       write(*,*)' '
       call inpdf(mhis,nhis,mtyp,ntyp,mpdf,npdf,rad,gij,filpdf)
       deltar=rad(2)-rad(1)
       write(*,*)'rmin   ', rad(1)
       write(*,*)'rmax   ', rad(nhis)
       write(*,*)'deltar ', deltar
       write(*,*)' '
       write(*,*)'concentrations for ',ntyp,' atoms: '
       read(*,*)(conc(i),i=1,ntyp)
*       
*****c***1********2*******3********4********5********6********7********8
*      computation
*****c***1********2*******3********4********5********6********7********8
       do i=1,nhis
        gtot(i)=0.0
       enddo
       k=0
       do j=1,ntyp
        do i=j,ntyp
         k=k+1
         cicj(k)=conc(i)*conc(j)
         write(*,*),i,j,k,cicj(k)
        enddo
       enddo
       do i=1,nhis
        do k=1,npdf
         gtot(i)=gtot(i)+cicj(k)*gij(i,k)
        enddo
       enddo
*****c***1********2*******3********4********5********6********7********8
*      output
*****c***1********2*******3********4********5********6********7********8
*
       filtot='gtot.pdf'
       write(*,*)'output total pair distribution: ',filtot
       write(*,*)' '
       call outgtot(mhis,nhis,rad,gtot,filtot)
*
       end
*
*
*****c***1********2*******3********4********5********6********7********8
*
       subroutine inpdf(mhis,nhis,mtyp,ntyp,mpdf,npdf,rad,gij,filpdf)
*
*****c***1********2*******3********4********5********6********7********8
*
* input partial distribution functions
*
*****c***1********2*******3********4********5********6********7********8
*
* m. winterer 7/17/12 Duisburg
*
*****c***1********2*******3********4********5********6********7********8
*
* global variables
*
* local variables mdum, dum
*
* files used:              rmc.pdf, unit 15
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations 
*
       implicit none
* global variables
       integer mhis,nhis,mtyp,ntyp,mpdf,npdf,mdum
       parameter(mdum=100)
       real rad(mhis),gij(mhis,mpdf),dum(mdum)
       character*80 filpdf
* local variables
       integer ios,i,k
*
*****c***1********2*******3********4********5********6********7********8
*
       i=0
       open(20,file=filpdf,status='unknown',err=9997,iostat=ios)
100     continue 
        i=i+1
        read(20,*,err=9998,end=200)
     1                        rad(i),(gij(i,k),dum(k),k=1,npdf)
        goto 100
200    continue
       nhis=i-1
       close(20,status='keep')
       return
*
*****c***1********2*******3********4********5********6********7********8
*
9997  write(*,*)'inpdf: open file error',ios
      return
9998  write(*,*)'inpdf: input error'
      return
      end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine outgtot(mhis,nhis,rad,gtot,filtot)
*
*****c***1********2*******3********4********5********6********7********8
*
* output total pair distribution function
*
*****c***1********2*******3********4********5********6********7********8
*
* m. winterer 5/11/2022 Duisburg
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations 
*
       implicit none
       integer mhis,nhis,i
       real rad(mhis),gtot(mhis)
       character*80 filtot
*
*****c***1********2*******3********4********5********6********7********8
*
       open(20,file=filtot,status='unknown')
        do i=1,nhis
         write(20,9000)rad(i),gtot(i)
        enddo
       close(20,status='keep')
9000   format(2(g13.6,1x))
       return
       end
*
*****c***1********2*******3********4********5********6********7********8
*
