*****c***1********2*******3********4********5********6********7********8
*
        program genriepar
*
*****c***1********2*******3********4********5********6********7********8
*
* program to generate the rie.par file for rmcxas
* using space group P1 typ coordinates in unit cell
* generated for example by atoms (B. Ravel) (rmc.uc)
*
*****c***1********2*******3********4********5********6********7********8
*
       implicit none
       integer i,n,nsit,ipar,typ,ndiff,nphase,l,b
       real x,y,z
       character*256 filnam(10)
       character*6 buffer
       character*3 num,buf
*
*****c***1********2*******3********4********5********6********7********8
*
        print *,'GENRIEPAR'
        print *,' '
        print *,'generate rie.par file for rmcxas '
        print *,' '
        print *,'input data from rmc.uc'
        print *,'output data to rie.par.0'
        print *,' '
        print *,'number of diffractograms: '
        read(*,*)ndiff
        print *,'number of crystallographic phases: '
        read(*,*)nphase
        print *,' '
        do i=1,nphase
         print *,'filename of rmc.uc file for phase ',i
         read(*,'(a)')filnam(i)
         print *,' '
        enddo
*
        ipar=0
        open(25,file='rie.par.0',status='unknown')
* generate MC control parameters
         write(25,*) 1000,' ngmcyc'
         write(25,*) 10,100,10,' ncycs, ncyce, ncycex'
         write(25,*) 100,' gnadjst'
         write(25,*) 1.0e-2,' gacratio'
         write(25,*) 1.0e-2,' gadjst'
         write(25,*) 10.0,' atmov'
         write(25,*) '# '

* generate instrumental parameters
         do i=1,ndiff
          ipar=ipar+1
          write(25,99)ipar,100.0,0.01,1000.0,0.01,0,0.0,0.0,
     1                'intensity_scale'
          ipar=ipar+1
          write(25,99)ipar,0.0,0.01,1000.0,0.0,0,0.0,0.0,
     1                'offset'
          ipar=ipar+1
          write(25,99)ipar,0.0,0.01,1000.0,0.0,0,0.0,0.0,
     1                'sample'
          ipar=ipar+1
          write(25,99)ipar,0.0,0.01,1000.0,0.0,0,0.0,0.0,
     1                'transparency'
          ipar=ipar+1
          write(25,99)ipar,0.0,0.01,1000.0,0.0,0,0.0,0.0,
     1                'u_cagliotti'
          ipar=ipar+1
          write(25,99)ipar,0.0,0.01,1000.0,0.0,0,0.0,0.0,
     1                'v_cagliotti'
          ipar=ipar+1
          write(25,99)ipar,0.0,0.01,1000.0,0.0,0,0.0,0.0,
     1                'w_cagliotti'
          ipar=ipar+1
          write(25,99)ipar,10.0,0.01,100.0,0.01,0,0.0,0.0,
     1                'backgr0'
          ipar=ipar+1
          write(25,99)ipar,0.0,-100.0,100.0,0.01,0,0.0,0.0,
     1                'backgr1'
          ipar=ipar+1
          write(25,99)ipar,0.0,-100.0,100.0,0.01,0,0.0,0.0,
     1                'backgr2'
          ipar=ipar+1
          write(25,99)ipar,0.0,-100.0,100.0,0.01,0,0.0,0.0,
     1                'backgr3'
          ipar=ipar+1
          write(25,99)ipar,0.0,-10.0,10.0,0.01,0,0.0,0.0,
     1                'backgr4'
          ipar=ipar+1
          write(25,99)ipar,0.0,-10.0,10.0,0.01,0,0.0,0.0,
     1                'backgr5'
          ipar=ipar+1
          write(25,99)ipar,0.0,-10.0,10.0,0.01,0,0.0,0.0,
     1                'backgr6'
          ipar=ipar+1
          write(25,99)ipar,0.0,-10.0,10.0,0.01,0,0.0,0.0,
     1                'backgr7'
          ipar=ipar+1
          write(25,99)ipar,0.0,-10.0,10.0,0.01,0,0.0,0.0,
     1                'backgr8'
          ipar=ipar+1
          write(25,99)ipar,0.0,-1.0,1.0,0.01,0,0.0,0.0,
     1                'backgr9'
          ipar=ipar+1
          write(25,99)ipar,0.0,-1.0,1.0,0.01,0,0.0,0.0,
     1                'backgr10'
          ipar=ipar+1
          write(25,99)ipar,0.0,-1.0,1.0,0.01,0,0.0,0.0,
     1                'backgr11'
          ipar=ipar+1
          write(25,99)ipar,30.0,5.0,180.0,0.01,0,0.0,0.0,
     1                'backgrpos'
         enddo

* generate microstructure and crystal structure parameters
         do i=1,nphase
          ipar=ipar+1
          write(25,99)ipar,1.0,0.01,1.0,0.0,0,0.0,0.0,
     1                'phasefraction'
          ipar=ipar+1
          write(25,99)ipar,100.0,1.0,10000.0,0.0,0,0.0,0.0,
     1                'columnlength(A)'
          ipar=ipar+1
          write(25,99)ipar,0.001,0.0001,0.1,0.0,0,0.0,0.0,
     1                'microstrain'
          ipar=ipar+1
          write(25,99)ipar,5.0,2.0,10.0,0.0,0,0.0,0.0,
     1                'alatt(A)'
          ipar=ipar+1
          write(25,99)ipar,5.0,2.0,10.0,0.0,0,0.0,0.0,
     1                'blatt(A)'
          ipar=ipar+1
          write(25,99)ipar,5.0,2.0,10.0,0.0,0,0.0,0.0,
     1                'clatt(A)'
          ipar=ipar+1
          write(25,99)ipar,90.0,0.01,120.0,0.0,0,0.0,0.0,
     1                'alpha(deg)'
          ipar=ipar+1
          write(25,99)ipar,90.0,0.01,120.0,0.0,0,0.0,0.0,
     1                'beta(deg)'
          ipar=ipar+1
          write(25,99)ipar,90.0,0.01,120.0,0.0,0,0.0,0.0,
     1                'gamma(deg)'
*
* generate unit cell content parameters
*
        nsit=0
        print *, filnam(i)
        open(20,file=filnam(i),status='old')
1        continue
         read(20,*,end=10)typ,x,y,z
         nsit=nsit+1
         goto 1
10      continue
        close(20,status='keep')

        print *,'number of sites in phase ',i,' : ',nsit
        ipar=ipar+1
        write(25,99)ipar,float(nsit),0.0,0.0,0.0,0,0.0,0.0,
     1              'nsit'

         open(20,file=filnam(i),status='old')
          buf='   '
          do n=1,nsit
           write(buffer,'(i3)')n
           read(buffer,'(a3)')buf
           do l=1,3
            if(buf(l:l).eq.' ')then
             b=l
            endif
           enddo
           num(1:3)=buf(b+1:3)
           read(20,*)typ,x,y,z
           ipar=ipar+1
           write(25,99)ipar,float(typ),0.0,0.0,0.0,0,0.0,0.0,
     1                 'atomtype'//num
           ipar=ipar+1
           write(25,99)ipar,1.0,0.0,0.0,0.0,0,0.0,0.0,
     1                 'occ'//num
           ipar=ipar+1
           write(25,99)ipar,x,0.0,1.0,0.0,0,0.0,0.0,
     1                 'xuc'//num
           ipar=ipar+1
           write(25,99)ipar,y,0.0,1.0,0.0,0,0.0,0.0,
     1                 'yuc'//num
           ipar=ipar+1
           write(25,99)ipar,z,0.0,1.0,0.0,0,0.0,0.0,
     1                 'zuc'//num
           ipar=ipar+1
           write(25,99)ipar,2.e-3,0.0,0.0,0.0,0,0.0,0.0,
     1                 'umsq'//num
          enddo
          close(20,status='keep')
         enddo
        close(25,status='keep')
*
99      format(1x,i6,4(1x,g13.6),1x,i6,2(1x,g13.6),a)
        end
*
