*****c***1********2*******3********4********5********6********7********8
*
       program distill
*
*****c***1********2*******3********4********5********6********7********8
*
* program to 
*
* m. winterer darmstadt 4/13/99 
* revised duisburg 05/05/2021 in matrix algebra for crystallography 
*
*****c***1********2*******3********4********5********6********7********8
      implicit none
      integer matom,natom,i
      parameter(matom=20000)
      integer hn,kn,ln
      real alatt,blatt,clatt,alphad,betad,gammad
      real volume,hmat(3,3),hinv(3,3),gmet(3,3)
      integer typ(matom)
      real xcr(matom),ycr(matom),zcr(matom),rms(matom)
      real xco(matom),yco(matom),zco(matom)
      real pi
      character*256 filcoo,filout

      common /const/ pi
*
      pi=4.0*real(datan(1.0d0))
*
* input initial coordinates       
* 
         print *,'distill rmc coordinates into one unit cell'        
         print *,' '
         print *,' m. winterer Duisburg 05/05/2021'
         print *,' '
         call inpar(filcoo,hn,kn,ln,alatt,blatt,clatt,
     1                 alphad,betad,gammad)
         print *,'input parameters'
*
* make transformation and metric matrices
*
       call makehm(alatt,blatt,clatt,hn,kn,ln,
     1                   alphad,betad,gammad,volume,hmat)
       call makehi(alatt,blatt,clatt,hn,kn,ln,
     1                   alphad,betad,gammad,volume,hinv)
       call makegm(hmat,gmet)
       print *,'created transformation matrices'
       print *,' '
       print *,'simulation box volume: ',volume
       print *,' '
*
* input initial coordinates
*
        call incoo(matom,natom,typ,xcr,ycr,zcr,rms,filcoo)
*
* convert cartesian to crystallographic coordinates
*
        do 100 i=1,natom
         call tranoc(xcr(i),ycr(i),zcr(i),
     1               hinv,xco(i),yco(i),zco(i))
100     continue
        print *,'transformed to crystallographic coordinates'
        print *,' '
*
* distill coordinates into one unit cell
*
        print *,'distill coordinates'
        print *,' '
        call collapse(matom,natom,xco,yco,zco,hn,kn,ln)
*
* make transformation and metric matrices
*
       hn=1
       kn=1
       ln=1
       call makehm(alatt,blatt,clatt,hn,kn,ln,
     1                   alphad,betad,gammad,volume,hmat)
       call makehi(alatt,blatt,clatt,hn,kn,ln,
     1                   alphad,betad,gammad,volume,hinv)
       call makegm(hmat,gmet)
*
* convert cartesian to crystallographic coordinates
*
        print *,'transform to cartesian coordinates'
        print *,' '
        do 200 i=1,natom
         call tranco(xco(i),yco(i),zco(i),
     1               hmat,xcr(i),ycr(i),zcr(i))
200     continue
*
* output distilled coordinates
*
       filout='rmc.coo.dis'
       print *,'output coordinates: ',filout
       print *,' '
       call outcoo(matom,natom,typ,xcr,ycr,zcr,rms,filout)
*
       end

*****c***1********2*******3********4********5********6********7********8
*
      subroutine collapse(matom,natom,xco,yco,zco,nx,ny,nz)
*
*****c***1********2*******3********4********5********6********7********8
*
* routine adapted from the program "unitcell" of the rmca suite of
* McGreevy et al., Studsvik
*
* Collapses points into a unit cell (being a subdivision of the
* configuration cell)
*
      implicit none
      integer matom,natom,i,nx,ny,nz
      real xco(matom),yco(matom),zco(matom)    

      do i=1,natom
         xco(i)=amod((xco(i)+0.5)*real(nx),1.)-0.5
         yco(i)=amod((yco(i)+0.5)*real(ny),1.)-0.5
         zco(i)=amod((zco(i)+0.5)*real(nz),1.)-0.5
      enddo
*
      return
      end
*
*****c***1********2*******3********4********5********6********7********8
*
       subroutine incoo(matom,natom,typ,xco,yco,zco,rms,filcoo)
*
*****c***1********2*******3********4********5********6********7********8
*
* input atom coordinates 
*
*****c***1********2*******3********4********5********6********7********8
*
* m. winterer 1/31/97 darmstadt
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations 
*
       implicit none
* global variables
       integer matom,natom
       integer typ(matom)
       real xco(matom),yco(matom),zco(matom),rms(matom)
       character*256 filcoo
* local variables
       integer ios,i
*
*****c***1********2*******3********4********5********6********7********8
*
c       print *,'input atom coordinates from: ',filcoo
       i=0
       open(15,file=filcoo,status='unknown',err=9997,iostat=ios)
100    continue
        i=i+1
        read(15,9000,err=9998,end=200)i,typ(i),
     1                                xco(i),yco(i),zco(i),rms(i)
c       if(mod(i,10).eq.0)print *,i,typ(i),xco(i),yco(i),zco(i),rms(i)
       goto 100
200    continue
       natom=i-1
       close(15,status='keep')
       write(*,*)'incoo: number of atoms',natom
       write(*,*)' '
       return
9000   format(i6,1x,i2,4(1x,g13.6))
*
*****c***1********2*******3********4********5********6********7********8
*
9997  write(*,*)'incoo: open file error',ios
      return
9998  write(*,*)'incoo: input error'
      return
      end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine outcoo(matom,natom,typ,xco,yco,zco,rms,filcoo)
*
*****c***1********2*******3********4********5********6********7********8
*
* output atom coordinates
*
*****c***1********2*******3********4********5********6********7********8
*
* m. winterer 1/31/97 darmstadt
*
*****c***1********2*******3********4********5********6********7********8
*
* global variables
*
* local variables
*
* files used:              rmc.coo, unit 15
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
* global variables
       integer matom,natom
       integer typ(matom)
       real xco(matom),yco(matom),zco(matom),rms(matom)
       character*31 filcoo
* local variables
       integer ios,i
*
*****c***1********2*******3********4********5********6********7********8
*
       open(15,file=filcoo,status='unknown',err=9997,iostat=ios)
       do 100 i=1,natom
        write(15,9000,err=9998)i,typ(i),xco(i),yco(i),zco(i),rms(i)
100    continue
       close(15,status='keep')
       return
9000   format(i6,1x,i2,5(1x,g13.6))
*
*****c***1********2*******3********4********5********6********7********8
*
9997  write(*,*)'outcoo: open file error',ios
      return
9998  write(*,*)'outcoo: output error'
      return
      end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine initd(mdat,ndat,x,set)
*
*****c***1********2*******3********4********5********6********7********8
*
       implicit none
* global variables
       integer mdat,ndat
       real x(mdat),set
* local variables
       integer i
*
*****c***1********2*******3********4********5********6********7********8
*
       do 100 i=1,ndat
        x(i)=set
100    continue
       return
       end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine initd2(mdat,ndat,mset,nset,x,set)
*
*****c***1********2*******3********4********5********6********7********8
*
       implicit none
* global variables
       integer mdat,ndat,mset,nset
       real x(mdat,mset),set
* local variables
       integer i,j
*
*****c***1********2*******3********4********5********6********7********8
*
       do 101 j=1,nset
        do 100 i=1,ndat
         x(i,j)=set
100     continue
101    continue
       return
       end
*
*****c***1********2*******3********4********5********6********7********8
*
       subroutine makehm(alatt,blatt,clatt,hn,kn,ln,
     1                   alphad,betad,gammad,volume,hmat)
*
*****c***1********2*******3********4********5********6********7********8
*
* matrix algebra for Reverse Monte Carlo (Parinello-Rahman):
*
* make transformation matrix H for transformation 
* from cartesian to crystallographic coordinates
*
* source:  C. Giacovazzo, Fundamentals of Crystallography, 68pp.
*
* m. winterer 3/5/98
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       integer hn,kn,ln
       real alatt,blatt,clatt,alpha,beta,gamma
       real a,b,c
       real volume,cosa,cosb,cosg,sinb,sing,cosas,cs
       real pi,alphad,betad,gammad
       real hmat(3,3)
* common blocks
       common /const/ pi
* conversion from degrees to radians
        alpha=alphad*pi/180.
        beta= betad*pi/180.
        gamma=gammad*pi/180.
*
* geometric factors
*
        a=real(hn)*alatt
        b=real(kn)*blatt
        c=real(ln)*clatt
       
        cosa=sngl(dcos(dble(alpha)))
        cosb=sngl(dcos(dble(beta)))
        cosg=sngl(dcos(dble(gamma)))
        sinb=sngl(dsin(dble(beta)))
        sing=sngl(dsin(dble(gamma)))
        
        cosas=(cosb*cosg-cosa)/(sinb*sing)
       
        volume=a*b*c*
     1         sqrt(1.0-cosa*cosa-cosb*cosb-cosg*cosg
     2             + 2.0*cosa*cosb*cosg)
       
        cs=a*b*sing/volume
*
* matrix elements
*
        hmat(1,1)= a
        hmat(1,2)= 0.0
        hmat(1,3)= 0.0
        hmat(2,1)= b*cosg
        hmat(2,2)= b*sing
        hmat(2,3)= 0.0
        hmat(3,1)= c*cosb
        hmat(3,2)=-c*sinb*cosas 
        hmat(3,3)= 1.0/cs
       return
       end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine makehi(alatt,blatt,clatt,hn,kn,ln,
     1                   alphad,betad,gammad,volume,hinv)
*
*****c***1********2*******3********4********5********6********7********8
*
* matrix algebra for Reverse Monte Carlo (Parinello-Rahman):
*
* make inverse transformation matrix HI for transformation 
* from crystallographic to cartesian coordinates
*
* source:  C. Giacovazzo, Fundamentals of Crystallography, 68pp.
*
* m. winterer 3/5/98
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       integer hn,kn,ln
       real alatt,blatt,clatt,alpha,beta,gamma
       real a,b,c
       real volume,cosa,cosb,cosg,sina,sinb,sing
       real cosas,cosbs,as,bs,cs
       real hinv(3,3)
       real pi,alphad,betad,gammad
* common blocks
      common /const/ pi
* conversion from degrees to radians
*
        alpha=alphad*pi/180.
        beta= betad*pi/180.
        gamma=gammad*pi/180.
*
* geometric factors
*
        a=float(hn)*alatt
        b=float(kn)*blatt
        c=float(ln)*clatt
       
        cosa=sngl(dcos(dble(alpha)))
        cosb=sngl(dcos(dble(beta)))
        cosg=sngl(dcos(dble(gamma)))
        sina=sngl(dsin(dble(alpha)))
        sinb=sngl(dsin(dble(beta)))
        sing=sngl(dsin(dble(gamma)))
        cosas=(cosb*cosg-cosa)/(sinb*sing)
        cosbs=(cosa*cosg-cosb)/(sina*sing)
       
        as=b*c*sina/volume
        bs=a*c*sinb/volume
        cs=a*b*sing/volume
*
* matrix elements
*
        hinv(1,1)= 1./a
        hinv(1,2)= 0.0
        hinv(1,3)= 0.0
        hinv(2,1)=-cosg/(a*sing)
        hinv(2,2)= 1./(b*sing)
        hinv(2,3)= 0.0
        hinv(3,1)= as*cosbs
        hinv(3,2)= bs*cosas 
        hinv(3,3)= cs
       return
       end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine makegm(hmat,gmet)
*
*****c***1********2*******3********4********5********6********7********8
*
* matrix algebra for Reverse Monte Carlo (Parinello-Rahman):
*
* make metric matrix G = H'.H; G is symmetric
*
* source:  C. Giacovazzo, Fundamentals of Crystallography, 68pp.
* and:     M. Parrinello, and A. Rahman, J. Appl. Phys. 52 (1981), 7182
*
* m. winterer 3/5/98
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       real gmet(3,3),hmat(3,3)
*
* matrix elements
*
        gmet(1,1)= hmat(1,1)*hmat(1,1)
        gmet(1,2)= hmat(1,1)*hmat(2,1)
        gmet(1,3)= hmat(1,1)*hmat(3,1)
        gmet(2,1)= gmet(1,2)
        gmet(2,2)= hmat(2,1)*hmat(2,1)+hmat(2,2)*hmat(2,2)
        gmet(2,3)= hmat(2,1)*hmat(3,1)+hmat(2,2)*hmat(3,2)
        gmet(3,1)= gmet(1,3)
        gmet(3,2)= gmet(2,3)
        gmet(3,3)= hmat(3,1)*hmat(3,1)+hmat(3,2)*hmat(3,2)+
     1               hmat(3,3)*hmat(3,3)
       return
       end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine tranco(x,y,z,hmat,a,b,c)
*
*****c***1********2*******3********4********5********6********7********8
*
* matrix algebra for Reverse Monte Carlo (Parinello-Rahman):
*
* (tran)sformation from cartesian ( (o)rthogonal (x)
*                to                 (c)rystallographic (a) coordinates
* a = H.x
*
* source:  C. Giacovazzo, Fundamentals of Crystallography, 68pp.
* and:     M. Parrinello, and A. Rahman, J. Appl. Phys. 52 (1981), 7182
*
* m. winterer 3/5/98
* revised 11/26/14 mw
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       real a,b,c,x,y,z,hmat(3,3)
*
*
* transformation 
*
c       a=x*hmat(1,1)
c       b=x*hmat(2,1)+y*hmat(2,2)
c       c=x*hmat(3,1)+y*hmat(3,2)+z*hmat(3,3)

        a=x*hmat(1,1)+y*hmat(2,1)+z*hmat(3,1)
        b=            y*hmat(2,2)+z*hmat(3,2)
        c=                        z*hmat(3,3)
              
       return
       end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine tranoc(a,b,c,hinv,x,y,z)
*
*****c***1********2*******3********4********5********6********7********8
*
* matrix algebra for Reverse Monte Carlo (Parinello-Rahman):
*
* (tran)sformation from (c)rystallographic (a) 
* to        cartesian ( (o)rthogonal       (x) coordinates
* x = HI.a
*
* source:  C. Giacovazzo, Fundamentals of Crystallography, 68pp.
* and:     M. Parrinello, and A. Rahman, J. Appl. Phys. 52 (1981), 7182
*
* m. winterer 3/5/98
* revised 11/26/14 mw
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       real a,b,c,x,y,z,hinv(3,3)
*
*
* transformation
*
c       x=a*hinv(1,1)
c       y=a*hinv(2,1)+b*hinv(2,2)
c       z=a*hinv(3,1)+b*hinv(3,2)+c*hinv(3,3)
              
       x=a*hinv(1,1)+b*hinv(2,1)+c*hinv(3,1)
       y=            b*hinv(2,2)+c*hinv(3,2)
       z=                        c*hinv(3,3)

       return
       end

*****c****1********2*******3********4********5********6********7********8
      subroutine inpar(filcoo,hn,kn,ln,alatt,blatt,clatt,
     1                 alphad,betad,gammad)
******c***1********2*******3********4********5********6********7********8
*
*     declarations
*
      implicit none
      integer hn,kn,ln
      real alatt,blatt,clatt
      real alphad,betad,gammad
      character*256 filpar,filcoo
*
      filpar='distill.par'
      open(9,file=filpar,status='old')
      read(9,'(a)')filcoo
      read(9,*)alatt,blatt,clatt
c      print *,alatt,blatt,clatt
      read(9,*)alphad,betad,gammad
c      print *,alphad,betad,gammad
      read(9,*)hn,kn,ln
c      print *,hn,kn,ln
      close(9,status='keep')
*
      return
      end
