*****c***1********2*******3********4********5********6********7********8
*
       program coord 
*
*****c***1********2*******3********4********5********6********7********8
*
* matrix algebra for Reverse Monte Carlo (Parinello-Rahman)
*
* m. winterer 3/5/98
* 
* revised 11/26/14 mw in transformation subroutines
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       integer hn,kn,ln,iol,matom,natom,i,mu,nu
       parameter(matom=1000000,mu=2000)
       integer typ(matom),utyp(mu)
       real alatt,blatt,clatt,alpha,beta,gamma
       real alphad,betad,gammad
       real xu(mu),yu(mu),zu(mu),r,s,t
       real xc(matom),yc(matom),zc(matom),a(matom),b(matom),c(matom) 
       real volume,hmat(3,3),hinv(3,3),gmet(3,3),rij,rij2,hmatt(3,3)
       real cmat(3,3),det,xt(matom),yt(matom),zt(matom)
       real pi
       character*1 mode
       
       pi=4.*atan(1.0)
*
* input
*
       iol=10
       print *,'matrix algebra for Reverse Monte Carlo'
       print *,' '
       print *,'version 11/26/14mw'
       print *,' '
       open(iol,file='coord.par',status='unknown')
        print *,'opened file coord.par'
        read(iol,*)alatt
        read(iol,*)blatt
        read(iol,*)clatt
       
        read(iol,*)hn
        read(iol,*)kn
        read(iol,*)ln
       
        read(iol,*)alphad
        read(iol,*)betad
        read(iol,*)gammad

c        read(iol,'(a)')mode
       
        i=0
10      continue
         i=i+1
         read(iol,*,end=11)utyp(i),xu(i),yu(i),zu(i)
        goto 10
11      continue
        nu=i-1

       close(10,status='keep')
       print *,'closed file coord.par'
       print *,' '
*
* transformations
*
       alpha=alphad*pi/180.
       beta= betad*pi/180.
       gamma=gammad*pi/180.

       
       print *,'INPUT'
       print *,' '
       print *,'alatt= ',alatt
       print *,'blatt= ',blatt
       print *,'clatt= ',clatt
       print *,'hn ',hn
       print *,'kn ',kn
       print *,'ln ',ln
       print *,'alpha= ',alpha,' alphad= ',alphad
       print *,'beta= ',beta,' betad= ',betad
       print *,'gamma= ',gamma,' gammad= ',gammad
       print *,' '
c       print *,'transformation direction: ',mode
c       print *,' '
       print *,'atoms in asymmetric unit: '
       print *,' '
       do i=1,nu
        print *,i,utyp(i),xu(i),yu(i),zu(i)
       enddo
*
* transformations
*

       call makehm(alatt,blatt,clatt,hn,kn,ln,
     1                   alpha,beta,gamma,volume,hmat)
       call makehi(alatt,blatt,clatt,hn,kn,ln,
     1                   alpha,beta,gamma,volume,hinv)
       call makegm(hmat,gmet)
       print *,' '
       print *,'check for inversity: '
       call matmul(hmat,hinv,cmat)
       print *,' '
       call determ(gmet,det)
       print *,' '
       call transp(hmat,hmatt)
       print *,' '
       call matmul(hmat,hmatt,cmat)
       print *,' '
       print *, cmat(1,1), cmat(1,2), cmat(1,3)
       print *, cmat(2,1), cmat(2,2), cmat(2,3)
       print *, cmat(3,1), cmat(3,2), cmat(3,3)
*
* generate canonical coordinates
*
       call gencoo(matom,natom,mu,nu,hn,kn,ln,
     1             xu,yu,zu,utyp,xc,yc,zc,typ)
*
* transformation to cartesian coordinates
*
c       if(mode.eq.'o')then
c        print *,' '
c        print *,'conversion of asymmetric unit'
c        do i=1,nu
c         call tranco(xu(i),yu(i),zu(i),hmat,r,s,t)
c         print *,i,r,s,t
c        enddo
c        print *,' '

        do i=1,natom
         call tranco(xc(i),yc(i),zc(i),hmat,a(i),b(i),c(i))
        enddo

c        do i=1,natom
c         call tranoc(a(i),b(i),c(i),hinv,xt(i),yt(i),zt(i))
c        enddo
        
        open(11,file='ortho.coo',status='unknown')
        do i=1,natom
         write(11,9000)i,typ(i),xc(i),yc(i),zc(i),0.0,1.0
        enddo
        close(11,status='keep')

        open(11,file='crysta.coo',status='unknown')
        do i=1,natom
         write(11,9000)i,typ(i),a(i),b(i),c(i),0.0,1.0
        enddo
        close(11,status='keep')

c        open(11,file='test.coo',status='unknown')
c        do i=1,natom
c         write(11,9000)i,typ(i),xt(i),yt(i),zt(i),0.0,1.0
c        enddo
c        close(11,status='keep')

9000   format(i6,1x,i2,5(1x,g13.6))

c        call tranco(x1,y1,z1,hmat,a1,b1,c1)
c        call tranco(x2,y2,z2,hmat,a2,b2,c2)
c
c        call tranoc(a1,b1,c1,hinv,x1,y1,z1)
c        call tranoc(a2,b2,c2,hinv,x2,y2,z2)
c
c        call distan(x1,y1,z1,x2,y2,z2,gmet,rij)
c
c       elseif(mode.eq.'c')then
c
c        call tranoc(x1,y1,z1,hinv,a1,b1,c1)
c        call tranoc(x2,y2,z2,hinv,a2,b2,c2)
c
c        call tranco(a1,b1,c1,hmat,x1,y1,z1)
c        call tranco(a2,b2,c2,hmat,x2,y2,z2)
c
c        call distan(a1,b1,c1,a2,b2,c2,gmet,rij)
c
c       else
c        print *,'no such transformation'
c       endif
c       
c       call dista2(x1,y1,z1,x2,y2,z2,alatt,blatt,clatt,
c     1              alpha,beta,gamma,rij2)
c
*
* results
*
       print *,' '
       print *,'RESULTS'
       print *,' '
       print *,'volume= ',volume
       print *,' '
       print *,'hmat:'
       print *,hmat(1,1),hmat(1,2),hmat(1,3)
       print *,hmat(2,1),hmat(2,2),hmat(2,3)
       print *,hmat(3,1),hmat(3,2),hmat(3,3)
       print *,' '
       print *,'hinv:'
       print *,hinv(1,1),hinv(1,2),hinv(1,3)
       print *,hinv(2,1),hinv(2,2),hinv(2,3)
       print *,hinv(3,1),hinv(3,2),hinv(3,3)
       print *,' '
       print *,'gmet:'
       print *,gmet(1,1),gmet(1,2),gmet(1,3)
       print *,gmet(2,1),gmet(2,2),gmet(2,3)
       print *,gmet(3,1),gmet(3,2),gmet(3,3)
       print *,' '
c       print *,'x1,y1,z1: '
c       print *,x1,y1,z1
c       print *,' '
c       print *,'x2,y2,z2: '
c       print *,x2,y2,z2
c       print *,' '
c       print *,'a1,b1,c1'
c       print *,a1,b1,c1
c       print *,' '
c       print *,'a2,b2,c2'
c       print *,a2,b2,c2
c       print *,' '
c       print *,'rij= ',rij
*       
       end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine makehm(alatt,blatt,clatt,hn,kn,ln,
     1                   alpha,beta,gamma,volume,hmat)
*
*****c***1********2*******3********4********5********6********7********8
*
* matrix algebra for Reverse Monte Carlo (Parinello-Rahman):
*
* make transformation matrix H for transformation 
* from cartesian to crystallographic coordinates
*
* source:  C. Giacovazzo, Fundamentals of Crystallography, 68pp.
*
* m. winterer 3/5/98
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       integer hn,kn,ln
       real alatt,blatt,clatt,alpha,beta,gamma
       real a,b,c
       real volume,cosa,cosb,cosg,sinb,sing,cosas,cs
       real hmat(3,3)
*
* geometric factors
*
       a=real(hn)*alatt
       b=real(kn)*blatt
       c=real(ln)*clatt
       
       cosa=sngl(dcos(dble(alpha)))
       cosb=sngl(dcos(dble(beta)))
       cosg=sngl(dcos(dble(gamma)))
       sinb=sngl(dsin(dble(beta)))
       sing=sngl(dsin(dble(gamma)))
       
       cosas=(cosb*cosg-cosa)/(sinb*sing)
       
       volume=a*b*c*
     1        sqrt(1.0-cosa*cosa-cosb*cosb-cosg*cosg
     2             + 2.0*cosa*cosb*cosg)
       
       cs=a*b*sing/volume
*
* matrix elements
*
       hmat(1,1)= a
       hmat(1,2)= 0.0
       hmat(1,3)= 0.0
       hmat(2,1)= b*cosg
       hmat(2,2)= b*sing
       hmat(2,3)= 0.0
       hmat(3,1)= c*cosb
       hmat(3,2)=-c*sinb*cosas 
       hmat(3,3)= 1.0/cs

c       print *,'hmat in makehm'
c       print *,hmat(1,1),hmat(1,2),hmat(1,3)
c       print *,hmat(2,1),hmat(2,2),hmat(2,3)
c       print *,hmat(3,1),hmat(3,2),hmat(3,3)
              
       return
       end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine makehi(alatt,blatt,clatt,hn,kn,ln,
     1                   alpha,beta,gamma,volume,hinv)
*
*****c***1********2*******3********4********5********6********7********8
*
* matrix algebra for Reverse Monte Carlo (Parinello-Rahman):
*
* make inverse transformation matrix HI for transformation 
* from crystallographic to cartesian coordinates
*
* source:  C. Giacovazzo, Fundamentals of Crystallography, 68pp.
*
* m. winterer 3/5/98
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       integer hn,kn,ln
       real alatt,blatt,clatt,alpha,beta,gamma
       real a,b,c
       real volume,cosa,cosb,cosg,sina,sinb,sing
       real cosas,cosbs,as,bs,cs
       real hinv(3,3)
*
* geometric factors
*
       a=real(hn)*alatt
       b=real(kn)*blatt
       c=real(ln)*clatt
       
       cosa=sngl(dcos(dble(alpha)))
       cosb=sngl(dcos(dble(beta)))
       cosg=sngl(dcos(dble(gamma)))
       sina=sngl(dsin(dble(alpha)))
       sinb=sngl(dsin(dble(beta)))
       sing=sngl(dsin(dble(gamma)))
       cosas=(cosb*cosg-cosa)/(sinb*sing)
       cosbs=(cosa*cosg-cosb)/(sina*sing)
              
       as=b*c*sina/volume
       bs=a*c*sinb/volume
       cs=a*b*sing/volume
*
* matrix elements
*
       hinv(1,1)= 1./a
       hinv(1,2)= 0.0
       hinv(1,3)= 0.0
       hinv(2,1)=-cosg/(a*sing)
       hinv(2,2)= 1./(b*sing)
       hinv(2,3)= 0.0
       hinv(3,1)= as*cosbs
       hinv(3,2)= bs*cosas 
       hinv(3,3)= cs

c       print *,'hinv: in makehi'
c       print *,hinv(1,1),hinv(1,2),hinv(1,3)
c       print *,hinv(2,1),hinv(2,2),hinv(2,3)
c       print *,hinv(3,1),hinv(3,2),hinv(3,3)
              
       return
       end

*****c***1********2*******3********4********5********6********7********8
*
       subroutine transp(mat,tam)
*
*****c***1********2*******3********4********5********6********7********8
*
*      compute transpose of matrix mat: tam = mat'
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       real tam(3,3),mat(3,3)

       tam(1,1)=mat(1,1)
       tam(1,2)=mat(2,1)
       tam(2,3)=mat(3,1)
       tam(2,1)=mat(1,2)
       tam(2,2)=mat(2,2)
       tam(2,3)=mat(3,2)
       tam(3,1)=mat(1,3)
       tam(3,2)=mat(2,3)
       tam(3,3)=mat(3,3)


       print *,' '
       print *, mat(1,1), mat(1,2), mat(1,3)
       print *, mat(2,1), mat(2,2), mat(2,3)
       print *, mat(3,1), mat(3,2), mat(3,3)
       print *,' '
       print *,' '
       print *, tam(1,1), tam(1,2), tam(1,3)
       print *, tam(2,1), tam(2,2), tam(2,3)
       print *, tam(3,1), tam(3,2), tam(3,3)
       print *,' '



       return
       end


*****c***1********2*******3********4********5********6********7********8
*
       subroutine makegm(hmat,gmet)
*
*****c***1********2*******3********4********5********6********7********8
*
* matrix algebra for Reverse Monte Carlo (Parinello-Rahman):
*
* make metric matrix G = H'.H; G is symmetric
*
* source:  C. Giacovazzo, Fundamentals of Crystallography, 68pp.
* and:     M. Parrinello, and A. Rahman, J. Appl. Phys. 52 (1981), 7182
*
* m. winterer 3/5/98
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       real gmet(3,3),hmat(3,3)
*
* matrix elements
*
c       gmet(1,1)= hmat(1,1)*hmat(1,1)+hmat(2,1)*hmat(2,1)
c     1           +hmat(3,1)*hmat(3,1)
c       gmet(1,2)= hmat(2,1)*hmat(2,2)+hmat(3,1)*hmat(3,2)
c       gmet(1,3)= hmat(3,1)*hmat(3,3)
c       gmet(2,1)= gmet(1,2)
c       gmet(2,2)= hmat(2,2)*hmat(2,2)+hmat(3,2)*hmat(3,2)
c       gmet(2,3)= hmat(3,2)*hmat(3,3)
c       gmet(3,1)= gmet(1,3)
c       gmet(3,2)= gmet(2,3)
c       gmet(3,3)= hmat(3,3)*hmat(3,3)

       gmet(1,1)= hmat(1,1)*hmat(1,1)
       gmet(1,2)= hmat(1,1)*hmat(2,1)
       gmet(1,3)= hmat(1,1)*hmat(3,1)
       gmet(2,1)= gmet(1,2)
       gmet(2,2)= hmat(2,1)*hmat(2,1)+hmat(2,2)*hmat(2,2)
       gmet(2,3)= hmat(2,1)*hmat(3,1)+hmat(2,2)*hmat(3,2)
       gmet(3,1)= gmet(1,3)
       gmet(3,2)= gmet(2,3)
       gmet(3,3)= hmat(3,1)*hmat(3,1)+hmat(3,2)*hmat(3,2)+
     1            hmat(3,3)*hmat(3,3)
              
c       print *,'gmet in makegm:'
c       print *,gmet(1,1),gmet(1,2),gmet(1,3)
c       print *,gmet(2,1),gmet(2,2),gmet(2,3)
c       print *,gmet(3,1),gmet(3,2),gmet(3,3)

       return
       end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine tranco(x,y,z,hmat,a,b,c)
*
*****c***1********2*******3********4********5********6********7********8
*
* matrix algebra for Reverse Monte Carlo (Parinello-Rahman):
*
* (tran)sformation from cartesian ( (o)rthogonal (x)
*                to                 (c)rystallographic (a) coordinates
* a = H.x
*
* source:  C. Giacovazzo, Fundamentals of Crystallography, 68pp.
* and:     M. Parrinello, and A. Rahman, J. Appl. Phys. 52 (1981), 7182
*
* m. winterer 3/5/98
* revised 11/26/14 mw
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       real a,b,c,x,y,z,hmat(3,3)
*
*
* transformation 
*
c       a=x*hmat(1,1)
c       b=x*hmat(2,1)+y*hmat(2,2)
c       c=x*hmat(3,1)+y*hmat(3,2)+z*hmat(3,3)

        a=x*hmat(1,1)+y*hmat(2,1)+z*hmat(3,1)
        b=            y*hmat(2,2)+z*hmat(3,2)
        c=                        z*hmat(3,3)
              
       return
       end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine tranoc(a,b,c,hinv,x,y,z)
*
*****c***1********2*******3********4********5********6********7********8
*
* matrix algebra for Reverse Monte Carlo (Parinello-Rahman):
*
* (tran)sformation from (c)rystallographic (a) 
* to        cartesian ( (o)rthogonal       (x) coordinates
* x = HI.a
*
* source:  C. Giacovazzo, Fundamentals of Crystallography, 68pp.
* and:     M. Parrinello, and A. Rahman, J. Appl. Phys. 52 (1981), 7182
*
* m. winterer 3/5/98
* revised 11/26/14 mw
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       real a,b,c,x,y,z,hinv(3,3)
*
*
* transformation
*
c       x=a*hinv(1,1)
c       y=a*hinv(2,1)+b*hinv(2,2)
c       z=a*hinv(3,1)+b*hinv(3,2)+c*hinv(3,3)
              
       x=a*hinv(1,1)+b*hinv(2,1)+c*hinv(3,1)
       y=            b*hinv(2,2)+c*hinv(3,2)
       z=                        c*hinv(3,3)

       return
       end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine distan(a,b,c,x,y,z,gmet,rij)
*
*****c***1********2*******3********4********5********6********7********8
*
* matrix algebra for Reverse Monte Carlo (Parinello-Rahman):
*
* calculation of atomic distances rij
* 
* rij=sqrt((si-sj)*G*(si-sj))
* G: metric matrix; si,sj: vectors of atoms i and j in cryst. coordinates 
*
* source:  C. Giacovazzo, Fundamentals of Crystallography, 68pp.
* and:     M. Parrinello, and A. Rahman, J. Appl. Phys. 52 (1981), 7182
*
* m. winterer 3/5/98
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       real a,b,c,x,y,z,gmet(3,3),rij,dx,dy,dz
*
* point distances
*
c       dx=a-x
c       dy=b-y
c       dz=c-z
       dx=x-a
       dy=y-b
       dz=z-c

       print *,'rij: dx, dy, dz: ',dx,dy,dz
       
       rij=sqrt(
     1          dx*(dx*gmet(1,1)+dy*gmet(2,1)+dz*gmet(3,1))+
     2          dy*(dx*gmet(1,2)+dy*gmet(2,2)+dz*gmet(3,2))+
     3          dz*(dx*gmet(1,3)+dy*gmet(2,3)+dz*gmet(3,3)))
       print *,'rij= ',rij
 
        rij=sqrt(
     1          dx*dx*gmet(1,1)+dy*dy*gmet(2,2)+dz*dz*gmet(3,3)+
     2          2.*dx*dy*gmet(1,2)+
     3          2.*dy*dz*gmet(2,3)+
     4          2.*dx*dz*gmet(1,3))
     
       print *,'rij= ',rij
              
       return
       end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine dista2(x1,y1,z1,x2,y2,z2,a,b,c,alpha,beta,gamma,rij)
*
*****c***1********2*******3********4********5********6********7********8
*
* matrix algebra for Reverse Monte Carlo (Parinello-Rahman):
*
* calculation of atomic distances rij
*
* source:  C. Giacovazzo, Fundamentals of Crystallography, 68pp.
* and:     M. Parrinello, and A. Rahman, J. Appl. Phys. 52 (1981), 7182
* and      J. P. Clusker, Crystal Structure Analysis for Chemists
*          Biologists, VHH1994, p.424
*
* m. winterer 3/5/98
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       real x1,y1,z1,x2,y2,z2,a,b,c,alpha,beta,gamma,rij
       real cosa,cosb,cosg,dx,dy,dz       
*
* point distances
*
       dx=x2-x1
       dy=y2-y1
       dz=z2-z1

       cosa=sngl(dcos(dble(alpha)))
       cosb=sngl(dcos(dble(beta)))
       cosg=sngl(dcos(dble(gamma)))

       print *,'rij2: dx, dy, dz: ',dx,dy,dz
       
       rij=sqrt( dx*dx*a*a
     1          +dy*dy*b*b
     2          +dz*dz*c*c
     3          +2.*a*b*dx*dy*cosg
     4          +2.*a*c*dx*dz*cosb
     5          +2.*b*c*dy*dz*cosa)
     
       print *,'rij2= ',rij 
       return
       end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine determ(a,det)
*
*****c***1********2*******3********4********5********6********7********8
*
* matrix algebra for Reverse Monte Carlo (Parinello-Rahman):
*
* calculationm of the determant of a 3-dimensional matrix
*
* m. winterer 3/5/98
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       real a(3,3),det
       
       det=a(1,1)*a(2,2)*a(3,3)
     1    +a(1,2)*a(2,3)*a(3,1)
     2    +a(1,3)*a(2,1)*a(3,2)
     3    -a(3,1)*a(2,2)*a(1,3)
     4    -a(3,2)*a(2,3)*a(1,1)
     5    -a(3,3)*a(2,1)*a(1,2)
       
       print *,'det= ',det,' volume= ',sqrt(det)
       
       return
       end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine matmul(a,b,c)
*
*****c***1********2*******3********4********5********6********7********8
*
* matrix algebra for Reverse Monte Carlo (Parinello-Rahman):
*
* multiplication of two 3-dimensional square matrices
*
* m. winterer 3/5/98
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       integer i,j
       real a(3,3),b(3,3),c(3,3)
       
*
* matrix elements
*
       c(1,1)=a(1,1)*b(1,1)+a(1,2)*b(2,1)+a(1,3)*b(3,1)
       c(1,2)=a(1,1)*b(1,2)+a(1,2)*b(2,2)+a(1,3)*b(3,2)
       c(1,3)=a(1,1)*b(1,3)+a(1,2)*b(2,3)+a(1,3)*b(3,3)
       c(2,1)=a(2,1)*b(1,1)+a(2,2)*b(2,1)+a(2,3)*b(3,1)
       c(2,2)=a(2,1)*b(1,2)+a(2,2)*b(2,2)+a(2,3)*b(3,2)
       c(2,3)=a(2,1)*b(1,3)+a(2,2)*b(2,3)+a(2,3)*b(3,3)
       c(3,1)=a(3,1)*b(1,1)+a(3,2)*b(2,1)+a(3,3)*b(3,1)
       c(3,2)=a(3,1)*b(1,2)+a(3,2)*b(2,2)+a(3,3)*b(3,2)
       c(3,3)=a(3,1)*b(1,3)+a(3,2)*b(2,3)+a(3,3)*b(3,3)
              
       do i=1,3
	 write(*,'(3(1x,g13.6))')(c(i,j),j=1,3)
       enddo
       return
       end
      
*****c***1********2*******3********4********5********6********7********8
*
       subroutine gencoo(matom,natom,mu,nu,hn,kn,ln,
     1             xu,yu,zu,utyp,xc,yc,zc,typ)
*
*****c***1********2*******3********4********5********6********7********8
*
* generate canonical coordinates from asymtric unit / unit cell
*
*
*****c***1********2*******3********4********5********6********7********8
*
* m. winterer 3/6/98 darmstadt
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations 
*
       implicit none
* global variables
*
       integer natom,matom,mu,nu,hn,kn,ln
       integer typ(matom),mtyp,ntyp
       real xu(mu),yu(mu),zu(mu)
       real xc(matom),yc(matom),zc(matom)
* local variables
*
       integer i,h,k,l,n
       integer utyp(mu)
       real boxh,boxk,boxl
*
*****c***1********2*******3********4********5********6********7********8
*
* add more unit cells
*
       natom=0
       do 600 h=0,hn-1
        do 500 k=0,kn-1
	 do 400 l=0,ln-1
	  do 300 n=1,nu
          natom=natom+1
	   xc(natom)=xu(n)+float(h)
	   yc(natom)=yu(n)+float(k)
	   zc(natom)=zu(n)+float(l)
          typ(natom)=utyp(n)
300       continue
400      continue
500     continue
600    continue
       boxh=float(hn)
       boxk=float(kn)
       boxl=float(ln)
*
* canonical coordinates: [-0.5,0.5[
*
        do 701 i=1,natom
	 xc(i)=xc(i)/boxh-0.5
         yc(i)=yc(i)/boxk-0.5
	 zc(i)=zc(i)/boxl-0.5
         xc(i)=xc(i)-anint(xc(i))
         yc(i)=yc(i)-anint(yc(i))
         zc(i)=zc(i)-anint(zc(i))
701     continue
       print *,'generated ',natom,' lattice points'
       return
       end
