*****c***1********2*******3********4********5********6********7********8
*
       program rmcana
*
*****c***1********2*******3********4********5********6********7********8
* m. winterer 7/8/98
*
* increased length of filename, 08/13/21mw
* increased number of bins, 06/01/22mw
*****c***1********2*******3********4********5********6********7********8
      implicit none
      integer mhis,nhis1,mpdf,npdf,msam,nsam,imin,imax
      parameter(mhis=10000,mpdf=10,msam=2)
      integer nhis(msam),ipdf(msam)
      integer i,k,n,knstrn(msam),knstrs
      real rad1(mhis)
      real gij1(mhis,mpdf),con1(mhis,mpdf)
      real rad(mhis,msam)
      real gij(mhis,mpdf,msam),con(mhis,mpdf,msam)
      real rmin,rmax,conu(msam),codi(msam),rmod(msam)
      real vari(msam),varl(msam),varr(msam),stad(msam)
      real asy1(msam),asy2(msam),pmo3(msam),skew(msam)
      real pmo4(msam),kurt(msam),cum4(msam)
      real errc(msam),errd(msam),errv(msam),err3(msam),err4(msam)
      real errs(msam),errk(msam),erru(msam)
      real tt,dft,ft,ff,fp,dfd,chsq,fd
      character*80 sample(msam)
      character*256 filpdf
      character*1 answer
*
1     continue
      print *,' '
      nsam=2
      open(16,file='rmcana.res',status='unknown')
      write(16,'(a)')'analysis of rmc pdfs'
      write(16,'(a)')' '
      print *,'analyse rmc results'        
      print *,' '
      print *,' m. winterer 06/01/2022' 
      print *,' '
      print *,'analyse one or two pdfs (<=2): '
      read(*,*)nsam
      if(nsam.gt.2)nsam=2
      print *,' '
      do n=1,msam
       do i=1,mhis
         rad(i,n)=0.0
        do k=1,mpdf
         gij(i,k,n)=0.0
         con(i,k,n)=0.0
        enddo
       enddo
      enddo
      do n=1,nsam
       print *,'pdf file (',n,') : '
       read(*,'(a)')filpdf
       write(16,'(a)')'file: '//filpdf
       write(16,'(a)')' '
*
       call inpdf(mhis,nhis1,mpdf,npdf,rad1,gij1,con1,filpdf)
       nhis(n)=nhis1
       do i=1,nhis(n)
        do k=1,npdf
         gij(i,k,n)=gij1(i,k)
         con(i,k,n)=con1(i,k)
        enddo
        rad(i,n)=rad1(i)
       enddo
       print *,'sample name (',n,') : '
       read(*,'(a)')sample(n)
      enddo
10    continue
      print *,' '
* check bin structure
      if(nsam.eq.2)then
      nhis1=min0(nhis(1),nhis(2))
      do i=1,nhis1
       if(rad(i,1).ne.rad(i,2))then
        print *,'inconsistent bining: adjusted by linear interpolation'
        call conbin(msam,mhis,nhis,mpdf,npdf,rad,gij,con)
        nhis1=nhis(1)
        goto 15
       endif
      enddo
15    continue
      endif
* analysis
      knstrs=0
      do n=1,nsam
       print *,'number of pdf to analyze for sample (',n,') :'
       read(*,*)ipdf(n)
       print *,' '
       print *,'number of constraints for sample (',n,'):'
       read(*,*)knstrn(n)
       knstrs=knstrs+knstrn(n)
      enddo
      print *,' '
      print *,'rmin, rmax:'
      read(*,*)rmin,rmax
      call locate(rad1,mhis,nhis1,rmin,imin)
      call locate(rad1,mhis,nhis1,rmax,imax)
      if(imin.eq.0)imin=1
      if(imax.gt.nhis1)imax=nhis1
      rmin=rad1(imin)
      rmax=rad1(imax)
      if((rmax.le.rmin).or.(imin.eq.imax))then
       print *,'no data in this window'
       goto 100
      endif
      call pdfana(mhis,nhis1,mpdf,npdf,ipdf,msam,nsam,rad,gij,con,
     1                  imin,imax,conu,codi,rmod,vari,varl,varr,stad,
     2                  asy1,asy2,pmo3,skew,pmo4,kurt,cum4,
     3                  errc,errd,errv,err3,err4,*100)
      do n=1,nsam
       errs(n)=sqrt(6./float(imax-imin))
       errk(n)=sqrt(24./float(imax-imin))
       erru(n)=err4(n)+6.*vari(n)*errv(n)
      enddo
      if(nsam.eq.2)then
      call statana(mhis,mpdf,msam,imin,imax,ipdf,knstrs,
     1                    codi,vari,gij,tt,dft,ft,ff,fp,dfd,chsq,fd)
      endif
* output
      do n=1,nsam
       print *,'------------------------------------------------'
       print *,' '
       print *,sample(n)
       print *,' '
       print *,'pdf #: ',ipdf(n)
       print *,' '
       print *,'rmin= ',rmin,' rmax= ',rmax
       print *,' '
       print *,'CN=   ',conu(n),' +/- ',errc(n) 
       print *,'Rmea= ',codi(n),' +/- ',errd(n)
       print *,'Rmod= ',rmod(n)
       print *,' '
       print *,'var=  ',vari(n),' +/- ',errv(n)
       print *,'varl= ',varl(n),' varr= ',varr(n)
       print *,'adif= ',asy1(n),' arat= ',asy2(n)
       print *,' '
       print *,'pmo3= ',pmo3(n),' +/- ',err3(n)
       print *,'skew= ',skew(n),' +/- ',errs(n)
       print *,' '
       print *,'pmo4= ',pmo4(n),' +/- ',err4(n)
       print *,'kurt= ',kurt(n),' +/- ',errk(n)
       print *,'cum4= ',cum4(n),' +/- ',erru(n)
       print *,' '
      enddo
      if(nsam.eq.2)then
       print *,' '
       print *,'statistics: '
       print *,' '
       print *,'doff= ',dft
       print *,' '
       print *,'different mean value (stud<<,>>0, sgfc=0.0) ?'
       print *,'stud= ',tt,     ' sgfc= ',ft
       print *,' '
       print *,'different variance (stud<<,>>1, sgfc=0.0) ? '
       print *,'stud= ',ff,     ' sgfc= ',fp
       print *,' '
       print *,'different distributions (chsq<<,>>1, sgfc=0.0) ?'
       print *,'doff= ',dfd
       print *,'chsq= ',chsq,   ' sgfc= ',fd
       print *,' '
       print *,'------------------------------------------------'
       print *,' '
      endif
*
      do n=1,nsam
       write(16,*)'------------------------------------------------'
       write(16,*)' '
       write(16,*)sample(n)
       write(16,*)' '
       write(16,*)'pdf #: ',ipdf(n)
       write(16,*)' '
       write(16,*)'rmin= ',rmin,' rmax= ',rmax
       write(16,*)' '
       write(16,*)'CN=   ',conu(n),' +/- ',errc(n) 
       write(16,*)'Rmea= ',codi(n),' +/- ',errd(n)
       write(16,*)'Rmod= ',rmod(n)
       write(16,*)' '
       write(16,*)'var=  ',vari(n),' +/- ',errv(n)
       write(16,*)'varl= ',varl(n),' varr= ',varr(n)
       write(16,*)'adif= ',asy1(n),' arat= ',asy2(n)
       write(16,*)' ' 
       write(16,*)'pmo3= ',pmo3(n),' +/- ',err3(n)
       write(16,*)'skew= ',skew(n),' +/- ',errs(n)
       write(16,*)' '
       write(16,*)'pmo4= ',pmo4(n),' +/- ',err4(n)
       write(16,*)'kurt= ',kurt(n),' +/- ',errk(n)
       write(16,*)'cum4= ',cum4(n),' +/- ',erru(n)
       write(16,*)' '
      enddo
      if(nsam.eq.2)then
       write(16,*)' '
       write(16,*)'statistics: '
       write(16,*)' '
       write(16,*)'doff= ',dft
       write(16,*)' '
       write(16,*)'different mean value (stud<<,>>0, sgfc=0.0) ?'
       write(16,*)'stud= ',tt,     ' sgfc= ',ft
       write(16,*)' '
       write(16,*)'different variance (stud<<,>>1, sgfc=0.0) ? '
       write(16,*)'stud= ',ff,     ' sgfc= ',fp
       write(16,*)' '
       write(16,*)'different distributions (chsq<<,>>1, sgfc=0.0) ?'
       write(16,*)'doff= ',dfd
       write(16,*)'chsq= ',chsq,   ' sgfc= ',fd
       write(16,*)' '
       write(16,'(a)')'------------------------------------------------'
      endif
*
100   continue
      print *,' '
      print *,'more analysis of the same data set(s) ?'
      read(*,'(a1)')answer
      if(answer.ne.'n')goto 10
      close(16,status='keep')
      print *,' '
      print *,'more analysis of the other data set(s) ?'
      read(*,'(a1)')answer
      if(answer.ne.'n')goto 1
*
      end

*****c***1********2*******3********4********5********6********7********8
*
      subroutine pdfana(mhis,nhis,mpdf,npdf,ipdf,msam,nsam,rad,gij,con,
     1                  imin,imax,conu,codi,rmod,vari,varl,varr,stad,
     2                  asy1,asy2,pmo3,skew,pmo4,kurt,cum4,
     3                  errc,errd,errv,err3,err4,*)
*
*****c***1********2*******3********4********5********6********7********8
       implicit none
* global variables
       integer mhis,nhis,mpdf,npdf,msam,nsam
       real rad(mhis,msam),gij(mhis,mpdf,msam),con(mhis,mpdf,msam)
       integer i,k,imin,imax,ipdf(msam),n
       real conu(msam),codi(msam),rmod(msam)
       real vari(msam),varl(msam),varr(msam),stad(msam)
       real asy1(msam),asy2(msam),pmo3(msam),skew(msam)
       real pmo4(msam),kurt(msam),cum4(msam)
       real cmod,cmod0,norm
       real errc(msam),errd(msam),errv(msam),err3(msam),err4(msam)
       integer mdat,ndat,j
       parameter(mdat=2048)
       real pi(mdat),yi(mdat),ave,erry,dr,cn
       real pin
       pin=4.0*atan(1.0)
*****c***1********2*******3********4********5********6********7********8
      do n=1,nsam
* coordination number:
       conu(n)=con(imax,ipdf(n),n)-con(imin,ipdf(n),n)      
*  error analysis
       dr=rad(2,n)-rad(1,n)
       cn=0.0
       do i=imin,imax
        cn=cn+rad(i,n)*rad(i,n)*dr*gij(i,ipdf(n),n)
       enddo
       j=0
       dr=rad(2,n)-rad(1,n)
       do i=imin,imax
        j=j+1
        pi(j)=gij(i,ipdf(n),n) 
        yi(j)=dr*pi(j)*rad(i,n)*rad(i,n)
       enddo
       ndat=j
       ave=cn
       call errana(mdat,ndat,pi,yi,ave,erry)
       errc(n)=conu(n)*erry/cn 
* coordination distance:
       codi(n)=0.0
       norm=0.0
       cmod=-1.e35
       cmod0=-1.e35
       do i=imin,imax
        codi(n)=codi(n)+gij(i,ipdf(n),n)*rad(i,n)
        norm=norm+gij(i,ipdf(n),n)
        cmod=amax1(cmod,gij(i,ipdf(n),n))
        if(cmod.gt.cmod0)then
         rmod(n)=rad(i,n)
         cmod0=cmod
        endif
       enddo
       if(norm.le.1e-35)then
        print *,'zero norm, no atoms found'
        return 1
       endif
       codi(n)=codi(n)/norm
*  error analysis
       j=0
       do i=imin,imax
        j=j+1
        pi(j)=gij(i,ipdf(n),n) 
        yi(j)=rad(i,n)
       enddo
       ndat=j
       ave=codi(n)
       call errana(mdat,ndat,pi,yi,ave,erry)
       errd(n)=erry
* variance of coordination distance:
       vari(n)=0.0
       varl(n)=0.0
       varr(n)=0.0
       do i=imin,imax
        vari(n)=vari(n)+gij(i,ipdf(n),n)*
     1                  (rad(i,n)-codi(n))*(rad(i,n)-codi(n))
        if(rad(i,n).le.codi(n))then
         varl(n)=varl(n)+gij(i,ipdf(n),n)*
     1                   (rad(i,n)-codi(n))*(rad(i,n)-codi(n))
        endif
        if(rad(i,n).ge.codi(n))then
         varr(n)=varr(n)+gij(i,ipdf(n),n)*
     1                   (rad(i,n)-codi(n))*(rad(i,n)-codi(n))
        endif
       enddo
       vari(n)=vari(n)/norm
       varl(n)=varl(n)/norm
       varr(n)=varr(n)/norm
       asy1(n)=varr(n)-varl(n)
       asy2(n)=varr(n)/varl(n)
       stad(n)=sqrt(vari(n))
*  error analysis
       j=0
       do i=imin,imax
        j=j+1
        pi(j)=gij(i,ipdf(n),n) 
        yi(j)=(rad(i,n)-codi(n))*(rad(i,n)-codi(n))
       enddo
       ndat=j
       ave=vari(n)
       call errana(mdat,ndat,pi,yi,ave,erry)
       errv(n)=erry
* higher moments 
       skew(n)=0.0
       kurt(n)=0.0
       pmo3(n)=0.0
       pmo4(n)=0.0
       cum4(n)=0.0
       if(vari(n).gt.1.e-6)then
        do i=imin,imax
         pmo3(n)=pmo3(n)+gij(i,ipdf(n),n)*
     1                   (rad(i,n)-codi(n))*(rad(i,n)-codi(n))*
     2                   (rad(i,n)-codi(n))
         pmo4(n)=pmo4(n)+gij(i,ipdf(n),n)*
     1                   (rad(i,n)-codi(n))*(rad(i,n)-codi(n))*
     2                   (rad(i,n)-codi(n))*(rad(i,n)-codi(n))
        enddo
        pmo3(n)=pmo3(n)/norm
        pmo4(n)=pmo4(n)/norm
        skew(n)=pmo3(n)/(stad(n)*stad(n)*stad(n))
        kurt(n)=pmo4(n)/(stad(n)*stad(n)*stad(n)*stad(n))-3.
        cum4(n)=pmo4(n)-3.*vari(n)*vari(n)
*  error analysis
       j=0
       do i=imin,imax
        j=j+1
        pi(j)=gij(i,ipdf(n),n) 
        yi(j)=(rad(i,n)-codi(n))*(rad(i,n)-codi(n))*
     1        (rad(i,n)-codi(n))
       enddo
       ndat=j
       ave=pmo3(n)
       call errana(mdat,ndat,pi,yi,ave,erry)
       err3(n)=erry

       j=0
       do i=imin,imax
        j=j+1
        pi(j)=gij(i,ipdf(n),n) 
        yi(j)=(rad(i,n)-codi(n))*(rad(i,n)-codi(n))*
     1        (rad(i,n)-codi(n))*(rad(i,n)-codi(n))
       enddo
       ndat=j
       ave=pmo4(n)
       call errana(mdat,ndat,pi,yi,ave,erry)
       err4(n)=erry
       endif
      enddo
      return
      end
*****c***1********2*******3********4********5********6********7********8
*
      subroutine errana(mdat,ndat,pi,yi,ave,erry)
*
*****c***1********2*******3********4********5********6********7********8
*
* error analysis of distribution
* Groesses Handbuch der Mathemathik, p633
*
*****c***1********2*******3********4********5********6********7********8
*
      implicit none
      integer mdat,ndat,i
      real pi(mdat),yi(mdat),sumpi,err1,ave,erry
*
      sumpi=0.0
      err1=0.0
      do i=1,ndat
       err1=err1+pi(i)*(yi(i)-ave)*(yi(i)-ave)
       sumpi=sumpi+pi(i)
      enddo
      err1=sqrt(err1/float(ndat-1))
      erry=err1/sqrt(sumpi)
      return
      end
***********************************************************************
*
* bisection routine from numerical recipes p.90
* given an array xx of n vectors locate provides index j
* such that x is between xx(j) and xx(j+1)
*
      subroutine locate(xx,np,n,x,j)
      dimension xx(np)
      jl=0
      ju=n+1
10    if(ju-jl.gt.1)then
        jm=(ju+jl)/2
        if((xx(n).gt.xx(1)).eqv.(x.gt.xx(jm)))then
          jl=jm
        else
          ju=jm
        endif
      go to 10
      endif
      j=jl
      return
      end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine inpdf(mhis,nhis,mpdf,npdf,rad,gij,con,filpdf)
*
*****c***1********2*******3********4********5********6********7********8
*
* input partial distribution functions
*
*****c***1********2*******3********4********5********6********7********8
*
* m. winterer 7/8/98 darmstadt
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
* global variables
       integer mhis,nhis,mpdf,npdf
       real rad(mhis),gij(mhis,mpdf),con(mhis,mpdf)
       character*256 filpdf
* local variables
       integer i,k
*
*****c***1********2*******3********4********5********6********7********8
*
       print *,'input pdf data from: ',filpdf
       print *,' '
       print *,'number of pdfs in file (<= 10): '
       read(*,*)npdf
       open(15,file=filpdf,status='unknown')
       i=0
100    continue 
        i=i+1
c        read(15,9000,end=200)
        read(15,*,end=200)
     1               rad(i),(gij(i,k),con(i,k),k=1,npdf)
        goto 100
200    continue
       nhis=i-1
       close(15,status='keep')
       print *,'number of pdfs: ',npdf,' number of bins: ',nhis
9000   format(21(g13.6,1x))
*
*****c***1********2*******3********4********5********6********7********8
*
      return
      end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine statana(mhis,mpdf,msam,imin,imax,ipdf,knstrn,
     1                    codi,vari,gij,tt,dft,ft,ff,fp,dfd,chsq,fd)
*
*****c***1********2*******3********4********5********6********7********8
*
* statistical analysis of distributions
*
* m. winterer 7/9/98
*
* see numerical recipes chapter 13
*
*****c***1********2*******3********4********5********6********7********8
      implicit none
      integer mhis,mpdf,msam,n1,n2,imin,imax,ipdf(msam),knstrn
      real codi(msam),vari(msam),gij(mhis,mpdf,msam)
      real ave1,ave2,var1,var2,tt,dft,ft,ff,fp,dfd,chsq,fd
*
      n1=imax-imin
      n2=n1
      ave1=codi(1)
      ave2=codi(2)
      var1=vari(1)
      var2=vari(2)
      call tutest(n1,n2,ave1,ave2,var1,var2,tt,dft,ft)
      call ftest(n1,n2,var1,var2,ff,fp)
      call ditest(mhis,imin,imax,mpdf,msam,ipdf,knstrn,gij,dfd,chsq,fd)
      return
      end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine tutest(n1,n2,ave1,ave2,var1,var2,tt,df,ft)
*
*****c***1********2*******3********4********5********6********7********8
* students test for data sets of different means
*****c***1********2*******3********4********5********6********7********8
      implicit none
      integer n1,n2
      real ave1,ave2,var1,var2,tt,df,ft,betai
      tt=(ave1-ave2)/sqrt(var1/n1+var2/n2)
      df=(var1/n1+var2/n2)**2/((var1/n1)**2/(n1-1)+(var2/n2)**2/(n2-1))
      ft=betai(0.5*df,0.5,df/(df+tt**2))
      return
      end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine ftest(n1,n2,var1,var2,ff,fp)
*
*****c***1********2*******3********4********5********6********7********8
* students test for data sets of different variances
*****c***1********2*******3********4********5********6********7********8
       implicit none
       integer n1,n2
       real var1,var2,ff,fp,betai,df1,df2
*
       if(var1.gt.var2)then
        ff=var1/var2
        df1=n1-1
        df2=n2-1
       else
        ff=var2/var1
        df1=n2-1
        df2=n1-1
       endif
       fp=    betai(0.5*df2,0.5*df1,df2/(df2+df1*ff))+
     1    (1.-betai(0.5*df1,0.5*df2,df1/(df1+df2/ff)))          
       return
       end
*
*****c***1********2*******3********4********5********6********7********8
*
       subroutine ditest(mhis,imin,imax,mpdf,msam,ipdf,
     1                                            knstrn,gij,df,chsq,fd)
*
*****c***1********2*******3********4********5********6********7********8
*
* chi square test for the difference of two distributions
*
*****c***1********2*******3********4********5********6********7********8
       implicit none
       integer mhis,nbins,mpdf,knstrn,msam,imin,imax,i
       integer ipdf(msam)
       real df,chsq,gij(mhis,mpdf,msam),fd,gammq
*
*
       nbins=imax-imin
       df=nbins-1-knstrn
       chsq=0.0
       do i=imin,imax
        if(gij(i,ipdf(1),1).eq.0.0.and.gij(i,ipdf(2),2).eq.0.0)then
         df=df-1.
        else
         chsq=chsq+ (gij(i,ipdf(1),1)-gij(i,ipdf(2),2))**2/
     1             ((gij(i,ipdf(1),1)+gij(i,ipdf(2),2)))
        endif
       enddo
       fd=gammq(0.5*df,0.5*chsq)
       return
       end

*****c***1********2*******3********4********5********6********7********8

      FUNCTION BETAI(A,B,X)

      IF(X.LT.0..OR.X.GT.1.)PAUSE 'bad argument X in BETAI'

      IF(X.EQ.0..OR.X.EQ.1.)THEN

        BT=0.

      ELSE

        BT=EXP(GAMMLN(A+B)-GAMMLN(A)-GAMMLN(B)

     *      +A*ALOG(X)+B*ALOG(1.-X))

      ENDIF

      IF(X.LT.(A+1.)/(A+B+2.))THEN

        BETAI=BT*BETACF(A,B,X)/A

        RETURN

      ELSE

        BETAI=1.-BT*BETACF(B,A,1.-X)/B

        RETURN

      ENDIF

      END

*****c***1********2*******3********4********5********6********7********8

      FUNCTION BETACF(A,B,X)

      PARAMETER (ITMAX=100,EPS=3.E-7)

      AM=1.

      BM=1.

      AZ=1.

      QAB=A+B

      QAP=A+1.

      QAM=A-1.

      BZ=1.-QAB*X/QAP

      DO 11 M=1,ITMAX

        EM=M

        TEM=EM+EM

        D=EM*(B-M)*X/((QAM+TEM)*(A+TEM))

        AP=AZ+D*AM

        BP=BZ+D*BM

        D=-(A+EM)*(QAB+EM)*X/((A+TEM)*(QAP+TEM))

        APP=AP+D*AZ

        BPP=BP+D*BZ

        AOLD=AZ

        AM=AP/BPP

        BM=BP/BPP

        AZ=APP/BPP

        BZ=1.

        IF(ABS(AZ-AOLD).LT.EPS*ABS(AZ))GO TO 1

11    CONTINUE

      PAUSE 'A or B too big, or ITMAX too small'

1     BETACF=AZ

      RETURN

      END
*****c***1********2*******3********4********5********6********7********8


      FUNCTION GAMMLN(XX)

      REAL*8 COF(6),STP,HALF,ONE,FPF,X,TMP,SER

      DATA COF,STP/76.18009173D0,-86.50532033D0,24.01409822D0,

     *    -1.231739516D0,.120858003D-2,-.536382D-5,2.50662827465D0/

      DATA HALF,ONE,FPF/0.5D0,1.0D0,5.5D0/

      X=XX-ONE

      TMP=X+FPF

      TMP=(X+HALF)*LOG(TMP)-TMP

      SER=ONE

      DO 11 J=1,6

        X=X+ONE

        SER=SER+COF(J)/X

11    CONTINUE

      GAMMLN=TMP+LOG(STP*SER)

      RETURN

      END
*****c***1********2*******3********4********5********6********7********8

      FUNCTION GAMMQ(A,X)

      IF(X.LT.0..OR.A.LE.0.)PAUSE

      IF(X.LT.A+1.)THEN

        CALL GSER(GAMSER,A,X,GLN)

        GAMMQ=1.-GAMSER

      ELSE

        CALL GCF(GAMMQ,A,X,GLN)

      ENDIF

      RETURN

      END

*****c***1********2*******3********4********5********6********7********8

      SUBROUTINE GSER(GAMSER,A,X,GLN)

      PARAMETER (ITMAX=100,EPS=3.E-7)

      GLN=GAMMLN(A)

      IF(X.LE.0.)THEN

        IF(X.LT.0.)PAUSE

        GAMSER=0.

        RETURN

      ENDIF

      AP=A

      SUM=1./A

      DEL=SUM

      DO 11 N=1,ITMAX

        AP=AP+1.

        DEL=DEL*X/AP

        SUM=SUM+DEL

        IF(ABS(DEL).LT.ABS(SUM)*EPS)GO TO 1

11    CONTINUE

      PAUSE 'A too large, ITMAX too small'

1     GAMSER=SUM*EXP(-X+A*LOG(X)-GLN)

      RETURN

      END

*****c***1********2*******3********4********5********6********7********8

      SUBROUTINE GCF(GAMMCF,A,X,GLN)

      PARAMETER (ITMAX=100,EPS=3.E-7)

      GLN=GAMMLN(A)

      GOLD=0.

      A0=1.

      A1=X

      B0=0.

      B1=1.

      FAC=1.

      DO 11 N=1,ITMAX

        AN=FLOAT(N)

        ANA=AN-A

        A0=(A1+A0*ANA)*FAC

        B0=(B1+B0*ANA)*FAC

        ANF=AN*FAC

        A1=X*A0+ANF*A1

        B1=X*B0+ANF*B1

        IF(A1.NE.0.)THEN

          FAC=1./A1

          G=B1*FAC

          IF(ABS((G-GOLD)/G).LT.EPS)GO TO 1

          GOLD=G

        ENDIF

11    CONTINUE

      PAUSE 'A too large, ITMAX too small'

1     GAMMCF=EXP(-X+A*ALOG(X)-GLN)*G

      RETURN

      END

*****c***1********2*******3********4********5********6********7********8
       subroutine conbin(msam,mhis,nhis,mpdf,npdf,rad,gij,con)
       implicit none
       integer msam,mhis,nhis(msam),mpdf,npdf
       real rad(mhis,msam),gij(mhis,mpdf,msam),con(mhis,mpdf,msam)
       integer mbuf,i,k
       parameter(mbuf=10000)
       real buf(mbuf),approx
*
       do k=1,npdf
        do i=1,nhis(1)
         buf(i)=approx(mhis,nhis(2),rad(i,2),gij(i,k,2),rad(i,1))
        enddo
        do i=1,nhis(1)
         gij(i,k,2)=buf(i)
        enddo
        do i=1,nhis(1)
         buf(i)=approx(mhis,nhis(2),rad(i,2),con(i,k,2),rad(i,1))
        enddo
        do i=1,nhis(1)
         con(i,k,2)=buf(i)
        enddo
       enddo
       do i=1,nhis(1)
        rad(i,2)=rad(i,1)
       enddo 
       nhis(2)=nhis(1)
       return
       end
       
*****c***1********2*******3********4********5********6********7********8
       real function approx(md,nd,xx,yy,x)
*****c***1********2*******3********4********5********6********7********8
*
* locate the index j for which x is between 
*  xx(j) and xx(j+1) and approximate by linear interpolation;
*  if x matches xx(k) exactly use exact y.
*  if x is outside the range of xx y is set to zero
!
! do not use for substitution of an array by itself !
!
*
* usage of locate bisection routine from "Numerical Recipes", p.90
*
* M. Winterer 2/23/94
*
       implicit none
       integer j,jl,jm,ju,md,nd
       real xx(md),yy(md),x,lintpo
       jl=0
       ju=nd+1
10     if(ju-jl.gt.1)then
        jm=(ju+jl)/2
	if(x.eq.xx(jm))then
	 approx=yy(jm)
	 return
	else if(x.gt.xx(jm))then
	 jl=jm
	else
	 ju=jm
	end if
       goto 10
       endif
       j=jl
       if(j.eq.0)then
        approx=0.0
       else if(j.eq.nd)then
        approx=0.0
       else
        approx=lintpo(xx(j),xx(j+1),yy(j),yy(j+1),x)
       endif	
       return
       end
*****c***1********2*******3********4********5********6********7********8     
       real function lintpo(x1,x2,y1,y2,u)
*****c***1********2*******3********4********5********6********7********8     
*
* linear interpolation at abscissa u gives ordinate lintpo=A*y1+B*y2
* with A=(x2-u)/(x2-x1) and B=1-A 
*
* M. Winterer tested 2/23/94
*
* usage: declare lintpo as real !
*
       implicit none
       real x1,x2,y1,y2,u,a,b
*
       a=(x2-u)/(x2-x1)
       b=1-a
       lintpo=a*y1+b*y2
       return
       end

