*****c***1********2*******3********4********5********6********7********8
      program rmc2opt
*****c***1********2*******3********4********5********6********7********8
*     convert rmc output "rmc.spe.1" to xafsX files and optical FT's
*
*     M. Winterer 3/21/2020
*
*****c***1********2*******3********4********5********6********7********8
*
      implicit none
      integer mdata,ndatao
      parameter (mdata=2048)
      real ovec(mdata),ohm(mdata),ohi(mdata),ohr(mdata)
      real kpow,rr,e0shft
      character*256 filfef,filein
      character*80 otext(20)
      character*1 rmcmod

      print *,'convert rmc output to xafsX files and optical FTs'
      print *,' '
*
      print *,'name of rmc.spe file: '
      read(*,'(a)')filein
      print *,' '
      print *,'(n)ormal rmc or (a)xs fit: '
      read(*,'(a)')rmcmod
      print *,' '
      print *,'power of k in rmc analysis: '
      read(*,*)kpow
      print *,' '
      print *,'name of file for feff: '
      read(*,'(a)')filfef
      print *,' '
      call inffc(mdata,ndatao,ovec,ohm,ohi,ohr,otext,filfef)
      read(otext(3),'(30x,f5.3)')rr
      e0shft=0.0
      print *,'r / A ',rr,' and e0 / eV = ',e0shft,' used for '
      print *,'phase corrected optical Fourier transform'
      print *,' '
*
* input data convert and output data
*
      call rmccon(rmcmod,filein,mdata,ndatao,kpow,
     1                  ovec,ohm,ohi,ohr,rr,e0shft) 
*      
      end

*****c***1********2*******3********4********5********6********7********8
      subroutine rmccon(rmcmod,filein,mdata,ndatao,kpow,
     1                  ovec,ohm,ohi,ohr,rr,e0shft) 
*****c***1********2*******3********4********5********6********7********8
* convert rmc.spe data
*****c***1********2*******3********4********5********6********7********8
*
      implicit none
      integer mdata,ndata,i,ndatao,mxdata,ndataf
      parameter(mxdata=2048)
      real x(mxdata),y(mxdata),u(mxdata),v(mxdata),s(mxdata)
      real vec(mxdata),dat(mxdata),tsim(mxdata),sim(mxdata)
      real gsim(mxdata),res(mxdata),ery(mxdata)
      real ovec(mdata),ohm(mdata),ohi(mdata),ohr(mdata),rr,e0shft
      real kpow
      character*256 filein,filout
      character*80 title,text(20),buffer
      character*31 xn,yn,un,vn,sn,bu
      character*31 k_n,r_n,d_n,t_n,s_n,g_n,rsn,e_n,fdn,ftn,fsn,fgn,frn
      character*1 rmcmod
*
      if(mxdata.ne.mdata)then
      print *,'WARNING: array size inconsistent: ',mxdata, ' ne ',mdata
      endif
*
      call initd(mdata,mdata,x,0.0)
      call initd(mdata,mdata,y,0.0)
      call initd(mdata,mdata,u,0.0)
      call initd(mdata,mdata,v,0.0)
      call initd(mdata,mdata,s,1.0)
      call initd(mdata,mdata,vec,0.0)
      call initd(mdata,mdata,dat,0.0)
      call initd(mdata,mdata,tsim,0.0)
      call initd(mdata,mdata,sim,0.0)
      call initd(mdata,mdata,gsim,0.0)
      call initd(mdata,mdata,res,0.0)
      call initd(mdata,mdata,ery,0.0)
*
      buffer(1:20)='                   '
      buffer(21:40)='                   '
      buffer(41:60)='                   '
      buffer(61:80)='                   '
      title=buffer
*****c***1********2*******3********4********5********6********7********8
      title(1:36)='rmcxas data of type '//rmcmod//' , power of k : '
      write(title,'(a36,g13.6)')title(1:36),kpow
      do i=1,20
       text(i)=buffer
      enddo
      bu='                               '
      xn=bu
      yn=bu
      un=bu
      vn=bu
      sn=bu
      k_n='k*A                            '
      r_n='r/A                            '
      d_n='data                           '
      t_n='tot_fit                        '
      s_n='rmc_fit                        '
      g_n='axs_fit                        '
      rsn='res=data-rmc                   '
      e_n='rmc errmod                     '
      fdn='FTmag(data)                    '
      ftn='FTmag(tot_fit)                 '
      fsn='FTmag(rmc_fit)                 '
      fgn='FTmag(axs_fit)                 '
      frn='FTmag(res)                     '
*
      ndata=0
      i=0
      open(15,file=filein,status='unknown')
      if(rmcmod.eq.'a')then
10     continue
        i=i+1
        read(15,9000,end=20)vec(i),dat(i),tsim(i),sim(i),gsim(i),
     1                     res(i),ery(i)
        goto 10
20     continue
       close(15,status='keep')
       ndata=i-1
      else
       open(15,file=filein,status='unknown')
30     continue
        i=i+1
        read(15,9000,end=40)vec(i),dat(i),sim(i),res(i),ery(i)
        goto 30
40     continue
       close(15,status='keep')
       ndata=i-1
      endif
      print *,'input ',ndata,' rmcxas data of type ',rmcmod
      print *,' '
      print *,' '
*
* CONVERT AND OUTPUT RMCXAS DATA
*
* DATA 
*
       filout='rmc.dat.dat'
       xn=k_n
       yn=d_n
       un=bu
       vn=bu
       sn=e_n
       do i=1,ndata
        x(i)=vec(i)
        y(i)=dat(i)
        u(i)=0.0
        v(i)=0.0
       enddo
       do i=1,20
        text(i)=buffer
       enddo
       call outdat(mdata,ndata,x,y,u,v,ery,
     1             xn,yn,un,vn,sn,title,text,filout)
* DATA FT
       ndataf=ndata
       call fft(mdata,ndataf,x,y,u,v,
     1          ndatao,ovec,ohm,ohi,ohr,rr,e0shft,text)
*
       filout='rmc.dat.opt'
       xn=r_n
       yn=fdn
       un='imaginary                      '
       vn='real_part                      '
       sn=bu

       call outdat(mdata,ndataf,x,y,u,v,s,
     1             xn,yn,un,vn,sn,title,text,filout)

       call initd(mdata,mdata,x,0.0)
       call initd(mdata,mdata,y,0.0)
       call initd(mdata,mdata,u,0.0)
       call initd(mdata,mdata,v,0.0)
*
* RESIDUAL
*
      xn=k_n
      yn=rsn
      un=bu
      vn=bu
      sn=e_n
       filout='rmc.res.dat'
       do i=1,ndata
        x(i)=vec(i)
        y(i)=res(i)
        u(i)=0.0
        v(i)=0.0
       enddo
       do i=1,20
        text(i)=buffer
       enddo
       call outdat(mdata,ndata,x,y,u,v,ery,
     1             xn,yn,un,vn,sn,title,text,filout)
* FT RESIDUAL
       ndataf=ndata
       call fft(mdata,ndataf,x,y,u,v,
     1          ndatao,ovec,ohm,ohi,ohr,rr,e0shft,text)
*
       filout='rmc.res.opt'
       xn=r_n
       yn=frn
       un='imaginary                      '
       vn='real_part                      '
       sn=bu

       call outdat(mdata,ndataf,x,y,u,v,s,
     1             xn,yn,un,vn,sn,title,text,filout)

       call initd(mdata,mdata,x,0.0)
       call initd(mdata,mdata,y,0.0)
       call initd(mdata,mdata,u,0.0)
       call initd(mdata,mdata,v,0.0)
*
* RMC FIT
*
      xn=k_n
      yn=s_n
      un=bu
      vn=bu
      sn=e_n
       filout='rmc.rmc.dat'
       do i=1,ndata
        x(i)=vec(i)
        y(i)=sim(i)
        u(i)=0.0
        v(i)=0.0
       enddo
       do i=1,20
        text(i)=buffer
       enddo
       call outdat(mdata,ndata,x,y,u,v,ery,
     1             xn,yn,un,vn,sn,title,text,filout)
* FT RMC FIT
       ndataf=ndata
       call fft(mdata,ndataf,x,y,u,v,
     1          ndatao,ovec,ohm,ohi,ohr,rr,e0shft,text)
*
       filout='rmc.rmc.opt'
       xn=r_n
       yn=fsn
       un='imaginary                      '
       vn='real_part                      '
       sn=bu

       call outdat(mdata,ndataf,x,y,u,v,s,
     1             xn,yn,un,vn,sn,title,text,filout)

       call initd(mdata,mdata,x,0.0)
       call initd(mdata,mdata,y,0.0)
       call initd(mdata,mdata,u,0.0)
       call initd(mdata,mdata,v,0.0)
*
* for RMCXAS including AXS
*
       if(rmcmod.eq.'a')then 
*
* RMC AXS TOTAL FIT
*
      xn=k_n
      yn=t_n
      un=bu
      vn=bu
      sn=e_n
       filout='rmc.fit.dat'
       do i=1,ndata
        x(i)=vec(i)
        y(i)=tsim(i)
        u(i)=0.0
        v(i)=0.0
       enddo
       do i=1,20
        text(i)=buffer
       enddo
       call outdat(mdata,ndata,x,y,u,v,ery,
     1             xn,yn,un,vn,sn,title,text,filout)
* FT RMC AXS TOTAL FIT
       ndataf=ndata
       call fft(mdata,ndataf,x,y,u,v,
     1          ndatao,ovec,ohm,ohi,ohr,rr,e0shft,text)
*
       filout='rmc.fit.opt'
       xn=r_n
       yn=ftn
       un='imaginary                      '
       vn='real_part                      '
       sn=bu

       call outdat(mdata,ndataf,x,y,u,v,s,
     1             xn,yn,un,vn,sn,title,text,filout)

       call initd(mdata,mdata,x,0.0)
       call initd(mdata,mdata,y,0.0)
       call initd(mdata,mdata,u,0.0)
       call initd(mdata,mdata,v,0.0)
*
* RMC AXS FIT
*
      xn=k_n
      yn=g_n
      un=bu
      vn=bu
      sn=e_n
       filout='rmc.axs.dat'
       do i=1,ndata
        x(i)=vec(i)
        y(i)=gsim(i)
        u(i)=0.0
        v(i)=0.0
       enddo
       do i=1,20
        text(i)=buffer
       enddo
       call outdat(mdata,ndata,x,y,u,v,ery,
     1             xn,yn,un,vn,sn,title,text,filout)
* DATA AXS FIT
       ndataf=ndata
       call fft(mdata,ndataf,x,y,u,v,
     1          ndatao,ovec,ohm,ohi,ohr,rr,e0shft,text)
*
       filout='rmc.axs.opt'
       xn=r_n
       yn=fgn
       un='imaginary                      '
       vn='real_part                      '
       sn=bu

       call outdat(mdata,ndataf,x,y,u,v,s,
     1             xn,yn,un,vn,sn,title,text,filout)

       call initd(mdata,mdata,x,0.0)
       call initd(mdata,mdata,y,0.0)
       call initd(mdata,mdata,u,0.0)
       call initd(mdata,mdata,v,0.0)

       endif
*
*
9000   format(7(g13.6,1x))

      return
      end
*
*****c***1********2*******3********4********5********6********7********8
       subroutine outdat(mdata,ndata,x,y,u,v,s,xn,yn,un,vn,sn,
     1                           title,text,filout)
*****c***1********2*******3********4********5********6********7********8
      implicit  none
      integer mdata,ndata,i,ion
      real x(mdata),y(mdata),u(mdata),v(mdata),s(mdata)
      character*256 filout
      character*31 xn,yn,un,vn,sn
      character*8 timebuf
      character*9 datebuf
      character*80 title,text(20)
*
* date and time
*
       call timdat(timebuf,datebuf)
*
      ion=15
      open(ion,file=filout,status='unknown')
*
* write header
*
      write(ion,9001,err=9997)timebuf,datebuf,filout
      write(ion,9000,err=9997)title
      do 90 i=1,20
       write(ion,9000,err=9997)text(i)
90    continue
*
* write data
*
      write(ion,9002)xn(:13),yn(:13),un(:13),vn(:13),sn(:13)
       do 103 i=1,ndata
        write(ion,9006,err=9997)x(i),y(i),u(i),v(i),s(i)
103    continue
*
* close and save
*
      close(ion,status='keep')
*****c***1********2*******3********4********5********6********7********8
* 
* formats
*
9000  format('# ',a80)
9001  format('# ',a8,1x,a9,1x,a256)
9002  format(1x,5(a13,1x))
9003  format(1x,2(g13.6,1x))
9004  format(1x,3(g13.6,1x))
9005  format(1x,4(g13.6,1x))
9006  format(1x,5(g13.6,1x))
       return
9997   continue
       print *,'OUTDAT write error'
9998   continue
       print *,'OUTDAT open/close file error'
9999   continue
       print *,'OUTDAT exit'
       return
      end
*
*****c***1********2*******3********4********5********6********7********8
      subroutine initd(mdata,ndata,x,value)
*****c***1********2*******3********4********5********6********7********8
      implicit  none
      integer mdata,ndata,i
      real x(mdata),value
      do 10 i=1,ndata
       x(i)=value
10    continue
      return
      end      
* 
*****c***1********2*******3********4********5********6********7********8
      subroutine timdat(tim,dat)
*****c***1********2*******3********4********5********6********7********8
*
* adjusted for intel fortran compiler ifort on linux
*
      integer dmyhms(8)
      character*12 real_clock(3)
      character*20 buffer
      character*9 dat 
      character*8 tim
      character*2 ctime(3),cdate(3)
      buffer='                    '
      tim='        '
      dat='        '

      call date_and_time(real_clock(1),real_clock(2), real_clock(3),
     1                   dmyhms)

      write(buffer,'(2(i2,1x),i4,1x)')dmyhms(3),dmyhms(2),dmyhms(1)
      read(buffer,'(2(a2,1x),2x,a2)')cdate(1),cdate(2),cdate(3)
      write(buffer,'(3(i2,1x))')dmyhms(5),dmyhms(6),dmyhms(7)
      read(buffer,'(3(a2,1x))')ctime(1),ctime(2),ctime(3)

      tim=ctime(1)//':'//ctime(2)//':'//ctime(3)
      dat=cdate(2)//'/'//cdate(1)//'/'//cdate(3)
      return
      end
*
*****c***1********2*******3********4********5********6********7********8
       subroutine fft(mdata,ndata,vec,hm,hi,hr,
     1                ndatao,ovec,ohm,ohi,ohr,rr,e0shft,text)
*****c***1********2*******3********4********5********6********7********8
*     program to calculate the (f)ast (f)ourier (t)ransfrom
*
*****c****1********2*******3********4********5********6********7**
*     author: M. Winterer 3/16/94, adjusted 03/21/2020 mw
*****c****1********2*******3********4********5********6********7**
*
*     subroutines called: four1
*
*****c****1********2*******3********4********5********6********7**
*      declarations
*
      implicit none
      integer i,j,k,mdata,ndata,isign,ndata2,mdata2
      integer maxdat,ndatao,numcol
      parameter(mdata2=4096,maxdat=2048)
      real vec(mdata),hm(mdata),hi(mdata),hr(mdata),g(mdata2)
* data for optical fourier transform
      real ovec(mdata),ohm(mdata),ohi(mdata),ohr(mdata),s(maxdat)
      real rr,e0shft
*
      real cnf,critk,norm,approx
      real gmax,pi,pih
      real power,vector,vecdel,b,e,f,lintpo
      character*256 filpha
      character*80 text(20),buffer
      character*80 answer
      character*31 xn,yn,un,vn,sn
      character*3 outmod,outmod1
      character*1 opt,fftmod,win
      pi=4*atan(1.0)
      pih=0.5*pi
**************************************************************
*    
*
* data initialization
*
      fftmod='n'
      do 2 i=1,mdata2
       g(i)=0.0
2     continue
      print *,' '
      print *,'fast fourier forward transformation'
      print *,' '
*
**************************************************************
*
*     option for optical, phase corrected transform
*
       opt='y'
c       opt='n'
       print *,'phase correction / optical transformation'
       print *,'with reference distance: ',rr,' A'
       print *,' '
*
* apply hanning square window and k-power
*
      call hansel(mdata,ndata,vec,hm,hr,hi,power,b,e,f,gmax,
     1            win,'f',*9999)
*
*     3. abscissa equally spaced by linear interpolation
*     and expanding number of data to a power of 2
*
      print *,' '
      print *,'expanding number of data to power of 2'
*
      call locate(vec,mdata,ndata,e,j)
      ndata=j
      ndata2=2048
      vecdel=pi/sqrt(float(ndata2))
*
      vector=-vecdel
      do 20 i=1,ndata2
       vector=vector+vecdel
       call locate(vec,mdata,ndata,vector,j)
       if(j.le.1)then
        hi(i)=0.0
       else if(j.ge.ndata)then
        hi(i)=0.0
       else
        hi(i)=lintpo(vec(j),vec(j+1),hm(j),hm(j+1),vector)
       endif
20    continue  
*
* map reference phase and amplitude to data
*
       vector=-vecdel
       do 21 i=1,ndata2
        vector=vector+vecdel
	vec(i)=vector
21     continue  
       do 35 i=1,ndata2
	ohm(i)=approx(maxdat,ndatao,ovec,ohr,vec(i))
	if(vec(i).ne.0.0)then
         ohm(i)=ohm(i)-2.0*rr*vec(i)+0.262467*rr*e0shft/vec(i)
	else
	 ohm(i)=0.0
        endif
35     continue
**************************************************************
* 
*     5. sorting expanded data for FFT and normalization
*
      do 40 i=1,ndata2
       j=2*i-1
       k=2*i
       if(opt.eq.'n')then
        g(j)=0.0
        g(k)=hi(i)
       elseif(opt.eq.'y')then
        g(j)=hi(i)*cos(ohm(i))
        g(k)=hi(i)*sin(ohm(i))
       endif
       hi(i)=0.0
       hm(i)=0.0
       hr(i)=0.0
40     continue
**************************************************************
*     forward transform: isign=1
*
      isign=1
      print *,'call fft routine (forward)'
      print *,' '
*
      call four1(g,mdata2,ndata2,isign)
*
**************************************************************
*     calculating inverse abscissa values and sorting
*      output of FFT
*
      print *,'processing output of fft routine'
      critk=1.0/vecdel
      norm=1.0/float(ndata2)
      cnf=0.5/vecdel
      j=0
      do 60 i=1,ndata2-1,2
       j=j+1
       vec(j)=real(j-1)*critk*norm
       if(vec(j).gt.cnf) then
         print *,'FFT ERROR: critical Nyquist range exceeded'
         goto 65
       endif
       hr(j)=g(i)*vecdel*gmax
       hi(j)=g(i+1)*vecdel*gmax
       hm(j)=sqrt(hr(j)*hr(j)+hi(j)*hi(j))
60    continue
65    continue
      ndata=j
      j=0
      do 70 i=1,ndata
       j=j+1
       vec(i)=vec(i)*pi
       s(i)=0.0
       if(vec(i).gt.20.0)goto 71
70    continue
71    continue
      ndata=j
*
* write parameters to text for documentation
*
       buffer=text(12)
       if(win.eq.'h')then
        write(buffer,'(a13,f3.1,a7,g11.4,a7,g11.4,a16,g11.4)')
     1  'fft: kpower: ',power,' kmin= ',b,' kmax= ',e,
     2  'hanning fract.: ',f
       elseif(win.eq.'k')then
        write(buffer,'(a13,f3.1,a7,g11.4,a7,g11.4,a16,g11.4)')
     1  'fft: kpower: ',power,' kmin= ',b,' kmax= ',e,
     2  'bessel wheight: ',f
       endif
       read(buffer,'(a80)')text(12)
       buffer=text(13)
       write(buffer,'(a18,a1)')'fft: phase corr.: ',opt
       read(buffer,'(a80)')text(13)
9000  format(a80)
      return
9999  print *,'FFT: exit'

      end

*****c***1********2*******3********4********5********6********7** 
      subroutine four1(data,nnp,nn,isign)
*****c***1********2*******3********4********5********6********7** 
*
* fast fourier transform subroutine from Press et al. "Numerical
*  Recipes"
*
      real*8 wr,wi,wpr,wpi,wtemp,theta
      dimension data(nnp)
      n=2*nn
      j=1
      do 11 i=1,n,2
        if(j.gt.i)then
          tempr=data(j)
          tempi=data(j+1)
          data(j)=data(i)
          data(j+1)=data(i+1)
          data(i)=tempr
          data(i+1)=tempi
        endif
        m=n/2
1       if ((m.ge.2).and.(j.gt.m)) then
          j=j-m
          m=m/2
        go to 1
        endif
        j=j+m
11    continue
      mmax=2
2     if (n.gt.mmax) then
        istep=2*mmax
        theta=6.28318530717959d0/(isign*mmax)
        wpr=-2.d0*dsin(0.5d0*theta)**2
        wpi=dsin(theta)
        wr=1.d0
        wi=0.d0
        do 13 m=1,mmax,2
          do 12 i=m,n,istep
            j=i+mmax
            tempr=sngl(wr)*data(j)-sngl(wi)*data(j+1)
            tempi=sngl(wr)*data(j+1)+sngl(wi)*data(j)
            data(j)=data(i)-tempr
            data(j+1)=data(i+1)-tempi
            data(i)=data(i)+tempr
            data(i+1)=data(i+1)+tempi
12        continue
          wtemp=wr
          wr=wr*wpr-wi*wpi+wr
          wi=wi*wpr+wtemp*wpi+wi
13      continue
        mmax=istep
      go to 2
      endif
      return
      end
*****c***1********2*******3********4********5********6********7********8
      subroutine hansel(mdata,ndata,vec,hm,hr,hi,
     1                                 power,b,e,f,gmax,win,ftmod,*)
*****c***1********2*******3********4********5********6********7********8
*
* select data and apply hanning window for (f)ft and (b)ft
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
      integer mdata,ndata,maxdat,i,jmax,jlow
      parameter(maxdat=2048)
      real hm(mdata),hr(mdata),hi(mdata),vec(mdata)
      real bm(maxdat),br(maxdat),bi(maxdat)
      real power,b,e,f,gmax,gnorm,hsq,hansq,kaibes,han(maxdat)
      real ymax,ymaxh,width
      character*80 answer
      character*31 xn,yn,un,vn,sn
      character*1 ftmod,win
*****c***1********2*******3********4********5********6********7********8
*
      print *,' '
*****c***1********2*******3********4********5********6********7********8
*
* save data in buffer
*
      ymax=-1.e35
      do 1 i=1,ndata
       bm(i)=hm(i)
       br(i)=hr(i)
       bi(i)=hi(i)
       ymax=amax1(ymax,hm(i))
1     continue
*****c***1********2*******3********4********5********6********7********8
*
      win='k'
      f=4.0
      print *,'applying kaiser-bessel window with bessel weight ',f
      print *,' '
*****c***1********2*******3********4********5********6********7********8
* 
* look for reasonable beginning and end point of hanning/square window
*
       print *,'search for start and end of window'
       print *,' '
       i=0
6      continue
        i=i+1
        if(hm(i)*hm(i+1).lt.0.0)then
	 b=vec(i)
        else
	 if(i.lt.ndata)goto 6
	endif
        i=ndata
7      continue
        i=i-1
c	if(vec(i).gt.16.)goto 7
        if(hm(i)*hm(i-1).lt.0.0)then
	 e=vec(i)
	else
	 if(i.gt.0)goto 7
	endif
      print *,'window between ',b,' and ',e
      print *,' '
*
*****c***1********2*******3********4********5********6********7********8
*
*     filter : hanning fraction at both ends: f
*              square fraction in the center: 1-f
*
18    continue
      ymax=-1.e35
      do 19 i=1,ndata
       if((vec(i).ge.b).and.(vec(i).le.e))then
        ymax=amax1(ymax,abs(hm(i)))
       endif
19    continue
      gmax=-1.e+35
      do 20 i=1,ndata
       hsq=kaibes(b,e,f,vec(i))
       han(i)=hsq*ymax
       hm(i)=hm(i)*hsq
       hr(i)=hr(i)*hsq
       hi(i)=hi(i)*hsq
       gmax=amax1(gmax,abs(hm(i)))
20    continue
*
* normalization
*
      print *,'normalization'
      gnorm=1./gmax
      do 50 i=1,ndata
       hm(i)=hm(i)*gnorm
       hr(i)=hr(i)*gnorm
       hi(i)=hi(i)*gnorm
50    continue
*
9000  format(a80)
*
      return
9999  continue
      print *,'HANSEL: exit'
      return 1
      end

*
*****c***1********2*******3********4********5********6********7********8
       real function approx(md,nd,xx,yy,x)
*****c***1********2*******3********4********5********6********7********8
*
* locate the index j for which x is between 
*  xx(j) and xx(j+1) and approximate by linear interpolation;
*  if x matches xx(k) exactly use exact y.
*  if x is outside the range of xx y is set to zero
!
! do not use for substitution of an array by itself !
!
*
* usage of locate bisection routine from "Numerical Recipes", p.90
*
* M. Winterer 2/23/94
*
       implicit none
       integer j,jl,jm,ju,md,nd
       real xx(md),yy(md),x,lintpo
       jl=0
       ju=nd+1
10     if(ju-jl.gt.1)then
        jm=(ju+jl)/2
	if(x.eq.xx(jm))then
	 approx=yy(jm)
	 return
	else if(x.gt.xx(jm))then
	 jl=jm
	else
	 ju=jm
	end if
       goto 10
       endif
       j=jl
       if(j.eq.0)then
        approx=0.0
       else if(j.eq.nd)then
        approx=0.0
       else
        approx=lintpo(xx(j),xx(j+1),yy(j),yy(j+1),x)
       endif	
       return
       end
*
*****c***1********2*******3********4********5********6********7********8     
       real function lintpo(x1,x2,y1,y2,u)
*****c***1********2*******3********4********5********6********7********8     
*
* linear interpolation at abscissa u gives ordinate lintpo=A*y1+B*y2
* with A=(x2-u)/(x2-x1) and B=1-A 
*
* M. Winterer tested 2/23/94
*
* usage: declare lintpo as real !
*
       implicit none
       real x1,x2,y1,y2,u,a,b
*
       a=(x2-u)/(x2-x1)
       b=1-a
       lintpo=a*y1+b*y2
       return
       end
*
***********************************************************************
*
* bisection routine from numerical recipes p.90
* given an array xx of n vectors locate provides index j
* such that x is between xx(j) and xx(j+1)
*
      subroutine locate(xx,np,n,x,j)
      dimension xx(np)
      jl=0
      ju=n+1
10    if(ju-jl.gt.1)then
        jm=(ju+jl)/2
        if((xx(n).gt.xx(1)).eqv.(x.gt.xx(jm)))then
          jl=jm
        else
          ju=jm
        endif
      go to 10
      endif
      j=jl
      return
      end
*
*****c***1********2*******3********4********5********6********7********8 
      function kaibes(b,e,w,x)
*****c***1********2*******3********4********5********6********7********8
*
* program to calculate a window function for fourier transformations
* using a Kaiser Bessel function
* w is the wheight of the Bessel function and should be inside [1,10]
*
* see e.g. E.P.Cunnungham, Digital Filtering - An Introduction
*          Houghton Mifflin Company, Boston 1992, p.283
*
* declarations
*
      implicit none
      real b,e,w,x,av,di,kaibes,bessi0
*
      av=(b+e)*0.5
      di=(b-e)*0.5
      if((x.gt.b).and.(x.lt.e))then
       if(abs(w).lt.1.e-10)then
        kaibes=1.0
       else
        kaibes=bessi0(w*
     1               sqrt(1.0-((x-av)/di)*((x-av)/di)))
     2        /bessi0(w)
       endif
      else
       kaibes=0.0
      endif
      end
*
*
* program to calculate a window function for fourier transformations
*****c***1********2*******3********4********5********6********7********8      
      function bessi0(x)
*****c***1********2*******3********4********5********6********7********8
*
* zero order modified Bessel function of first kind
* Numerical Recipes function
*
      real*8 y,p1,p2,p3,p4,p5,p6,p7
      real*8 q1,q2,q3,q4,q5,q6,q7,q8,q9
      data p1,p2,p3,p4,p5,p6,p7
     *    /1.0d0,3.5156229d0,3.0899424d0,1.2067492d0,
     *           0.2659732d0,0.360768d-1,0.45813d-2/
      data q1,q2,q3,q4,q5,q6,q7,q8,q9
     *    / 0.39894228d0, 0.1328592d-1, 0.225319d-2,
     *     -0.157565d-2,  0.916281d-2, -0.2057706d-1,
     *      0.2635537d-1,-0.1647633d-1, 0.392377d-2/
      if (abs(x).lt.3.75) then
        y=(x/3.75)**2
        bessi0=p1+y*(p2+y*(p3+y*(p4+y*(p5+y*(p6+y*p7)))))
      else
        ax=abs(x)
        y=3.75/ax
        bessi0=(exp(ax)/sqrt(ax))*(q1+y*(q2+y*(q3+y*(q4
     *      +y*(q5+y*(q6+y*(q7+y*(q8+y*q9))))))))
      endif
      return
      end

*
*****c***1********2*******3********4********5********6********7********8
      subroutine inffc(mdata,ndata,x,y,u,v,text,filfef)
*****c***1********2*******3********4********5********6********7********8
      implicit none
      integer mdata,ndata,i,ion,numcol,namlen,ios,mxdata
      real x(mdata),y(mdata),u(mdata),v(mdata)
      character*256 filfef
      character*31 xn,yn,un,vn,sn
      character*80 title,text(20),dummy
      character*80 answer
      character*8 form
      character*3 outmod
*
* initialize
*
      call initd(mdata,mdata,x,0.0)
      call initd(mdata,mdata,y,0.0)
      call initd(mdata,mdata,u,0.0)
      call initd(mdata,mdata,v,0.0)
*
* open
*
      ion=25
      open(ion,file=filfef,status='unknown')
*
* read header
*
      read(ion,9000,end=9997,err=9998)dummy
      read(ion,9000,end=9997,err=9998)title
      read(ion,9000,end=9997,err=9998)dummy
      print *,title
      print *,' '
*
      form='(2x,a80)'
      do 90 i=2,20
       read(ion,form,end=9997,err=9998)text(i)
90    continue
*
* read column lables and data
*
      read(ion,9000,end=9997,err=9998)dummy
      do 100 i=1,mdata
        read(ion,*,end=900)x(i),y(i),u(i),v(i)
        ndata=i
100   continue
900   continue
      print *,'number of ffc data: ',ndata
      print *,' '
*
* close and save
*
      close(ion,status='keep')

*****c***1********2*******3********4********5********6********7********8
* 
* formats
*
9000  format(2x,a80)
9001  format(1x,5(g13.6,1x))
9002  format(1x,5(a13,1x))
9003  format(a80)
      return
9996  print *,'INFFC: exit'
      return
9997  print *,'INFFC ERROR: end of file'
      return
9998  print *,'INFFC ERROR: wrong file format'
      return
9999  print *,'INFFC ERROR: open/close file error'
      return
      end

