*****c***1********2*******3********4********5********6********7********8
*
       subroutine gamt(mdat,ndat,mhis,nhis,mtyp,nta,nte,nabs,
     1  mpdf,mspec,nspec,vec,rad,amp,pha,laminv,
     2  chitrunc,deltar)
*
*****c***1********2*******3********4********5********6********7********8
*
* calculation of exafs kernel for rmc, truncation part of PDF:
* Hanning-Square window at end of gij
* curved wave approximation: amplitude, phase and mean free path are
* dependent on coordination distance
*
* source: S.J.Gurman and R.L McGreevy, J.Phys. Cond. Mat. 2 (1990), 9463
*
*****c***1********2*******3********4********5********6********7********8
*
* m. winterer 01/26/06 duisburg
*
* changes due to multisite 06/11/20mw
*
*****c***1********2*******3********4********5********6********7********8
*
* global variables
*       mdat,ndat           maximum and actual number of spectral points
*       mhis,nhis           maximum and actual number of histogram points
*       mtyp,ntyp           maximum and actual number of atom types
*       vec(mdat,ntyp)      k-vector
*       amp(mdat,ntyp)      amplitude
*       pha(mdat,ntyp)      phase
*       laminv(mdat,ntyp)   inverse of mean free path
*       chitrunc(mdat,mtyp,mspec)
*                           exafs signal of truncation of PDF's
*       rho                 number density
*       deltar              interval of histogram radius 
*       pi                  3.14...
* local variables
*       j,k,l               loop indices
*       chiij               storage for spectral summation
*
* files used:               none
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations 
*
       implicit none
* global variables
       integer mdat,ndat,mhis,nhis,mtyp,mpdf,mspec,nspec
       integer nabs,nta,nte
       real vec(mdat,mspec),rad(mhis)
       real amp(mdat,mhis,mtyp,mtyp),pha(mdat,mhis,mtyp,mtyp)
       real laminv(mdat,mhis,mtyp,mtyp)
       real chitrunc(mdat,mtyp,mtyp)
       real pi,deltar
       common /const/ pi
* local variables
       integer j,k
       real chij
       integer mmax,m
       real pih,rmax,rext,hcos
*
*****c***1********2*******3********4********5********6********7********8
*
       mmax=int(2.0/deltar)
       rmax=rad(nhis)
       pih=0.5*pi 
* loop over k-vector
       do 120 k=1,ndat
* sum over all types of neighbours
         do 110 j=nta,nte
	  chij=0.0
          rext=0.0
          do 105 m=1,mmax
           rext=rmax+float(m)*deltar           
           hcos=cos(pih*(rext-(rmax+deltar))*0.5)
c           print *,rext,hcos*hcos
           chij=chij+hcos*hcos*amp(k,nhis,j,nabs)
     1           *exp(-2.0*rext*laminv(k,nhis,j,nabs))
     2           *sin(2.0*vec(k,nspec)*rext+pha(k,nhis,j,nabs))
     3           *deltar
105       continue
          chitrunc(k,j,nabs)=chij
110       continue
120    continue
       return
       end

