*****c***1********2*******3********4********5********6********7********8
      subroutine ff2chi(iol,mspec,nspec,mtyp,ntyp,mhis,nhis,listsit,
     1               listabs,mdat,ndat,s02,sig2,vec,rad,amp,pha,laminv)
*****c***1********2*******3********4********5********6********7********8
*
* approximate curved wave (radial dependence of feff)
*
*****c***1********2*******3********4********5********6********7********8
*
* include pijump correction 12/4/2002 mw
*
* change due to multisite 06/09/20mw
*  mspec means maximum number of possible atom types and
*  nspec actual number of absorbers
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       integer iol,iof,n,nspec,mspec,k,ndat(mspec),mdat,mdata
       integer ia
* mdata=mdat=2048,mdat defined in main program: rmcxas
       parameter(mdata=2048)
       integer m,ntyp,mtyp,l,l1,l2,ityp,ispec,listsit(mtyp)
       integer listabs(mtyp),itc
       integer anab1,anab2,ansc1,ansc2,mhis,nhis,iabs
       real s021,s02(mspec),sig21,sig2(mspec)
       real vecth(mdata),vec(mdat,mspec)
       real r1,r2,reff
       real rad(mhis),amp2(mdata),pha2(mdata),lami2(mdata)
       real amp1(mdata),pha1(mdata),lami1(mdata)
       real amp(mdat,mhis,mtyp,mtyp)
       real pha(mdat,mhis,mtyp,mtyp)
       real laminv(mdat,mhis,mtyp,mtyp)
       real dr,fr1,fr2
       real*8 p1d,p2d
       character*256 filfef,filthe
*****c***1********2*******3********4********5********6********7********8
c        print *,'in ff2chi ',nhis
        if(mdat.gt.mdata)then
         write(iol,*)'FF2CHI ERROR: ',mdat,' > ',mdata
         stop
        endif
c       print *,mspec,nspec,mtyp,ntyp,mhis,nhis,mdat,ndat(1),ndat(2)
*
c        do m=1,mabs
c         listabs(m)=0
c        enddo
c        m=0
c        do n=1,ntyp
c         if(listsit(n).ne.0)then
c          m=m+1
c          listabs(m)=n
c         endif
c        enddo
*
       iof=25
       do ia=1,nspec
        iabs=ia
        n=listabs(ia)
        ispec=listsit(n)
c        print *,ia,n,ispec,nspec
* loop over absorber atoms
        s021=s02(ispec)
        sig21=sig2(ispec)
c        print *,n,ispec,s021,sig21
        do k=1,ndat(ispec)
         vecth(k)=vec(k,ispec)
        enddo
* open file with names of feffnnn.dat files ordered in sequence of
* effective radius and scatterer type
c        filfef='rmc.the.'//char(48+ispec)
        filfef='rmc.the.'//char(48+iabs)
c        filfef='rmc.the.'//char(48+n)
c        print *,filfef
        open(iof,file=filfef,status='unknown')
* loop over scatterer atoms
         r1=0.0
         l1=1
c         l1=0
         itc=1 
         m=1
* loop over radial dependence of feff (curved wave)
50       continue
          read(iof,'(i2,1x,a)',end=100)ityp,filthe
c          print *,itc,m,ityp,filthe
          if(ityp.gt.itc)then
c          print *,itc,m,ityp,n,filthe
           if(l1.lt.nhis)then
            do l=l1,nhis
c             print *,m,rad(l)
             do k=1,ndat(ispec)
              amp(k,l,m,n)=amp1(k)
              pha(k,l,m,n)=pha1(k)
              laminv(k,l,m,n)=lami1(k)
c              print *,amp(k,l,m,n),pha(k,l,m,n),laminv(k,l,m,n)
             enddo
            enddo
           endif
           itc=ityp
           m=ityp
           r1=0.0
           l1=1
c           l1=0
          endif
*
          call intheo(mdat,ndat(ispec),ispec,n,m,s021,sig21,
     1                vecth,amp2,pha2,lami2,anab2,ansc2,reff,filthe,iol)
*
c          print *,m,ityp,filthe,reff
          r2=reff
          call locate(rad,mhis,nhis,r2,l2)
          if(r1.eq.0.0)then
           l1=1
           r1=rad(l1)
           do l=l1,l2
c           print *,m,rad(l)
            do k=1,ndat(ispec)
             amp(k,l,m,n)=amp2(k)
             pha(k,l,m,n)=pha2(k)
             laminv(k,l,m,n)=lami2(k)
c              print *,amp(k,l,m,n),pha(k,l,m,n),laminv(k,l,m,n)
c              print *,amp2(k),pha2(k),lami2(k)
            enddo
           enddo
           do k=1,ndat(ispec)
            amp1(k)=amp2(k)
            pha1(k)=pha2(k)
            lami1(k)=lami2(k)
           enddo
           l1=l2+1
           r1=r2
           anab1=anab2
           ansc1=ansc2
          else
           if(anab1.ne.anab2)then
            write(*,*)'ERROR inconsistent absorber atoms in: ',filfef
            stop
           endif
           if(ansc1.ne.ansc2)then
            write(*,*)'ERROR inconsistent scatterer atoms in: ',filfef
            stop
           endif
           do l=l1,l2
* linear interpolation
            dr=r1-r2
            fr1=(1./dr)*rad(l)-r2/dr
            fr2=1.0-fr1
            do k=1,ndat(ispec)
* include pijump correction 12/4/2002 mw
            p2d=dble(pha2(k))
            p1d=dble(pha1(k))
            call pijump (p2d, p1d,iol)
c            if(real(p2d).ne.pha2(k))then
c             print *,k,pha1(k),pha2(k),p2d
c            endif
            pha2(k)=real(p2d)
*
             amp(k,l,m,n)=fr1*amp1(k)+fr2*amp2(k)
             pha(k,l,m,n)=fr1*pha1(k)+fr2*pha2(k)
             laminv(k,l,m,n)=fr1*lami1(k)+fr2*lami2(k)
            enddo
           enddo
           do k=1,ndat(ispec)
            amp1(k)=amp2(k)
            pha1(k)=pha2(k)
            lami1(k)=lami2(k)
           enddo
           l1=l2+1
           r1=r2
           anab1=anab2
           ansc1=ansc2
         endif
        goto 50
100     continue
        if(l1.lt.nhis)then
         do l=l1,nhis
c          print *,m,rad(l)
          do k=1,ndat(ispec)
           amp(k,l,m,n)=amp1(k)
           pha(k,l,m,n)=pha1(k)
           laminv(k,l,m,n)=lami1(k)
          enddo
         enddo
        endif
        close(iof,status='keep')
       enddo
       if(n.lt.nspec)then
        write(*,*)'ERROR incomplete file ',filfef
        stop
       endif
c       print *,'input theory'
       write(iol,*)' '
c       open(30,file='test.dat',status='unknown')
c        do l=1,nhis
c         write(30,*)amp(100,l,1,1),amp(100,l,2,1)
c        enddo
c       close(30,status='keep')
       return
       end
*
*****c***1********2*******3********4********5********6********7********8
*
* functions and subroutines for calculation of the
*
*  incomplete gamma function: gammq,gser,gcf,gammln
*
* from: numerical recipes
* on:   apple macintosh iivx, system 7
* with: absoft macfortran ii v3.1
*
      function erf(x)
      if(x.lt.0.)then
        erf=-gammp(.5,x*x)
      else
        erf=gammp(.5,x*x)
      endif
      return
      end
*
*****c***1********2*******3********4********5********6********7********8
*
      function gammp(a,x)
      if(x.lt.0..or.a.le.0.)print *,'GAMMP ERROR'
      if(x.lt.a+1.)then
        call gser(gammp,a,x,gln)
      else
        call gcf(gammcf,a,x,gln)
        gammp=1.-gammcf
      endif
      return
      end
*
*****c***1********2*******3********4********5********6********7********8
*
      subroutine gser(gamser,a,x,gln)
      parameter (itmax=100,eps=3.e-7)
c      print *,'inside gser'
      gln=gammln(a)
      if(x.le.0.)then
        if(x.lt.0.)print *,'GSER ERROR: x < 0'
        gamser=0.
        return
      endif
      ap=a
      sum=1./a
      del=sum
      do 11 n=1,itmax
        ap=ap+1.
        del=del*x/ap
        sum=sum+del
        if(abs(del).lt.abs(sum)*eps)go to 1
11    continue
      print *, 'GSER ERROR: a too large, itmax too small'
1     gamser=sum*exp(-x+a*log(x)-gln)
      return
      end
*
*****c***1********2*******3********4********5********6********7********8
*
      function gammln(xx)
      real*8 cof(6),stp,half,one,fpf,x,tmp,ser
      data cof,stp/76.18009173d0,-86.50532033d0,24.01409822d0,
     *    -1.231739516d0,.120858003d-2,-.536382d-5,2.50662827465d0/
      data half,one,fpf/0.5d0,1.0d0,5.5d0/
c      print *,'inside gammln'
      x=xx-one
      tmp=x+fpf
      tmp=(x+half)*log(tmp)-tmp
      ser=one
      do 11 j=1,6
        x=x+one
        ser=ser+cof(j)/x
11    continue
      gammln=tmp+log(stp*ser)
      return
      end
*
*****c***1********2*******3********4********5********6********7********8
*
      function gammq(a,x)
c      print *,'inside gammq'
      if(x.lt.0..or.a.le.0.)print *,'GAMMQ ERROR'
      if(x.lt.a+1.)then
        call gser(gamser,a,x,gln)
        gammq=1.-gamser
      else
        call gcf(gammq,a,x,gln)
      endif
      return
      end
*
*****c***1********2*******3********4********5********6********7********8
*
      subroutine gcf(gammcf,a,x,gln)
      parameter (itmax=100,eps=3.e-7)
c      print *,'inside gcf'
      gln=gammln(a)
      gold=0.
      a0=1.
      a1=x
      b0=0.
      b1=1.
      fac=1.
      do 11 n=1,itmax
        an=float(n)
        ana=an-a
        a0=(a1+a0*ana)*fac
        b0=(b1+b0*ana)*fac
        anf=an*fac
        a1=x*a0+anf*a1
        b1=x*b0+anf*b1
        if(a1.ne.0.)then
          fac=1./a1
          g=b1*fac
          if(abs((g-gold)/g).lt.eps)go to 1
          gold=g
        endif
11    continue
      print *, 'GCF ERROR: a too large, itmax too small'
1     gammcf=exp(-x+a*alog(x)-gln)*g
      return
      end
*
*****c***1********2*******3********4********5********6********7********8
*
      subroutine intheo(mdat,ndat,ispec,ia,is,s02,sig,x,amp,phas,
     1                  invlam,anab,ansc,reff,filein,iol)
*****c***1********2*******3********4********5********6********7********8
*
* input of exafs reference from feff####.dat files and calculations
* of amplitude, phase and mean free path for single path
*
*      source: feff code 5.01
*
*****c***1********2*******3********4********5********6********7********8
*
* m. winterer 1/26/97 darmstadt
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations 
*
       implicit none
* global variables
      integer mdat,ndat,iol,anab,ansc,ia,is,ispec
      real x(mdat),amp(mdat),phas(mdat),invlam(mdat),sig
* local variables
      integer ion,ios,i,nl,namlen
      character*80 dummy
      character*256 filein
* declarations for chi calculation
      integer nleg,iextr,npts,nfinex,nex
      parameter (nex = 100)
*         ndat < nfinex
      parameter (nfinex = 2048)
c      real s02,ryd,eps4
      real s02
      real*8 ryd,eps4
c      real*8 deg,reff,rs,edge,sig2
      real*4 deg,reff,rs,edge,sig2
      real*8 xk(nex),cdelta(nex),afeff(nex),phfeff(nex)
      real*8 redfac(nex),xlam(nex),rep(nex)
      real*8 achi(nex),achix(nex)
      real*8 phdw,emfp
      real*8 xk0,xla0
c      real*8 phase,phase0,bohr,preal,pimag,xlamb
      real*8 phase,phase0,bohr,preal,pimag,xlamb,achi0,achix0
      complex*16 ck(nex),dw,p2
c      complex*16 ccpath(nfinex),coni,achi0,achix0,ccc
      complex*16 ccpath(nfinex),coni,ccc
      parameter (bohr = 0.529 177 249,ryd  = 13.605 698)
      parameter(eps4=1.e-4)
      parameter(coni=(0,1))
*
* initialize
*
      call initd(mdat,mdat,amp,0.0)
      call initd(mdat,mdat,phas,0.0)
      call initd(mdat,mdat,invlam,0.0)
*
* open file
*
      ion=15
c      print *,'intheo: open file 1: _',filein(2:len(trim(filein))),'_'
       open(unit=ion,file=filein(2:len(trim(filein))),
     1                    iostat=ios,status='old',err=9997)
c      write(iol,*)'intheo: open file: ',filein
c      print *,'intheo: open file 2: ',filein
*
* read header
*
      read(ion,9000,err=9998)dummy
20    continue
       read(ion,9000,err=9998) dummy
       if(dummy(2:4).ne.'---')goto 20
       read(ion,*)nleg,deg,reff,rs,edge
       read(ion,9000,err=9998) dummy
       read(ion,'(35x,i3)',err=9998)anab
       read(ion,'(35x,i3)',err=9998)ansc
c       write(iol,*)'intheo: nleg,deg,reff,rs,edge: ',
c     1              nleg,real(deg),real(reff),real(rs),real(edge)
       do 800 nl=256,1,-1
        if(filein(nl:nl).ne.' ')then
         namlen=nl
         goto 801
        endif
800    continue
801    continue
       namlen=abs(namlen)+1

       write(iol,8000)ispec,ia,is,anab,ansc,nleg,int(real(deg)),
     1                real(reff),real(rs),real(edge),' ',
     2                filein(namlen-12:namlen)
8000   format(1x,i4,1x,i4,1x,i4,1x,i4,1x,i4,1x,i4,1x,i4,1x,
     1        g10.3,1x,g10.3,1x,g10.3,1x,a1,a12)

c       print *,ispec,ia,is,anab,ansc,nleg,real(deg),real(reff),real(rs),
c     1         real(edge),' ',filein
c       print *,'intheo: nleg,deg,reff,rs,edge: ',
c     1              nleg,real(deg),real(reff),real(rs),real(edge)
c      write(iol,*)'intheo: atom number of absorber and scatter: ',
c     1             anab,ansc
c      print *,'intheo: atom number of absorber and scatter: ',
c     1             anab,ansc
30    continue
       read(ion,9000,err=9998) dummy
      if(dummy(5:9).ne.'k   r')goto 30
      i=1
50    continue
       read(ion,*,err=9998,end=60)xk(i),cdelta(i),afeff(i),phfeff(i),
     1                            redfac(i),xlam(i),rep(i)
c       print *,xk(i),cdelta(i),afeff(i),phfeff(i),
c     1                            redfac(i),xlam(i),rep(i)
       npts=i
       i=i+1
      goto 50
60    continue
      close(unit=ion,status='keep')
c      print *,'input closed'
*
* set parameters
*
      deg=1.0
      sig2=0.005d0
*
* calculate chi
*
* 1. make chi:
      do 90  i = 1, npts
       preal = rep(i) * bohr
       xlamb = xlam(i) / bohr
       pimag = 1 / xlamb
       p2 = (preal + coni*pimag)**2
       ck(i) = sqrt (p2)
       xlam(i) = 1 / aimag(ck(i))
       rep(i) = dble(ck(i))
       ck(i) = ck(i) / bohr
       xlam(i) = xlam(i) * bohr
       rep(i) = rep(i) / bohr
c       print *,i,ck(i),xk(i),xlam(i)
90    continue
*
*    extrapolate chi when k=0, otherwise calculate it
*    achi has no 2kr term
*
c       open(20,file='check.dat',status='unknown')
      iextr = 0
      do 100  i = 1, npts
       dw = exp(-2.*sig2*ck(i)**2)
       phdw = atan2 (aimag(dw), dble(dw))
        emfp = exp(-2*reff/xlam(i)) 
       if (abs(xk(i)) .lt. 0.01)  then
        iextr = i
       else
        achi(i) = afeff(i) * deg * abs(dw) *
     1            emfp * redfac(i) * dble(s02) /
     2            (abs(xk(i))*reff**2)
       endif
       achix(i) = cdelta(i) + phfeff(i) + phdw
c       print *,i,achi(i)
c         print *,abs(xk(i)),achi(i),afeff(i),deg,abs(dw),emfp,
c     1             redfac(i),real(dble(s02)),(abs(xk(i))*reff**2)
c        write(20,*)abs(xk(i)),achi(i),afeff(i),deg,abs(dw),emfp,
c     1             redfac(i),real(dble(s02)),(abs(xk(i))*reff**2)
100   continue
       if (iextr .gt. 0)  then
        achi(iextr) = 2*achi(iextr+1) - achi(iextr+2)
       endif
* make sure no 2pi jumps in phase
      do 110  i = 2, npts
       call pijump (achix(i), achix(i-1), iol)
110   continue
c       close(20,status='keep')
*
* 2. finer grid:
*
      do 200  i = 1, ndat
       xk0 = dble(x(i))
       if (xk0 .gt. xk(npts)+eps4)  then
        ndat = i-1
        goto 210
       endif
       call terp (xk, achi,  npts, xk0, achi0, iol)
       call terp (xk, achix, npts, xk0, achix0, iol)
       ccpath(i) = achi0 * exp (coni * (2*xk0*reff + achix0))
c       print *,i,xk(i),xk0,ccpath(i)
200   continue
210   continue
*
* 3. mean free path on finer grid (experimental grid):
*
      do 290 i = 1, ndat
       xk0 = dble(x(i))
       call terp (xk, xlam, npts, xk0, xla0, iol)
       invlam(i)=real(1.d0/xla0)
290   continue
*
* 4. calculate magnitude and phase:
*
      do 300  i = 1, ndat
       xk0 = dble(x(i))
       ccc = ccpath(i)
       phase=0
       if (abs(ccc) .gt. 0)  phase=atan2(aimag(ccc), dble(ccc))
       if (i .gt. 1)  call pijump (phase, phase0,iol)
       phase0 = phase
       amp(i)=real(abs(ccc))
       phas(i)=real(phase)
c       print *,xk0,ccc,amp(i),phas(i)
300   continue
c       open(20,file='test.dat',status='unknown')
c       do i=1,ndat
c        xk0 = dble(x(i))
c        write(20,*)x(i),xk0,amp(i),phas(i),invlam(i)
c       enddo
c       close(20,status='keep')
*
* 5. calculate reduced magnitude and phase:
*
       if(sig.gt.0.0)then
        write(iol,*)'gaussian randomization of feff with DW= ',
     1               sig
       endif
      do 400  i = 1, ndat
       if(sig.gt.0.0)then
        amp(i)=amp(i)*x(i)*real(reff)*real(reff)
     1         /(exp(-2.0*(real(sig2)-sig)*x(i)*x(i))
     2         *exp(-2.0*invlam(i)*real(reff)))
       else
        amp(i)=amp(i)*x(i)*real(reff)*real(reff)
     1         /(exp(-2.0*real(sig2)*x(i)*x(i))
     2         *exp(-2.0*invlam(i)*real(reff)))
       endif
       phas(i)=phas(i)-2.0*x(i)*real(reff)
400   continue
*
*****c***1********2*******3********4********5********6********7********8
* 
* formats
*
9000  format(a)
9001  format(a39,g13.6e2,a6)
      return
9997  write(iol,*)'ERROR: no theoretical data found '
      stop
9998  write(iol,*)'ERROR while reading theoretical data file'
      stop
      end
*
*****c***1********2*******3********4********5********6********7********8
      subroutine terp (x, y, n, x0, y0,iol)
*****c***1********2*******3********4********5********6********7********8
*
*     Linear interpolation and extrapolation.
*     Input x and y arrays, returns y value y0 at requested x value x0.
*     Dies on error.
*
      implicit double precision (a-h,o-z)
      dimension x(n), y(n)
*
*     Find out between which x points x0 lies
      i = locat (x0, n, x)
*     if i < 1, set i=1, if i > n-1, set i=n-1
      i = max (i, 1)
      i = min (i, n-1)
      if (x(i+1) - x(i) .eq. 0)  then
       write(iol,*)'TERP: error x(i)=x(i+1)'
       stop
      endif
      y0 = y(i) +  (x0 - x(i)) * (y(i+1) - y(i)) / (x(i+1) - x(i))
      return
      end
      
      
*****c***1********2*******3********4********5********6********7********8      
      function locat (x, n, xx)
*****c***1********2*******3********4********5********6********7********8
*
*     Binary search for index of grid point immediately below x.
*     Array xx required to be monotonic increasing.
*     Returns
*     0            x <  xx(1)
*     1            x =  xx(1)
*     i            x =  xx(i)
*     n            x >= xx(n)
*
      double precision x, xx(n)
      integer  u, m, n
*
      locat = 0
      u = n+1
10    if (u-locat .gt. 1)  then
        m = (u + locat) / 2
        if (x .lt. xx(m))  then
          u = m
        else
         locat = m
        endif
        goto 10
      endif
      return
      end
*
*****c***1********2*******3********4********5********6********7********8
      subroutine pijump (ph, old,iol)
*****c***1********2*******3********4********5********6********7********8
*
*     removes jumps of 2*pi in phases
*     ph = current value of phase (may be modified on output, but
*          only by multiples of 2*pi)
*     old = previous value of phase
*
      implicit double precision (a-h, o-z)
      parameter (pi = 3.14159 26535 89793 23846 26433)
      parameter (twopi = 2 * pi)
      dimension xph(3)

      xph(1) = ph - old
      jump =  (abs(xph(1))+ pi) / twopi
      xph(2) = xph(1) - jump*twopi
      xph(3) = xph(1) + jump*twopi
      xphmin = min (abs(xph(1)), abs(xph(2)), abs(xph(3)))
      isave = 0
      do 10  i = 1, 3
       if (abs (xphmin - abs(xph(i))) .le. 0.01)  isave = i
10    continue
      if (isave .eq. 0)  then
       write(iol,*)'PIJUMP error'
       return
      endif
      ph = old + xph(isave)
      return
      end

***********************************************************************
*
* bisection routine from numerical recipes p.90
* given an array xx of n vectors locate provides index j
* such that x is between xx(j) and xx(j+1)
*
      subroutine locate(xx,np,n,x,j)
      dimension xx(np)
      jl=0
      ju=n+1
10    if(ju-jl.gt.1)then
        jm=(ju+jl)/2
        if((xx(n).gt.xx(1)).eqv.(x.gt.xx(jm)))then
          jl=jm
        else
          ju=jm
        endif
      go to 10
      endif
      j=jl
      return
      end
