*****c***1********2*******3********4********5********6********7********8
*
       subroutine constr(mhis,mpdf,ncst,lstcst,incst1,incst2,vcst,
     1                   con,cncst,sigcst)
*
*****c***1********2*******3********4********5********6********7********8
*
* calculate coordination number constraints
*
*****c***1********2*******3********4********5********6********7********8
*
* m. winterer 5/13/98 darmstadt
* fixed bug in indexing incst1 and incst2, etc. m.w. 12/15/98
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations 
*
       implicit none
       integer i,l
       integer mhis,mpdf,ncst,incst1(mpdf),incst2(mpdf),lstcst(mpdf)
       real vcst,cnrmc,con(mhis,mpdf),cncst(mpdf),sigcst(mpdf)
*****c***1********2*******3********4********5********6********7********8
*
      vcst=0.0
      do 100 i=1,ncst
       l=lstcst(i)
       cnrmc=con(incst2(i),l)-con(incst1(i),l)
c       print *,l,incst2(i),incst1(i),con(incst2(i),l),con(incst1(i),l)
c       print *,cnrmc,cncst(i),sigcst(i)
c       vcst=vcst+((cncst(l)-cnrmc)/sigcst(l)**2)
c       vcst=vcst+((cncst(l)-cnrmc)/sigcst(l))**2
       vcst=vcst+((cncst(i)-cnrmc)/sigcst(i))**2
100   continue
c      print*,vcst
      return
      end

*****c***1********2*******3********4********5********6********7********8
*
       subroutine icnst(mhis,nhis,mpdf,ncst,rad,lstcst,incst1,incst2,
     1                  cncst,sigcst,filcon,iol)
*
*****c***1********2*******3********4********5********6********7********8
*
* input coordination number constraints: nhis,r1,r2,CNrequired,sigma
*
*****c***1********2*******3********4********5********6********7********8
*
* m. winterer 5/13/98 darmstadt
* remove bug: indexing of incst1 and icnst2 12/15/98
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations 
*
       implicit none
       integer i,ios,j,mpdf,mhis,nhis,ncst,l,iol
       integer lstcst(mpdf),incst1(mpdf),incst2(mpdf)
       real rad(mhis),r1cst,r2cst,cncst(mpdf),sigcst(mpdf)
       character*31 filcon
*****c***1********2*******3********4********5********6********7********8
*
       write(iol,*)'input coordination number constraints '
       write(iol,*)' '
       i=0
       open(15,file=filcon,status='unknown',err=9997,iostat=ios)
100    continue
        i=i+1
        read(15,*,err=9998,end=200)
     1                            j,r1cst,r2cst,cncst(i),sigcst(i)
* number of atom pair (pdf) (see lispdf)
        lstcst(i)=j
* locate indices of distances in pdf between CN is looked for
* for faster calculation
        call locate(rad,mhis,nhis,r1cst,l)
        if(l.le.0)l=1
        incst1(i)=l
        call locate(rad,mhis,nhis,r2cst,l)
        if(l.le.0)l=1
        incst2(i)=l
       goto 100
200    continue
       ncst=i-1
       close(15,status='keep')
       write(iol,'(a)')'Coordination number constraints applied: '
       write(iol,901)'pdf#',' R1/A ',' R2/A ',' CN   ','weight'
       print *,'Coordination number constraints applied: '
       print *,'pdf#',' R1/A ',' R2/A ',' CN   ','weight'
       do 300 i=1,ncst
        l=lstcst(i)
       write(iol,900)l,rad(incst1(i)),rad(incst2(i)),cncst(i),sigcst(i)
       print *,l,rad(incst1(i)),rad(incst2(i)),cncst(i),sigcst(i)
300    continue
       write(iol,*)' '
       print *,' '
       return
*
*****c***1********2*******3********4********5********6********7********8
*
900   format(1x,i3,4(1x,g13.6))
901   format(1x,a4,1x,a6,8x,a6,8x,a6,8x,a6)
9997  write(iol,*)'incst: open file error',ios
      return
9998  write(iol,*)'incst: input error'
      return
      end
***********************************************************************
*
* bisection routine from numerical recipes p.90
* given an array xx of n vectors locate provides index j
* such that x is between xx(j) and xx(j+1)
*
      subroutine locate(xx,np,n,x,j)
      dimension xx(np)
      jl=0
      ju=n+1
10    if(ju-jl.gt.1)then
        jm=(ju+jl)/2
        if((xx(n).gt.xx(1)).eqv.(x.gt.xx(jm)))then
          jl=jm
        else
          ju=jm
        endif
      go to 10
      endif
      j=jl
      return
      end

