*****c***1********2*******3********4********5********6********7********8
*
       program pdf
*
*****c***1********2*******3********4********5********6********7********8
*
* program to calculate pair distribution functions from coordinates
* in abitratry boxes and selected volumes
*
* m. winterer darmstadt 12/10/98
*
* ! changes in subroutines adapted from other programs !
*
*****c***1********2*******3********4********5********6********7********8
      implicit none
      integer matom,natom,mtyp,ntyp,i,nsel,l
      integer mpdf,npdf,mhis,nhis
      parameter(matom=1000000,mtyp=4,mhis=2048)
      parameter(mpdf=mtyp*(mtyp+1)/2)
      integer typ(matom)
      real xcr(matom),ycr(matom),zcr(matom),rms(matom)
      real xco(matom),yco(matom),zco(matom)
      integer sel(matom)
      integer lisp(mtyp,mtyp),list(2,mtyp*(mtyp+1)/2)
      real close(mpdf),conc(mtyp),aconc(mtyp),lconc(mtyp)
      real rad(mhis),gij(mhis,mpdf),con(mhis,mpdf)
      integer hn,kn,ln
      real alatt,blatt,clatt,alphad,betad,gammad
      real cut,rmax,deltar,rho,rhoavg,rholoc
      real xminb,xmaxb,yminb,ymaxb,zminb,zmaxb
      real sx,sy,sz,sr,px,py,pz,pri,pro
      real*8 volume,hmat(3,3),hinv(3,3),gmet(3,3)
      real pi
      character*1 selct,dmode
      character*256 filcoo
      logical sonly,pbc
*
      common /const/ pi
*
      pi=4.0*real(datan(1.0d0))
      cut=0.0
      do i=1,mtyp
       close(i)=0.0
      enddo
*
* input initial coordinates       
* 
         print *,'calculate pdfs after rmc analysis'        
         print *,' '
         print *,' m. winterer Duisburg 04/30/19'
         print *,' '
         call inpar(filcoo,ntyp,hn,kn,ln,alatt,blatt,clatt,
     1                 alphad,betad,gammad,cut,rmax,deltar,rho,dmode,
     2                 xminb,xmaxb,yminb,ymaxb,zminb,zmaxb,
     3                 sx,sy,sz,sr,px,py,pz,pri,pro,selct,sonly,pbc)

         print *,'input parameters'

         if(cut.lt.2.*deltar)cut=2.*deltar
*
* make transformation and metric matrices
*
       call makehm(alatt,blatt,clatt,hn,kn,ln,
     1                   alphad,betad,gammad,volume,hmat)
       call makehi(alatt,blatt,clatt,hn,kn,ln,
     1                   alphad,betad,gammad,volume,hinv)
       call makegm(hmat,gmet)
       print *,'created transformation matrices'
       print *,' '
       print *,'simulation box volume: ',volume
       print *,' '
*
* input initial coordinates
*
        call incoo(matom,natom,typ,xcr,ycr,zcr,rms,filcoo)
        nsel=natom
*
* calculate density
*
        print *,'average density supplied:   ',rho
        rhoavg=rho
        if(rho.eq.0)then
         rhoavg=float(natom)/volume
        endif
        if(rhoavg.eq.0.0)rhoavg=1.0
        print *,'average density calculated: ',float(natom)/volume
        print *,' '
*
* convert cartesian to crystallographic coordinates
*
        do 100 i=1,natom
         call tranoc(xcr(i),ycr(i),zcr(i),
     1               hinv,xco(i),yco(i),zco(i))
100     continue
        print *,'transformed coordinates'
        print *,' '
*
* select atoms:  use original coordinates for selection to avoid
* transformation of sphere to canonical coordinates
*
         call select(matom,natom,nsel,typ,xcr,ycr,zcr,rms,sel,
     1                  xminb,xmaxb,yminb,ymaxb,zminb,zmaxb,
     2                  sx,sy,sz,sr,px,py,pz,pri,pro,selct)
*
       rholoc=rhoavg
       rho=rhoavg
       if(selct.eq.'s')then
        rholoc=float(nsel)/(4.*pi*sr*sr*sr/3.)
        print *,'selected volume: ',4.*pi*sr*sr*sr/3.
        print *,' ' 
       elseif(selct.eq.'p')then
        rholoc=float(nsel)/
     1         (((pro*pro*pro)-(pri*pri*pri))*4.*pi/3.)
        print *,'selected volume: ',
     1         ((pro*pro*pro)-(pri*pri*pri))*4.*pi/3.
        print *,' ' 
       elseif(selct.eq.'b')then
        rholoc=float(nsel)/
     1          abs((xmaxb-xminb)*(ymaxb-yminb)*(zmaxb-zminb))
        print *,'selected volume: ',
     1          abs((xmaxb-xminb)*(ymaxb-yminb)*(zmaxb-zminb)) 
        print *,' ' 
       else
        print *,'selected volume: ',volume
       endif
       if(selct.ne.'a')then
        print *,'local density: ',rholoc
        print *,' '
        if(dmode.eq.'l')then
         rho=rholoc
         print *,'local density used: ',rho
        print *,' '
        else
         rho=rhoavg
         print *,'average density used: ',rho
        print *,' '
        endif
       else
         rho=rhoavg
         print *,'average density used: ',rho
        print *,' '
       endif
*
* make matrix of labeling numbers of pdfs: lisp
*
       call lispdf(mtyp,ntyp,lisp,list)
*
* calculate initial pdf
*
       npdf=ntyp*(ntyp+1)/2
       print *,' '
       print *,'number of pair distribution functions: ',npdf
*
       call inipdf(matom,natom,mtyp,ntyp,mhis,nhis,
     1                  mpdf,npdf,typ,deltar,rmax,cut,close,
     2                  aconc,rad)
       print *,'pdf initialized'
       print*,' '
       do 49 l=1,ntyp
        conc(l)=aconc(l)
49     continue
*
* calculate local concentration
*
      if((selct.ne.'a').and.(dmode.eq.'l'))then
       call initd(mtyp,mtyp,lconc,0.0)
       do 50 i=1,natom
        if(sel(i).eq.1)then
         l=typ(i)
         lconc(l)=lconc(l)+1.0
        endif
50     continue
       do 51 l=1,ntyp
        lconc(l)=lconc(l)/float(nsel)
51     continue
       print *,' '
       print *,'type, average, local concentration'
       do 52 l=1,ntyp
        conc(l)=lconc(l)
        print *,l,aconc(l),lconc(l)
52     continue
       print *,'local concentration used '
       print *,' '
      else
       print *,' '
       print *,'type, average concentration'
       do 53 l=1,ntyp
        conc(l)=aconc(l)
        print *,l,aconc(l)
53     continue
       print *,'average concentration used '
       print *,' '
      endif
*
       call pdfini(mhis,nhis,mtyp,ntyp,mpdf,npdf,nsel,
     1                  matom,natom,gmet,xco,yco,zco,typ,conc,lisp,list,
     2                  cut,gij,deltar,rmax,rho,pbc,sonly,sel)
       print *,'pdf calculated'
       print*,' '
*
* integrate pdf
*
       call pdfcon(mhis,nhis,mtyp,ntyp,mpdf,npdf,rad,gij,con,
     1                   deltar,rmax,rho,conc,list)
       print *,'pdf integrated'
       print*,' '
*
* make and output histogram
*
       call outpdf(mhis,nhis,mtyp,ntyp,mpdf,npdf,rad,gij,con,rho)
       call histo(mhis,nhis,mpdf,npdf,rad,gij,con,deltar)
       print *,'pdf and histograms output'
       print*,' '
*
       end

*****c***1********2*******3********4********5********6********7********8
*
       subroutine incoo(matom,natom,typ,xco,yco,zco,rms,filcoo)
*
*****c***1********2*******3********4********5********6********7********8
*
* input atom coordinates 
*
*****c***1********2*******3********4********5********6********7********8
*
* m. winterer 1/31/97 darmstadt
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations 
*
       implicit none
* global variables
       integer matom,natom
       integer typ(matom)
       real xco(matom),yco(matom),zco(matom),rms(matom)
       character*256 filcoo
* local variables
       integer ios,i
*
*****c***1********2*******3********4********5********6********7********8
*
c       print *,'input atom coordinates from: ',filcoo
       i=0
       open(15,file=filcoo,status='unknown',err=9997,iostat=ios)
100    continue
        i=i+1
        read(15,9000,err=9998,end=200)i,typ(i),
     1                                xco(i),yco(i),zco(i),rms(i)
c       if(i.eq.22)print *,i,typ(i),xco(i),yco(i),zco(i)
       goto 100
200    continue
       natom=i-1
       close(15,status='keep')
       write(*,*)'incoo: number of atoms',natom
       write(*,*)' '
       return
9000   format(i6,1x,i2,4(1x,g13.6))
*
*****c***1********2*******3********4********5********6********7********8
*
9997  write(*,*)'incoo: open file error',ios
      return
9998  write(*,*)'incoo: input error'
      return
      end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine initd(mdat,ndat,x,set)
*
*****c***1********2*******3********4********5********6********7********8
*
       implicit none
* global variables
       integer mdat,ndat
       real x(mdat),set
* local variables
       integer i
*
*****c***1********2*******3********4********5********6********7********8
*
       do 100 i=1,ndat
        x(i)=set
100    continue
       return
       end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine initd2(mdat,ndat,mset,nset,x,set)
*
*****c***1********2*******3********4********5********6********7********8
*
       implicit none
* global variables
       integer mdat,ndat,mset,nset
       real x(mdat,mset),set
* local variables
       integer i,j
*
*****c***1********2*******3********4********5********6********7********8
*
       do 101 j=1,nset
        do 100 i=1,ndat
         x(i,j)=set
100     continue
101    continue
       return
       end
*****c***1********2*******3********4********5********6********7********8
      subroutine histo(mhis,nhis,mpdf,npdf,rad,gij,con,bnwdth)
*****c***1********2*******3********4********5********6********7********8
*
* declarations 
*
       implicit none
       integer mhis,nhis,mpdf,npdf,mhis2,mpdf2
       parameter(mhis2=4096,mpdf2=20)
       real rad(mhis),gij(mhis,mpdf),con(mhis,mpdf)
       real rh(mhis2),gh(mhis2,mpdf2),ch(mhis2,mpdf2)
       real bnwdth
       character*31 filhis
       integer ios,i,j,l
*
* read rmc data
*
       print *,'number of bins: ',nhis
*
* make histogram
*
      bnwdth=rad(2)-rad(1)
      j=-1
      do 500 i=1,nhis
       j=j+2
       rh(j   )=rad(i)-bnwdth*0.5
       rh(j+1 )=rad(i)+bnwdth*0.5
       do 490 l=1,npdf
        gh(j  ,l)=gij(i,l)
        gh(j+1,l)=gij(i,l)
        ch(j  ,l)=con(i,l)
        ch(j+1,l)=con(i,l)
490    continue
500   continue
*
* save histogram
*
       filhis='rmc.his'
       print *,'save histogram in: ',filhis
       open(15,file=filhis,status='unknown',err=9997,iostat=ios)
       do 1000 i=1,nhis*2
        write(15,9000,err=9998)
     1               rh(i),(gh(i,l),ch(i,l),l=1,npdf)
1000    continue
       close(15,status='keep')
       return
9000   format(42(g13.6,1x))
*
*****c***1********2*******3********4********5********6********7********8
*
9997  print *,'histo: open file error',ios
      return
9998  print *,'histo: output error'
      return
      end
*****c***1********2*******3********4********5********6********7********8
*
      subroutine select(matom,natom,nsel,typ,xco,yco,zco,rms,sel,
     1                  xminb,xmaxb,yminb,ymaxb,zminb,zmaxb,
     2                  sx,sy,sz,sr,px,py,pz,pri,pro,selct)
*
*****c***1********2*******3********4********5********6********7********8
      integer i,matom,natom,sel(matom),nsel,typ(matom)
      real xco(matom),yco(matom),zco(matom),rms(matom)
      real xminb,xmaxb,yminb,ymaxb,zminb,zmaxb
      real xc,yc,zc
      real sx,sy,sz,sr,r
      real px,py,pz,pri,pro
      character*1 selct
*
       nsel=0
       do i=1,matom
        sel(i)=0
       enddo
       do i=1,natom
        xc=xco(i)
        yc=yco(i)
        zc=zco(i)
c        print *,i,xc,yc,zc,xco(i),yco(i),zco(i)
       if(selct.eq.'b')then
        if((xc.ge.xminb).and.(xc.le.xmaxb).and.
     1     (yc.ge.yminb).and.(yc.le.ymaxb).and.
     2     (zc.ge.zminb).and.(zc.le.zmaxb))then
         sel(i)=1
         nsel=nsel+1
c         print *,'b',i,sel(i),xc,yc,zc
        endif
       elseif(selct.eq.'s')then
        r=sqrt((xc-sx)*(xc-sx)+(yc-sy)*(yc-sy)+(zc-sz)*(zc-sz))
        if(r.le.sr)then
         sel(i)=1
         nsel=nsel+1
c         print *,'s',i,sel(i),xc,yc,zc
        endif
       elseif(selct.eq.'p')then
        r=sqrt((xc-px)*(xc-px)+(yc-py)*(yc-py)+(zc-pz)*(zc-pz))
        if((r.ge.pri).and.(r.le.pro))then
         sel(i)=1
         nsel=nsel+1
c         print *,'p',i,sel(i),xc,yc,zc
        endif
       else
        sel(i)=1
        nsel=nsel+1
       endif
       enddo
      print *,'atoms selected ',nsel
      return
      end
*

*****c***1********2*******3********4********5********6********7********8
*
      subroutine lispdf(mtyp,ntyp,lisp,list)
*
*****c***1********2*******3********4********5********6********7********8
*
*
*****c***1********2*******3********4********5********6********7********8
*
* m. winterer 1/31/97 darmstadt
* include list, matrix to correlate the lisp-numbers back to the atom
*  type identifiers 10/7/98
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations 
*
       implicit none
       integer i,j,mtyp,ntyp,l
       integer lisp(mtyp,mtyp),list(2,mtyp*(mtyp+1)/2)

       l=0 
       do j=1,ntyp
        do i=j,ntyp
         l=l+1
         list(1,l)=i
         list(2,l)=j
         lisp(i,j)=l 
        enddo
       enddo
       do i=1,ntyp
        do j=1,i
         lisp(j,i)=lisp(i,j)
        enddo
       enddo
      return
      end

*****c***1********2*******3********4********5********6********7********8
*
      subroutine inipdf(matom,natom,mtyp,ntyp,mhis,nhis,
     1                  mpdf,npdf,typ,deltar,rmax,cut,close,
     2                  conc,rad)
*
*****c***1********2*******3********4********5********6********7********8
*
* initialize cutoff, concentrations and histogram radius
*
*****c***1********2*******3********4********5********6********7********8
*
*     m. winterer 3/27/98 Darmstadt
*
*****c***1********2*******3********4********5********6********7********8
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
* global variables
*
      implicit none
      integer mpdf,npdf,nhis,mhis,mtyp,ntyp,matom,natom
      integer i,l,typ(matom),bin
      real cut,close(mpdf),rdelta,deltar,rmax,conc(mtyp)
      real rlo,rad(mhis)
*
* local variables
*
*
*****c***1********2*******3********4********5********6********7********8
*
* initialization
*
* use only cutoffs of pdf's used for xafs!
      do 10 i=1,npdf
       cut=amin1(cut,close(i))
10    continue
      rdelta=1.0/deltar
      nhis=int((rmax-cut)*rdelta)+1
      if(nhis.gt.mhis)then
       write(*,*)'pdfini error: ',
     1  'number of bins exceeds physical storage: ',nhis,' > ',mhis
       print *,'pdfini error: ',
     1  'number of bins exceeds physical storage: ',nhis,' > ',mhis
       stop
      endif
*
* calculate atom concentrations
*
      call initd(mtyp,mtyp,conc,0.0)
       do 50 i=1,natom
        l=typ(i)
        conc(l)=conc(l)+1.0
50     continue
       do 51 l=1,ntyp
        conc(l)=conc(l)/float(natom)
51     continue
*
* calculate bin radii
*
      do 100 bin=1,nhis
         rlo=real(bin-1)*deltar+cut
	 rad(bin)=rlo+deltar*0.5
100   continue
*
      return
      end

*****c***1********2*******3********4********5********6********7********8
*
      subroutine pdfini(mhis,nhis,mtyp,ntyp,mpdf,npdf,nsel,
     1                  matom,natom,gmet,xco,yco,zco,typ,conc,lisp,list,
     2                  cut,gij,deltar,rmax,rho,pbc,sonly,sel)
*
*****c***1********2*******3********4********5********6********7********8
*
*      calculate three dimensional pair distrubution functions 
*      for rmc: initial distribution function
*
*      source: mainly M.P. Allen and D.J. Tildesly,
*              "Computer simulations of liquids"
*               Oxford 1987,30,183
*
*****c***1********2*******3********4********5********6********7********8
*
*     m. winterer 1/19/97 Darmstadt
*     changes for more than 2 elements: 2/24/98
*     changes for more than 2 phases: 3/30/98
*     changes: revise normalization of gij 10/7/98
*     changes: distance calculation to double precision and 
*              fixed bug in pdfini (for large boxes) 10/20/98 mw
*              sum gij only for bin < nhis !
*
*****c***1********2*******3********4********5********6********7********8
*
* global variables
*
* mhis,nhis                maximum and actual number of histogram points
* mtyp,ntyp                maximum and actual number of atom types
* matom,natom              maximum and actual number of atoms
* xco(matom)               x-coordinate of atoms 
* yco(matom)               y-coordinate of atoms
* zco(matom)               z-coordinate of atoms
* typ(matom)               type (label) of atoms
* rad(mhis)                abscissa of pair distribution function histogram
* gij(mhis,mtyp)           partial pair distribution function histograms
* deltar                   interval of abcissa of pdf
* rmax                     maximum radius of abcissa of pdf
* rho                      number density of system
* pi                       3.14...
*
* local variables
*
* i,j,l,bin                loop indices
* boxi                     inverse of length of simulation box
* rdelta                   inverse of interval of abcissa of pdf
* xi,yi,zi                 temporary storage of coordinates
* dx,dy,dz                 difference of coordinates
* rx,rij,rijsq             distance and square distance of atoms
* nideal                   number of atoms in an ideal gas of the same V and rho
* const                    normalization constant
* rup,rlo                  upper and lower value of histogram bin (abcissa)
*
* files used:              none
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
* global variables
*
      implicit none
      integer mhis,nhis,mtyp,ntyp,mpdf,npdf,matom,natom,nsel
      integer typ(matom),lisp(mtyp,mtyp)
      integer list(2,mtyp*(mtyp+1)/2)
      real xco(matom),yco(matom),zco(matom)
      real*8 gmet(3,3)
      real gij(mhis,mpdf)
      real deltar,rmax,rho,pi,conc(mtyp)
      integer sel(matom)
      logical sonly,pbc
      common /const/ pi
*
* local variables
*
      integer i,j,l,bin,idi,idj,n
      real rdelta,xi,yi,zi,rij,xj,yj,zj
      real nideal,const,rup,rlo,cut
*
*****c***1********2*******3********4********5********6********7********8
*
* initialization
*
      rdelta=1.0/deltar
*
      do 20 l=1,npdf
       do 10 i=1,nhis
        gij(i,l)=0.0
10     continue
20    continue
*
* calculate pair distribution functions
*
      do 200 i=1,natom-1
* selected atoms only
       if(sel(i).eq.1)then
* selected atoms only
       xi=xco(i)
       yi=yco(i)
       zi=zco(i)
       idi=typ(i)
       do 190 j=i+1,natom
* selected atoms only
        if((sonly.and.(sel(j).eq.1)).or.(sonly.eqv..false.))then
* selected atoms only
        idj=typ(j)
        l=lisp(idi,idj)
        if(l.le.npdf)then
*
* calculate distances
*
        xj=xco(j)
        yj=yco(j)
        zj=zco(j)
        call distan(xi,yi,zi,xj,yj,zj,gmet,rij,pbc)
*
* calculate distances
*
        bin=int((rij-cut)*rdelta)+1
* change: summ gij only for bin < nhis mw10/20/98
         if(bin.le.nhis)then
* different atom types have labels: typ(j), typ(i) is the same for all: 1
* this is used to discriminate between grii, grjj and grij
          if(idi.eq.idj)then
	   gij(bin,l)=gij(bin,l)+2.0
          else
	   gij(bin,l)=gij(bin,l)+1.0
          endif
         endif
        endif
        endif
190    continue 
       endif
200   continue
*
*  calculation of bin radius, normalization and integration of pdf
*   for multiple phases rho is the density of a single phase
*
       print *,'normalization of pdf'
       const=real(nsel)*rho*pi*4.0/3.0
       do 300 l=1,npdf
        idi=list(1,l)
        idj=list(2,l)
        do 290 bin=1,nhis
         rlo=real(bin-1)*deltar+cut
         rup=rlo+deltar
* normalization: gij(r->oo)=1
         nideal=const*conc(idi)*conc(idj)*(rup*rup*rup-rlo*rlo*rlo)
	 gij(bin,l)=gij(bin,l)/nideal
290     continue
300    continue
*
      return
      end

*****c***1********2*******3********4********5********6********7********8
*
      subroutine pdfcon(mhis,nhis,mtyp,ntyp,mpdf,npdf,rad,gij,con,
     1                   deltar,rmax,rho,conc,list)
*
*****c***1********2*******3********4********5********6********7********8
*
* integrate partial radial distribution functions
* change normalization of gij 10/7/98mw
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
* global variables
*
      implicit none
      integer mhis,nhis,mtyp,ntyp,mpdf,npdf
      integer idj,list(2,mtyp*(mtyp+1)/2)
      real rad(mhis),gij(mhis,mpdf),con(mhis,mpdf),conc(mtyp)
      real deltar,rmax,rho,pi
      common /const/ pi
*
* local variables
*
      integer bin,i,j
      real const,rx,g1,g2,g3,sum
*
* initialize coordination number and total distribution function
*
       do 100 i=1,npdf
        do 90 j=1,nhis
	 con(j,i)=0.0
90      continue
100    continue
*
* integration of pdf: coordination numbers
*
       const=4.0*pi*rho*deltar/6.
c       const=4.0*pi*deltar/6.
       do 310 j=1,npdf
        sum=0.0
c        idj=list(2,j)
        idj=list(1,j)
        do 300 bin=2,nhis-1
	 rx=rad(bin)
	 g1=gij(bin-1,j)
	 g2=gij(bin  ,j)
	 g3=gij(bin+1,j)
	 sum=sum+const*conc(idj)*rx*rx*(g1+4.*g2+g3)
         con(bin,j)=sum
300     continue
        con(1,j)=0.0
        con(nhis,j)=con(nhis-1,j)
310    continue
*
      return
      end

*****c***1********2*******3********4********5********6********7********8
*
       subroutine makehm(alatt,blatt,clatt,hn,kn,ln,
     1                   alphad,betad,gammad,volume,hmat)
*
*****c***1********2*******3********4********5********6********7********8
*
* matrix algebra for Reverse Monte Carlo (Parinello-Rahman):
*
* make transformation matrix H for transformation 
* from cartesian to crystallographic coordinates
*
* source:  C. Giacovazzo, Fundamentals of Crystallography, 68pp.
*
* 10/20/98 double precision
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       integer hn,kn,ln
       real alatt,blatt,clatt
       real*8 volume,alpha,beta,gamma,pid
       real*8 a,b,c
       real*8 cosa,cosb,cosg,sinb,sing,cosas,cs
       real alphad,betad,gammad
       real*8 hmat(3,3)
* conversion from degrees to radians
        pid=4.0d0*datan(1.0d0)
        alpha=dble(alphad)*pid/180.d0
        beta= dble(betad)*pid/180.d0
        gamma=dble(gammad)*pid/180.d0
*
* geometric factors
*
        a=dble(real(hn)*alatt)
        b=dble(real(kn)*blatt)
        c=dble(real(ln)*clatt)
       
        cosa=dcos(dble(alpha))
        cosb=dcos(dble(beta))
        cosg=dcos(dble(gamma))
        sinb=dsin(dble(beta))
        sing=dsin(dble(gamma))
        
        cosas=(cosb*cosg-cosa)/(sinb*sing)
       
        volume=real(a*b*c*
     1         dsqrt(1.0d0-cosa*cosa-cosb*cosb-cosg*cosg
     2             + 2.0d0*cosa*cosb*cosg))
       
        cs=a*b*sing/volume
*
* matrix elements
*
c        print *,volume
c        print *,'hmat'
        hmat(1,1)= a
        hmat(1,2)= 0.0d0
        hmat(1,3)= 0.0d0
        hmat(2,1)= b*cosg
        hmat(2,2)= b*sing
        hmat(2,3)= 0.0d0
        hmat(3,1)= c*cosb
        hmat(3,2)=-c*sinb*cosas 
        hmat(3,3)= 1.0d0/cs

c        print *,'hmat'
c        print 9000,hmat(1,1,1),hmat(1,2,1),hmat(1,3,1)
c        print 9000,hmat(2,1,1),hmat(2,2,1),hmat(2,3,1)
c        print 9000,hmat(3,1,1),hmat(3,2,1),hmat(3,3,1)
9000    format(1x,3(g13.6e2,1x))
       return
       end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine makehi(alatt,blatt,clatt,hn,kn,ln,
     1                   alphad,betad,gammad,volume,hinv)
*
*****c***1********2*******3********4********5********6********7********8
*
* matrix algebra for Reverse Monte Carlo (Parinello-Rahman):
*
* make inverse transformation matrix HI for transformation 
* from crystallographic to cartesian coordinates
*
* source:  C. Giacovazzo, Fundamentals of Crystallography, 68pp.
*
* m. winterer 3/5/98
* 10/20/98 double precision
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       integer hn,kn,ln
       real alatt,blatt,clatt
       real*8 volume,alpha,beta,gamma,pid
       real*8 a,b,c
       real*8 cosa,cosb,cosg,sina,sinb,sing
       real*8 cosas,cosbs,as,bs,cs
       real*8 hinv(3,3)
       real alphad,betad,gammad
* conversion from degrees to radians
*
c        print *,volume
c        print *,'hinv'
        pid=4.0d0*datan(1.0d0)
        alpha=dble(alphad)*pid/180.d0
        beta= dble(betad)*pid/180.d0
        gamma=dble(gammad)*pid/180.d0
*
* geometric factors
*
        a=dble(float(hn)*alatt)
        b=dble(float(kn)*blatt)
        c=dble(float(ln)*clatt)
       
        cosa=dcos(alpha)
        cosb=dcos(beta)
        cosg=dcos(gamma)
        sina=dsin(alpha)
        sinb=dsin(beta)
        sing=dsin(gamma)
        cosas=(cosb*cosg-cosa)/(sinb*sing)
        cosbs=(cosa*cosg-cosb)/(sina*sing)
       
        as=b*c*sina/volume
        bs=a*c*sinb/volume
        cs=a*b*sing/volume
*
* matrix elements
*
        hinv(1,1)= 1.d0/a
        hinv(1,2)= 0.0d0
        hinv(1,3)= 0.0d0
        hinv(2,1)=-cosg/(a*sing)
        hinv(2,2)= 1.d0/(b*sing)
        hinv(2,3)= 0.0d0
        hinv(3,1)= as*cosbs
        hinv(3,2)= bs*cosas 
        hinv(3,3)= cs

c        print *,'hinv'
c        print 9000,hinv(1,1,1),hinv(1,2,1),hinv(1,3,1)
c        print 9000,hinv(2,1,1),hinv(2,2,1),hinv(2,3,1)
c        print 9000,hinv(3,1,1),hinv(3,2,1),hinv(3,3,1)
9000    format(1x,3(g13.6e2,1x))
       return
       end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine makegm(hmat,gmet)
*
*****c***1********2*******3********4********5********6********7********8
*
* matrix algebra for Reverse Monte Carlo (Parinello-Rahman):
*
* make metric matrix G = H'.H; G is symmetric
*
* source:  C. Giacovazzo, Fundamentals of Crystallography, 68pp.
* and:     M. Parrinello, and A. Rahman, J. Appl. Phys. 52 (1981), 7182
*
* m. winterer 3/5/98
* 10/20/98 double precision
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       real*8 gmet(3,3),hmat(3,3)
*
* matrix elements
c        print *,'gmet'
        gmet(1,1)= hmat(1,1)*hmat(1,1)
        gmet(1,2)= hmat(1,1)*hmat(2,1)
        gmet(1,3)= hmat(1,1)*hmat(3,1)
        gmet(2,1)= gmet(1,2)
        gmet(2,2)= hmat(2,1)*hmat(2,1)+hmat(2,2)*hmat(2,2)
        gmet(2,3)= hmat(2,1)*hmat(3,1)+hmat(2,2)*hmat(3,2)
        gmet(3,1)= gmet(1,3)
        gmet(3,2)= gmet(2,3)
        gmet(3,3)= hmat(3,1)*hmat(3,1)+hmat(3,2)*hmat(3,2)+
     1               hmat(3,3)*hmat(3,3)

c        print *,'gmet'
c        print 9000,gmet(1,1,1),gmet(1,2,1),gmet(1,3,1)
c        print 9000,gmet(2,1,1),gmet(2,2,1),gmet(2,3,1)
c        print 9000,gmet(3,1,1),gmet(3,2,1),gmet(3,3,1)
9000    format(1x,3(g13.6e2,1x))
       return
       end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine tranco(x,y,z,hmat,a,b,c)
*
*****c***1********2*******3********4********5********6********7********8
*
* matrix algebra for Reverse Monte Carlo (Parinello-Rahman):
*
* (tran)sformation from cartesian ( (o)rthogonal (x)
*                to                 (c)rystallographic (a) coordinates
* a = H.x
*
* source:  C. Giacovazzo, Fundamentals of Crystallography, 68pp.
* and:     M. Parrinello, and A. Rahman, J. Appl. Phys. 52 (1981), 7182
*
* m. winterer 3/5/98
* 10/20/98 double precision
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       real a,b,c,x,y,z
       real*8 hmat(3,3)
*
*
* transformation 
*
       a=real(dble(x)*hmat(1,1)+dble(y)*hmat(2,1)+
     1        dble(z)*hmat(3,1))
       b=real(dble(y)*hmat(2,2)+dble(z)*hmat(3,2))
       c=real(dble(z)*hmat(3,3))
              
       return
       end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine tranoc(a,b,c,hinv,x,y,z)
*
*****c***1********2*******3********4********5********6********7********8
*
* matrix algebra for Reverse Monte Carlo (Parinello-Rahman):
*
* (tran)sformation from (c)rystallographic (a) 
* to        cartesian ( (o)rthogonal       (x) coordinates
* x = HI.a
*
* source:  C. Giacovazzo, Fundamentals of Crystallography, 68pp.
* and:     M. Parrinello, and A. Rahman, J. Appl. Phys. 52 (1981), 7182
*
* m. winterer 3/5/98
* 10/20/98 double precision
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       real a,b,c,x,y,z
       real*8 hinv(3,3)
*
*
* transformation
*
       x=real(dble(a)*hinv(1,1)+dble(b)*hinv(2,1)+
     1        dble(c)*hinv(3,1))
       y=real(dble(b)*hinv(2,2)+dble(c)*hinv(3,2))
       z=real(dble(c)*hinv(3,3))
c       if((abs(x).ge.0.5).or.(abs(y).ge.0.5).or.(abs(z).ge.0.5))then
c        print *,a,b,c
c        print *,x,y,z
c       endif
              
       return
       end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine distan(a,b,c,x,y,z,gmet,rij,pbc)
*
*****c***1********2*******3********4********5********6********7********8
*
* matrix algebra for Reverse Monte Carlo (Parinello-Rahman):
*
* calculation of atomic distances rij
* 
* rij=sqrt((si-sj)*G*(si-sj))
* G: metric matrix; si,sj: vectors of atoms i and j in cryst. coordinates 
*
* source:  C. Giacovazzo, Fundamentals of Crystallography, 68pp.
* and:     M. Parrinello, and A. Rahman, J. Appl. Phys. 52 (1981), 7182
*
* m. winterer 3/5/98
* 10/20/98 double precision
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       real a,b,c,x,y,z,rij
       real*8 gmet(3,3),dx,dy,dz
       logical pbc
*
* point distances
*
       dx=dble(a)-dble(x)
       dy=dble(b)-dble(y)
       dz=dble(c)-dble(z)
* minimum image convention: Allen & Tildesly p.30
       if(pbc)then
        dx=dx-anint(dx)
        dy=dy-anint(dy)
        dz=dz-anint(dz)
       endif
* minimum image convention: Allen & Tildesly p.30

        rij=real(dsqrt(
     1          dx*dx*gmet(1,1)+
     2          dy*dy*gmet(2,2)+dz*dz*gmet(3,3)+
     3          2.*dx*dy*gmet(1,2)+
     4          2.*dy*dz*gmet(2,3)+
     5          2.*dx*dz*gmet(1,3)))
         
c       print *,'rij= ',rij 
       return
       end
*****c****1********2*******3********4********5********6********7********8
      subroutine inpar(filcoo,ntyp,hn,kn,ln,alatt,blatt,clatt,
     1                 alphad,betad,gammad,cut,rmax,deltar,rho,dmode,
     2                 xminb,xmaxb,yminb,ymaxb,zminb,zmaxb,
     3                 sx,sy,sz,sr,px,py,pz,pri,pro,selct,sonly,pbc)
******c***1********2*******3********4********5********6********7********8
*
*     declarations
*
      implicit none
      integer ntyp
      integer hn,kn,ln
      real alatt,blatt,clatt
      real alphad,betad,gammad
      real cut,rmax,deltar,rho
      real xminb,xmaxb,yminb,ymaxb,zminb,zmaxb
      real sx,sy,sz,sr,px,py,pz,pri,pro
      character*1 selct,dmode
      character*256 filpar,filcoo
      logical pbc,sonly
*
      selct='a'
      pbc=.true.
      sonly=.false.
      filpar='pdf.par'
      dmode='a'
      open(9,file=filpar,status='old')
      read(9,'(a)')filcoo
*      print *,'filname: ',filcoo
      read(9,*)alatt,blatt,clatt
*      print *,alatt,blatt,clatt
      read(9,*)alphad,betad,gammad
*      print *,alphad,betad,gammad
      read(9,*)hn,kn,ln
*      print *,hn,kn,ln
      read(9,*)ntyp
*      print *,ntyp
      read(9,*)pbc
*      print *,pbc
      read(9,*)cut,rmax,deltar
*      print *,cut,rmax,deltar
c 1 if unknown, 0 if to be calculated
      read(9,*)rho
      read(9,'(a)')dmode
*      print *,rho
c select (a)ll atoms, (b)ox, (s)phere, (p)eel
      read(9,'(a)')selct
*      print *,selct
      read(9,*)xminb,xmaxb,yminb,ymaxb,zminb,zmaxb
*      print *,xminb,xmaxb,yminb,ymaxb,zminb,zmaxb
      read(9,*)sx,sy,sz,sr
*      print *,sx,sy,sz,sr
      read(9,*)px,py,pz,pri,pro
*      print *,px,py,pz,pri,pro
      read(9,*)sonly
*      print *,sonly
      close(9,status='keep')
*
      return
      end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine outpdf(mhis,nhis,mtyp,ntyp,mpdf,npdf,rad,gij,con,rho)
*
*****c***1********2*******3********4********5********6********7********8
*
* output partial distribution functions
*
*****c***1********2*******3********4********5********6********7********8
*
* m. winterer 1/31/97 darmstadt
* change normalization of gij 10/7/98
*
*****c***1********2*******3********4********5********6********7********8
*
* global variables
*
* local variables
*
* files used:              rmc.pdf, unit 15
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations 
*
       implicit none
* global variables
       integer mhis,nhis,mtyp,ntyp,iol,mpdf,npdf
       real rad(mhis),gij(mhis,mpdf),con(mhis,mpdf),rho
       character*31 filpdf
* local variables
       integer ios,i,k
*
*****c***1********2*******3********4********5********6********7********8
*
       filpdf='rmc.pdf.pdf'
       open(15,file=filpdf,status='unknown',err=9997,iostat=ios)
       do 200 i=1,nhis
        write(15,9000,err=9998)
     1               rad(i),(gij(i,k),con(i,k),k=1,npdf)
c     1               rad(i),(gij(i,k)/rho,con(i,k),k=1,npdf)
47     continue

200    continue
       close(15,status='keep')
       print *,'save pair distribution functions: ',filpdf
       return
9000   format(21(g13.6,1x))
*
*****c***1********2*******3********4********5********6********7********8
*
9997  write(*,*)'outpdf: open file error',ios
      return
9998  write(*,*)'outpdf: output error'
      return
      end
