*****c***1********2*******3********4********5********6********7********8
*
       program interface
*
*****c***1********2*******3********4********5********6********7********8
* Markus Winterer Duisburg 4/3/19
* debugged 6/29/21 mw
*****c***1********2*******3********4********5********6********7********8
       integer natom,matom,nsolid,nmatrix
       parameter(matom=100000)
       integer typ(matom),mtyp,ntyp,idum,otyp
       real xco(matom),yco(matom),zco(matom),tag(matom),sel(matom)
       real srad,slabt,dum,rad,xa,ya,za,ssel
       real r,ranf
       integer i,j,count
       character*128 filein,filout 
       character*2 unse
       character*1 ityp,mo,answer
       external ranf
*
*****c***1********2*******3********4********5********6********7********8
*
       idum=-1
       do i=1,1000000
        r=ranf(idum)
c        print *,i,idum,r
       enddo
*
*****c***1********2*******3********4********5********6********7********8
*
* input coordinates and parameters
*
       print *,' '
       print *,'generation of configuration with an interface'
       print *,' '
       print *,'filname of input configuration to be modified: '
       read(*,'(a)')filein
       print *,'filname of modified output configuration: '
       read(*,'(a)')filout
       print *,' '
       print *,'(s)pherical or (b)ox (slab-like) interface: '
       read(*,*)ityp
       print *,' '
       if(ityp.eq.'s')then
        print *,'sphere radius: '
        read(*,*)srad
        srad=abs(srad)
       else
        print *,'slab (matrix) thickness in z-direction : '
        read(*,*)slabt
        slabt=abs(slabt)
       endif
       print *,' '
       open(15,file=filein,status='unknown')
       i=0
       count=0
10     continue 
        i=i+1
        read(15,*,end=20)j,typ(i),xco(i),yco(i),zco(i),dum,tag(i)
        xa=xco(i)
        ya=yco(i)
        za=zco(i)
        if(ityp.eq.'s')then
         rad=sqrt(xa*xa+ya*ya+za*za)
         print *,i,j,xa,ya,za,rad
         if(rad.le.srad)then
          sel(i)=1.0
          count=count+1
         else
          sel(i)=0.0
         endif
        else
         if((za.ge.slabt*0.5).or.(za.le.(-slabt*0.5)))then
          sel(i)=1.0
          count=count+1
         else
          sel(i)=0.0
         endif
        endif
       goto 10
20     continue
       natom=i-1 
       close(15,status='keep')
       nsolid=count
       nmatrix=natom-count
       print *,'input      ',natom,' atoms '
       if(ityp.eq.'s')then
        print *,'selected   ',nsolid,' atoms in sphere'
       else
        print *,'selected   ',nsolid,' atoms in slab'
       endif
       print *, 'unselected ',nmatrix,' atoms in matrix '
       print *,' '
       nsolid=count
       nmatrix=natom-count
*
*****c***1********2*******3********4********5********6********7********8
*
* modify coordinates
*
100    continue
        print *,' '
        ssel=1.0
        print *,'modify (un)(se)lected coordinates ? '
        print *,' '
        read(*,*)unse
        if(unse.eq.'se')then
         ssel=1.0
        else
         ssel=0.0
        endif
        print *,' '
        print *,'(v)acanies, (s)ubstitution, (m)ovement tag ? '
        print *,' '
        read(*,*)mo
*
        if(mo.eq.'v')then
*
* vacancies       
*
         print *,'vacancy for type of atoms  '
         read(*,*)otyp
         print *,'fraction of vacancies '
         read(*,*)frac
         j=0
         count=0
         do i=1,natom
* operate only on (un)selected atoms
          if(sel(i).eq.ssel)then
* generate vacancies on sites of type "otyp"
           if(typ(i).eq.otyp)then
            r=ranf(idum)
* generate vacancies only for a fraction of atoms
            if(r.le.frac)then
             count=count+1
            else
             j=j+1
             typ(j)=typ(i)
             xco(j)=xco(i)
             yco(j)=yco(i)
             zco(j)=zco(i)
             tag(j)=tag(i)
             sel(j)=sel(i)
            endif
           else
            j=j+1
            typ(j)=typ(i)
            xco(j)=xco(i)
            yco(j)=yco(i)
            zco(j)=zco(i)
            tag(j)=tag(i)
            sel(j)=sel(i)
           endif
          else
           j=j+1
           typ(j)=typ(i)
           xco(j)=xco(i)
           yco(j)=yco(i)
           zco(j)=zco(i)
           tag(j)=tag(i)
           sel(j)=sel(i)
          endif
         enddo
         natom=j
         print *,count,' vacancies generated'
         print *,natom,' atoms in configuration'
*
*
        elseif(mo.eq.'s')then
*
* substitution
*
         print *,'substitution for type of atoms  '
         read(*,*)otyp
         print *,'with type of atoms  '
         read(*,*)ntyp
         print *,'fraction of atoms to be substituted '
         read(*,*)frac
         count=0
         do i=1,natom
* operate only on selected atoms
          if(sel(i).eq.ssel)then
* generate substitutions on sites of type "otyp"
           if(typ(i).eq.otyp)then
            r=ranf(idum)
* generate substitutions only for a fraction of atoms by "ntyp"
            if(r.le.frac)then
             typ(i)=ntyp
             count=count+1
            endif
           endif
          endif
         enddo
         print *,count,' substituted atoms generated'
         print *,natom,' atoms in configuration'
*
        elseif(mo.eq.'m')then
*
* movement tag 
*
         print *,'change movement tag from 1.0 to 0.0 & vice versa'
         print *,' '
         count=0
         do i=1,natom
          if(sel(i).eq.ssel)then
           if(tag(i).eq.1.0)then
            tag(i)=0.0
           elseif(tag(i).eq.0.0)then
            tag(i)=1.0
           endif
           count=count+1
          endif
         enddo
         print *,count,' movement tags modified'
         print *,' '
        endif
*
        print *,' '
        print *,'more modifications ? '
        read(*,*)answer 
        print *,' '
        if(answer.ne.'n')goto 100
*
*****c***1********2*******3********4********5********6********7********8
*
* output coordinates
*
*****c***1********2*******3********4********5********6********7********8
*
       nout=natom
       print *,' '
       print *,'output of ',nout,' atom coordinates'
       print *,' '

       open(15,file=filout,status='unknown')
       do i=1,nout
        write(15,9000)i,typ(i),xco(i),yco(i),zco(i),0.0,tag(i)
       enddo
       close(15,status='keep')

9000   format(i6,1x,i2,5(1x,g13.6))
*
       end
*
*****c***1********2*******3********4********5********6********7********8
*
      real function ranf(idum)
*
* random number generator ran3 from numerical recipes
*
      parameter (mbig=1000000000,mseed=161803398,mz=0,fac=1.e-9)
      dimension ma(55)
      data iff /0/
      if(idum.lt.0.or.iff.eq.0)then
        iff=1
        mj=mseed-iabs(idum)
        mj=mod(mj,mbig)
        ma(55)=mj
        mk=1
        do 11 i=1,54
          ii=mod(21*i,55)
          ma(ii)=mk
          mk=mj-mk
          if(mk.lt.mz)mk=mk+mbig
          mj=ma(ii)
11      continue
        do 13 k=1,4
          do 12 i=1,55
            ma(i)=ma(i)-ma(1+mod(i+30,55))
            if(ma(i).lt.mz)ma(i)=ma(i)+mbig
12        continue
13      continue
        inext=0
        inextp=31
        idum=1
      endif
      inext=inext+1
      if(inext.eq.56)inext=1
      inextp=inextp+1
      if(inextp.eq.56)inextp=1
      mj=ma(inext)-ma(inextp)
      if(mj.lt.mz)mj=mj+mbig
      ma(inext)=mj
      ranf=mj*fac
      return
      end
