******c***1********2*******3********4********5********6********7********8
*
       program anacon
*
******c***1********2*******3********4********5********6********7********8
*
* program to analyse atomic coordinates for connectivities and
*  write PDB and MacMolecule files
*
* Markus Winterer Darmstadt 8/10/98
*
******c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       integer mtyp,ntyp,hn,kn,ln
       integer matom,natom,i,namlen
       parameter(mtyp=4,matom=100000)
       integer typ(matom),num(matom),nc(matom),cn(matom,12),list(matom)
       integer npar,par1(mtyp),par2(mtyp)
       real alatt,blatt,clatt,alphad,betad,gammad
       real cosr,cosg,cosb
       real dfill(mtyp),dbas(mtyp),colr(mtyp),colg(mtyp),colb(mtyp)
       real volume,hmat(3,3),hinv(3,3),gmet(3,3)
       real xcr(matom),ycr(matom),zcr(matom),rmsd(matom)
       real xco(matom),yco(matom),zco(matom)
       real bond1(mtyp),bond2(mtyp),face
       real pi
       real rs,xsp,ysp,zsp,xbon,ybon,zbon,xbox,ybox,zbox
       character*1 slct
       character*2 name2(mtyp)
       character*31 filcoo,filout
       character*80 title,header
       character*80 version
       logical pbc
* common blocks
      common /const/ pi
*
******c***1********2*******3********4********5********6********7********8
*
* initializations
*
* initialize pi
       pi=4.0*real(datan(1.0d0))
*
       version='anacon 11/26/14mw'
*
       print *,'program to analyse atomic coordinates for'
       print *,'connectivities and write PDB and MacMolecule files'
       print *,'Markus Winterer Darmstadt 1/7/99'
       print *,'version: '//version
*
* input 
*
      call inpar(mtyp,ntyp,hn,kn,ln,title,filcoo,filout,namlen,
     1                 alatt,blatt,clatt,alphad,betad,gammad,
     2                 name2,dfill,dbas,colr,colg,colb,
     3                 npar,par1,par2,bond1,bond2,face,pbc,
     4                 slct,rs,xsp,ysp,zsp,
     5                 xbon,ybon,zbon,xbox,ybox,zbox)

       print *,'input parameters'
*
* make transformation and metric matrices
*
        call makehm(alatt,blatt,clatt,hn,kn,ln,
     1              alphad,betad,gammad,volume,hmat)
        call makehi(alatt,blatt,clatt,hn,kn,ln,
     1              alphad,betad,gammad,volume,hinv)
        call makegm(hmat,gmet)
        print *,'created transformation matrices'
*
* input initial coordinates       
* 
        call incoo(matom,natom,num,typ,xcr,ycr,zcr,rmsd,filcoo)
        print *,'input coordinates: ',natom
*
* convert cartesian to crystallographic coordinates
*
        do 100 i=1,natom
         call tranoc(xcr(i),ycr(i),zcr(i),
     1               hinv,xco(i),yco(i),zco(i)) 
c         print *,rmsd(i)
100     continue
        print *,'transformed coordinates'
*
* select atoms
*
       call select(matom,natom,hinv,gmet,slct,
     1             rs,xsp,ysp,zsp,xbon,ybon,zbon,xbox,ybox,zbox,
     2             xco,yco,zco,list,pbc)
*
* calculate "temperature" from rmsd values
*
       print *,'calculate "temperature" from rmsd values'
       call temper(matom,natom,list,rmsd)
*
* look for connections
*
       call anacnn(matom,natom,mtyp,npar,par1,par2,typ,xco,yco,zco,
     1                   list,gmet,face,bond1,bond2,nc,cn,pbc)
       print *,'analysed connectivities'
*
* output results
*
c       call outmcm(mtyp,ntyp,matom,natom,num,typ,xcr,ycr,zcr,
c     1             list,name2,nc,cn,dfill,dbas,cosr,cosg,cosb,
c     2                  colr,colg,colb,filout,namlen,title)
       print *,'output coordinates in MacMolecule format'
*
       call oupdb(mtyp,ntyp,matom,natom,title,filout,namlen,list,
     1                  name2,dfill,colr,colg,colb,num,typ,
     2                  xcr,ycr,zcr,nc,cn,rmsd)
       print *,'output coordinates in PDB format'
*
       end

*****c***1********2*******3********4********5********6********7********8
*
       subroutine incoo(matom,natom,num,typ,xco,yco,zco,rms,filcoo)
*
*****c***1********2*******3********4********5********6********7********8
*
* input atom coordinates 
*
*****c***1********2*******3********4********5********6********7********8
*
* m. winterer 1/31/97 darmstadt
*
*****c***1********2*******3********4********5********6********7********8
*
* global variables
*
* local variables
*
* files used:              rmc.coo, unit 15
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations 
*
       implicit none
* global variables
       integer matom,natom
       integer typ(matom),num(matom)
       real xco(matom),yco(matom),zco(matom),rms(matom)
       character*31 filcoo
* local variables
       integer ios,i,j
*
*****c***1********2*******3********4********5********6********7********8
*
       i=0
       open(15,file=filcoo,status='unknown')
100    continue
        i=i+1
        read(15,*,end=200)num(i),typ(i),
     1                                xco(i),yco(i),zco(i),rms(i)
       goto 100
200    continue
       natom=i-1
       close(15,status='keep')
9000   format(i6,1x,i2,4(1x,g13.6))
*
*****c***1********2*******3********4********5********6********7********8
*
      return
      end
*****c***1********2*******3********4********5********6********7********8
*
      subroutine anacnn(matom,natom,mtyp,npar,par1,par2,typ,xco,yco,zco,
     1                   list,gmet,face,bond1,bond2,nc,cn,pbc)
*
*****c***1********2*******3********4********5********6********7********8
*
*     m. winterer 8/10/98
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
* global variables
*
      implicit none
      integer matom,natom,i,j,k,l,mtyp
      real xi,xco(matom),yi,yco(matom),zi,zco(matom),xj,yj,zj
      real gmet(3,3),rij,bond1(mtyp),bond2(mtyp),face,rij1,rij2
      integer nc(matom),cn(matom,12),over,list(matom)
      integer npar,par1(mtyp),par2(mtyp),typ(matom),ipar
      logical pbc
*
*****c***1********2*******3********4********5********6********7********8
*
*  initialize connectivity counters
*
c      print *,'anacnn ',bond1(1),bond2(1)
      over=0
      do 100 i=1,matom
       nc(i)=0
100   continue
*
* calculate connectivity
*
      do 200 i=1,natom-1
       l=list(i) 
       xi=xco(l)
       yi=yco(l)
       zi=zco(l)

       do 190 j=i+1,natom
        k=list(j)
* 
* check for bonding partners
*
        call chckbp(mtyp,npar,typ(l),typ(k),par1,par2,ipar)
        if(ipar.eq.0)goto 189
*
* calculate distances
*

         xj=xco(k)
         yj=yco(k)
         zj=zco(k)
* check for closeness to box faces

         call distan(xi,yi,zi,  xi,  yi, 0.5,gmet,rij1,pbc)
         call distan(xj,yj,zj,  xj,  yj,-0.5,gmet,rij2,pbc)
         if((rij1.le.face).and.(rij2.le.face))goto191
         call distan(xi,yi,zi,  xi,  yi,-0.5,gmet,rij1,pbc)
         call distan(xj,yj,zj,  xj,  yj, 0.5,gmet,rij2,pbc)
         if((rij1.le.face).and.(rij2.le.face))goto191

         call distan(xi,yi,zi,  xi, 0.5,  zi,gmet,rij1,pbc)
         call distan(xj,yj,zj,  xj,-0.5,  zj,gmet,rij2,pbc)
         if((rij1.le.face).and.(rij2.le.face))goto191
         call distan(xi,yi,zi,  xi,-0.5,  zi,gmet,rij1,pbc)
         call distan(xj,yj,zj,  xj, 0.5,  zj,gmet,rij2,pbc)
         if((rij1.le.face).and.(rij2.le.face))goto191

         call distan(xi,yi,zi,-0.5,  yi,  zi,gmet,rij1,pbc)
         call distan(xj,yj,zj, 0.5,  yj,  zj,gmet,rij2,pbc)
         if((rij1.le.face).and.(rij2.le.face))goto191
         call distan(xi,yi,zi, 0.5,  yi,  zi,gmet,rij1,pbc)
         call distan(xj,yj,zj,-0.5,  yj,  zj,gmet,rij2,pbc)
         if((rij1.le.face).and.(rij2.le.face))goto191

         call distan(xi,yi,zi,xj,yj,zj,gmet,rij,pbc)
*
* make connection
*
c         print *,typ(l),typ(k),ipar,bond1(ipar),bond2(ipar),rij
         if((rij.ge.bond1(ipar)).and.(rij.le.bond2(ipar)))then
          nc(l)=nc(l)+1
c          print *,nc(l)
          if(nc(l).gt.12)then
           over=over+1
           goto 191
          endif
          cn(l,nc(l))=k
         endif
c         pause
189     continue
190    continue 
191    continue
200   continue
      if(over.gt.0)print *,'overflow in connectivity matrix ',over
*
      return
      end
*****c***1********2*******3********4********5********6********7********8
*
      subroutine chckbp(mtyp,npar,typ1,typ2,par1,par2,ipar)
      implicit none
      integer mtyp,npar,typ1,typ2,par1(mtyp),par2(mtyp),ipar,i
*
      ipar=0
      do i=1,npar
c       print *,typ1,typ2,par1(i),par2(i)
       if((typ1.eq.par1(i)).and.(typ2.eq.par2(i)).or.
     1    (typ1.eq.par2(i)).and.(typ2.eq.par1(i)))then
        ipar=i
c        print *,ipar
        goto 100
       endif
c       pause
      enddo
100   continue
      return
      end
*
*****c***1********2*******3********4********5********6********7********8
*
       subroutine makehm(alatt,blatt,clatt,hn,kn,ln,
     1                   alphad,betad,gammad,volume,hmat)
*
*****c***1********2*******3********4********5********6********7********8
*
* matrix algebra for Reverse Monte Carlo (Parinello-Rahman):
*
* make transformation matrix H for transformation 
* from cartesian to crystallographic coordinates
*
* source:  C. Giacovazzo, Fundamentals of Crystallography, 68pp.
*
* m. winterer 3/5/98
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       integer hn,kn,ln
       real alatt,blatt,clatt,alpha,beta,gamma
       real a,b,c
       real volume,cosa,cosb,cosg,sinb,sing,cosas,cs
       real pi,alphad,betad,gammad
       real hmat(3,3)
* common blocks
       common /const/ pi
* conversion from degrees to radians
        alpha=alphad*pi/180.
        beta= betad*pi/180.
        gamma=gammad*pi/180.
*
* geometric factors
*
        a=real(hn)*alatt
        b=real(kn)*blatt
        c=real(ln)*clatt
       
        cosa=sngl(dcos(dble(alpha)))
        cosb=sngl(dcos(dble(beta)))
        cosg=sngl(dcos(dble(gamma)))
        sinb=sngl(dsin(dble(beta)))
        sing=sngl(dsin(dble(gamma)))
        
        cosas=(cosb*cosg-cosa)/(sinb*sing)
       
        volume=a*b*c*
     1         sqrt(1.0-cosa*cosa-cosb*cosb-cosg*cosg
     2             + 2.0*cosa*cosb*cosg)
       
        cs=a*b*sing/volume
*
* matrix elements
*
        hmat(1,1)= a
        hmat(1,2)= 0.0
        hmat(1,3)= 0.0
        hmat(2,1)= b*cosg
        hmat(2,2)= b*sing
        hmat(2,3)= 0.0
        hmat(3,1)= c*cosb
        hmat(3,2)=-c*sinb*cosas 
        hmat(3,3)= 1.0/cs
       return
       end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine makehi(alatt,blatt,clatt,hn,kn,ln,
     1                   alphad,betad,gammad,volume,hinv)
*
*****c***1********2*******3********4********5********6********7********8
*
* matrix algebra for Reverse Monte Carlo (Parinello-Rahman):
*
* make inverse transformation matrix HI for transformation 
* from crystallographic to cartesian coordinates
*
* source:  C. Giacovazzo, Fundamentals of Crystallography, 68pp.
*
* m. winterer 3/5/98
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       integer hn,kn,ln
       real alatt,blatt,clatt,alpha,beta,gamma
       real a,b,c
       real volume,cosa,cosb,cosg,sina,sinb,sing
       real cosas,cosbs,as,bs,cs
       real hinv(3,3)
       real pi,alphad,betad,gammad
* common blocks
      common /const/ pi
* conversion from degrees to radians
*
        alpha=alphad*pi/180.
        beta= betad*pi/180.
        gamma=gammad*pi/180.
*
* geometric factors
*
        a=float(hn)*alatt
        b=float(kn)*blatt
        c=float(ln)*clatt
       
        cosa=sngl(dcos(dble(alpha)))
        cosb=sngl(dcos(dble(beta)))
        cosg=sngl(dcos(dble(gamma)))
        sina=sngl(dsin(dble(alpha)))
        sinb=sngl(dsin(dble(beta)))
        sing=sngl(dsin(dble(gamma)))
        cosas=(cosb*cosg-cosa)/(sinb*sing)
        cosbs=(cosa*cosg-cosb)/(sina*sing)
       
        as=b*c*sina/volume
        bs=a*c*sinb/volume
        cs=a*b*sing/volume
*
* matrix elements
*
        hinv(1,1)= 1./a
        hinv(1,2)= 0.0
        hinv(1,3)= 0.0
        hinv(2,1)=-cosg/(a*sing)
        hinv(2,2)= 1./(b*sing)
        hinv(2,3)= 0.0
        hinv(3,1)= as*cosbs
        hinv(3,2)= bs*cosas 
        hinv(3,3)= cs
       return
       end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine makegm(hmat,gmet)
*
*****c***1********2*******3********4********5********6********7********8
*
* matrix algebra for Reverse Monte Carlo (Parinello-Rahman):
*
* make metric matrix G = H'.H; G is symmetric
*
* source:  C. Giacovazzo, Fundamentals of Crystallography, 68pp.
* and:     M. Parrinello, and A. Rahman, J. Appl. Phys. 52 (1981), 7182
*
* m. winterer 3/5/98
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       real gmet(3,3),hmat(3,3)
*
* matrix elements
*
        gmet(1,1)= hmat(1,1)*hmat(1,1)
        gmet(1,2)= hmat(1,1)*hmat(2,1)
        gmet(1,3)= hmat(1,1)*hmat(3,1)
        gmet(2,1)= gmet(1,2)
        gmet(2,2)= hmat(2,1)*hmat(2,1)+hmat(2,2)*hmat(2,2)
        gmet(2,3)= hmat(2,1)*hmat(3,1)+hmat(2,2)*hmat(3,2)
        gmet(3,1)= gmet(1,3)
        gmet(3,2)= gmet(2,3)
        gmet(3,3)= hmat(3,1)*hmat(3,1)+hmat(3,2)*hmat(3,2)+
     1               hmat(3,3)*hmat(3,3)
       return
       end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine tranco(x,y,z,hmat,a,b,c)
*
*****c***1********2*******3********4********5********6********7********8
*
* matrix algebra for Reverse Monte Carlo (Parinello-Rahman):
*
* (tran)sformation from cartesian ( (o)rthogonal (x)
*                to                 (c)rystallographic (a) coordinates
* a = H.x
*
* source:  C. Giacovazzo, Fundamentals of Crystallography, 68pp.
* and:     M. Parrinello, and A. Rahman, J. Appl. Phys. 52 (1981), 7182
*
* m. winterer 3/5/98
* revised 11/26/14 mw
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       real a,b,c,x,y,z,hmat(3,3)
*
*
* transformation 
*
c       a=x*hmat(1,1)
c       b=x*hmat(2,1)+y*hmat(2,2)
c       c=x*hmat(3,1)+y*hmat(3,2)+z*hmat(3,3)

        a=x*hmat(1,1)+y*hmat(2,1)+z*hmat(3,1)
        b=            y*hmat(2,2)+z*hmat(3,2)
        c=                        z*hmat(3,3)
              
       return
       end
*****c***1********2*******3********4********5********6********7********8
*
       subroutine tranoc(a,b,c,hinv,x,y,z)
*
*****c***1********2*******3********4********5********6********7********8
*
* matrix algebra for Reverse Monte Carlo (Parinello-Rahman):
*
* (tran)sformation from (c)rystallographic (a) 
* to        cartesian ( (o)rthogonal       (x) coordinates
* x = HI.a
*
* source:  C. Giacovazzo, Fundamentals of Crystallography, 68pp.
* and:     M. Parrinello, and A. Rahman, J. Appl. Phys. 52 (1981), 7182
*
* m. winterer 3/5/98
* revised 11/26/14 mw
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       real a,b,c,x,y,z,hinv(3,3)
*
*
* transformation
*
c       x=a*hinv(1,1)
c       y=a*hinv(2,1)+b*hinv(2,2)
c       z=a*hinv(3,1)+b*hinv(3,2)+c*hinv(3,3)
              
       x=a*hinv(1,1)+b*hinv(2,1)+c*hinv(3,1)
       y=            b*hinv(2,2)+c*hinv(3,2)
       z=                        c*hinv(3,3)

       return
       end

*****c***1********2*******3********4********5********6********7********8
*
       subroutine distan(a,b,c,x,y,z,gmet,rij,pbc)
*
*****c***1********2*******3********4********5********6********7********8
*
* matrix algebra for Reverse Monte Carlo (Parinello-Rahman):
*
* calculation of atomic distances rij
* 
* rij=sqrt((si-sj)*G*(si-sj))
* G: metric matrix; si,sj: vectors of atoms i and j in cryst. coordinates 
*
* source:  C. Giacovazzo, Fundamentals of Crystallography, 68pp.
* and:     M. Parrinello, and A. Rahman, J. Appl. Phys. 52 (1981), 7182
*
* m. winterer 3/5/98
*
*****c***1********2*******3********4********5********6********7********8
*
* declarations
*
       implicit none
       real a,b,c,x,y,z,gmet(3,3),rij,dx,dy,dz
       logical pbc
*
* point distances
*
       dx=a-x
       dy=b-y
       dz=c-z
* minimum image convention: Allen & Tildesly p.30
       if(pbc)then
        dx=dx-anint(dx)
        dy=dy-anint(dy)
        dz=dz-anint(dz)
       endif
* minimum image convention: Allen & Tildesly p.30

        rij=sqrt(
     1          dx*dx*gmet(1,1)+
     2          dy*dy*gmet(2,2)+dz*dz*gmet(3,3)+
     3          2.*dx*dy*gmet(1,2)+
     4          2.*dy*dz*gmet(2,3)+
     5          2.*dx*dz*gmet(1,3))
         
c       print *,'rij= ',rij 
       return
       end

******c***1********2*******3********4********5********6********7********8
      subroutine inpar(mtyp,ntyp,hn,kn,ln,title,filein,filout,namlen,
     1                 alatt,blatt,clatt,alphad,betad,gammad,
     2                 name2,dfill,dbas,colr,colg,colb,
     3                 npar,par1,par2,bond1,bond2,face,pbc,
     4                 slct,rs,xsp,ysp,zsp,
     5                 xbon,ybon,zbon,xbox,ybox,zbox)
******c***1********2*******3********4********5********6********7********8
*
*     declarations
*
      implicit none
      integer mtyp,ntyp
      integer i,hn,kn,ln,namlen,npar,par1(mtyp),par2(mtyp)
      real alatt,blatt,clatt
      real alphad,betad,gammad
      real dfill(mtyp),dbas(mtyp),colr(mtyp),colg(mtyp),colb(mtyp)
      real bond1(mtyp),bond2(mtyp),face
      real rs,xsp,ysp,zsp,xbon,ybon,zbon,xbox,ybox,zbox
      character*1 cdummy,slct
      character*2 name2(mtyp)
      character*31 filpar,filein,filout
      character*80 title
      logical pbc
*
      filpar='anacon.par' 
*      print *,filpar
      open(9,file=filpar,status='old')
      read(9,9001)cdummy
*      print *,cdummy
      read(9,9001)cdummy
*      print *,cdummy
      read(9,'(a)')filein
*      print *,filein
      read(9,'(a)')filout
*      print *,filout
      read(9,'(a)')title
*      print *,title
      read(9,*)alatt,blatt,clatt
*      print *,alatt,blatt,clatt
      read(9,*)alphad,betad,gammad
*      print *,alphad,betad,gammad
      read(9,*)hn,kn,ln
*      print *,hn,kn,ln
      read(9,*)ntyp
*      print *,ntyp
      read(9,*)npar
*      print *,npar
      do i=1,npar
       read(9,*)par1(i),par2(i),bond1(i),bond2(i)
*       print *,par1(i),par2(i),bond1(i),bond2(i)
      enddo
      read(9,*)face
      read(9,*)pbc
      read(9,'(a)')slct
      read(9,*)rs,xsp,ysp,zsp
      read(9,*)xbon,ybon,zbon
      read(9,*)xbox,ybox,zbox
      do i=1,ntyp
       read(9,'(a)')name2(i)
      enddo
      do i=1,ntyp
       read(9,*)dfill(i),dbas(i),colr(i),colg(i),colb(i)
      enddo
      close(9,status='keep')
*
*    close parameter file 
*
      do 10 i=1,31
       if(filout(i:i).eq.' ')then
        namlen=i
        goto 11
       endif
10    continue
11    continue
      namlen=amin0(namlen,31)
      namlen=namlen-1
**************************************************************
*
* formats
*
9000  format(a31)
9001  format(a1)
9002  format(a2)
       return
       end
*
*****c***1********2*******3********4********5********6********7********8
*
       subroutine outmcm(mtyp,ntyp,matom,natom,num,typ,xco,yco,zco,
     1                  list,name2,nc,cn,dfill,dbas,cosr,cosg,cosb,
     2                  colr,colg,colb,filout,namlen,header)
*
*****c***1********2*******3********4********5********6********7********8
       implicit none
       integer mtyp,ntyp,matom,natom,namlen
       integer matom2
       parameter(matom2=10000)
       integer num(matom),typ(matom),list(matom)
       real xco(matom),yco(matom),zco(matom)
       integer i,j,k,l,nc(matom),cn(matom,12)
       character*1 name(matom2)
       character*2 name2(mtyp)
       real dfill(mtyp),dbas(mtyp),colr(mtyp),colg(mtyp),colb(mtyp)
       real cosr,cosg,cosb
       character*31 filout
       character*80 header
******c***1********2*******3********4********5********6********7********8
      filout(namlen+1:namlen+5)='.mcm'

       cosr=0.5
       cosg=0.5
       cosb=0.5
       open(15,file=filout,status='unknown')
        write(15,'(a)')';'//header
        write(15,'(a1)')';'
        write(15,'(a2,3(g13.6,a1))') '2(',cosr,',',cosg,',',cosb,')'
        write(15,'(a2)')'BS'
        do i=1,ntyp
         write(15,'(a1,a3,2(g13.6,a1),3(g13.6,a1))')
     1              name2(i)(1:1),' = ',dfill(i),',',dbas(i),'(',
     2              colr(i),',',colg(i),',',colb(i),')'
        enddo 
* atomic coordinates
        do i=1,natom
         l=list(i)
         name(l)=name2(typ(l))(1:1)
         write(15,'(a1,i5,a3,3(g13.6,1x))')
     1              name(l),num(l),' : ',xco(l),yco(l),zco(l)
        enddo
* connectivities
        do i=1,natom
         l=list(i)
         do j=1,nc(l)
          k=cn(l,j)
          write(15,'(a1,i5,a1,a1,i5)')
     1               name(l),num(l),',',name(k),num(k)
         enddo
        enddo
        
       close(15,status='keep')
       return
       end
**************************************************************
       subroutine oupdb(mtyp,ntyp,natomp,natoms,title,filout,namlen,
     1                  list,name2,atorad,colr,colg,colb,atonum,typ,
     2                  xc,yc,zc,coonum,conato,temp)
**************************************************************
*     declarations
*
      implicit none
      integer natomp,i,j,l,natoms,ncoop,mtyp,ntyp,namlen
      parameter(ncoop=12)
      integer atonum(natomp)
      integer conato(natomp,ncoop),coonum(natomp)
      integer list(natomp),typ(natomp)
      real xc(natomp),yc(natomp),zc(natomp),temp(natomp)
      real colr(mtyp),colg(mtyp),colb(mtyp),atorad(mtyp)
      character*80 dummy
      character*60 title
      character*30 filout
      character*4 name
      character*2 name2(mtyp)
**************************************************************
*     output in pdb format for RasMol 2.5
*
      filout(namlen+1:namlen+5)='.pdb'

       open(unit=11,file=filout,status='unknown',form='formatted')
        dummy(1:7)='HEADER '
        dummy(8:80)=title
        write(11,9000)dummy
        do 30 i=1,ntyp
	 write(11,9303)'COLO ',name2(i),colr(i),colg(i),colb(i),atorad(i)
30      continue
        do 40 i=1,natoms
         l=list(i)
         name='    '
         name(2:2)=name2(typ(l))(1:1)
         name(3:3)=name2(typ(l))(2:2)
         write(11,9301)'ATOM  ',l,name,' ','UNK',' ',0,' ',
     1                 xc(l),yc(l),zc(l),1.,temp(l)
40      continue
c         write(11,9301)'TER   ',natomp+1,'    ',' ','UNK'
*
* write connectivity matrix
*
	do 50 i=1,natoms
         l=list(i)
	 if(coonum(l).gt.0)then
	 write(11,9302)'CONECT',atonum(l),(conato(l,j),j=1,coonum(l))
         endif
50      continue
       close(unit=11,status='keep')
**************************************************************
*     FORMATS
*
9000  format(a80)
9301  format(a6,i5,a4,1x,a1,a3,1x,a1,i4,a1,3x,3f8.3,2f6.2,1x,i3)
9302  format(a6,12(1x,i5))
9303  format(a5,'#######',a2,'################',
     1       1x,f5.3,2x,f5.3,3x,f5.3,5x,f5.3)
**************************************************************
      return
      end
*****c***1********2*******3********4********5********6********7********8
       subroutine select(matom,natom,hinv,gmet,slct,
     1                   rs,xsp,ysp,zsp,xbon,ybon,zbon,xbox,ybox,zbox,
     2                   xc,yc,zc,list,pbc)
*****c***1********2*******3********4********5********6********7********8
      integer matom,natom,nat
      integer i,j,l,list(matom)
      real hinv(3,3),gmet(3,3)
      real xsp,ysp,zsp,xs,ys,zs 
      real xbon,ybon,zbon,xbn,ybn,zbn 
      real xbox,ybox,zbox,xbx,ybx,zbx
      real x,xc(matom),y,yc(matom),z,zc(matom)
      real ris,rs
      character*1 slct
      logical pbc
*****c***1********2*******3********4********5********6********7********8
*
      call tranoc(xsp,ysp,zsp,hinv,xs,ys,zs) 
      call tranoc(xbon,ybon,zbon,hinv,xbn,ybn,zbn) 
      call tranoc(xbox,ybox,zbox,hinv,xbx,ybx,zbx) 
      nat=0
      do j=1,natom
       l=0
       x=xc(j)
       y=yc(j)
       z=zc(j)
       if(slct.eq.'s')then
        call distan(x,y,z,xs,ys,zs,gmet,ris,pbc)
        if(ris.le.rs)then
         nat=nat+1
	list(nat)=j
       endif 
       elseif(slct.eq.'b')then
        if((z.ge.zbn).and.(z.le.zbx))then
         if((y.ge.ybn).and.(y.le.ybx))then
          if((x.ge.xbn).and.(x.le.xbx))then
           nat=nat+1
	   list(nat)=j
	  endif
	 endif
        endif
       else
        nat=nat+1
        list(nat)=j
       endif
      enddo
      natom=nat
      print *,'number of selected atoms: ',natom
      return
      end
******c***1********2*******3********4********5********6********7********8
       subroutine temper(matom,natom,list,temp)
******c***1********2*******3********4********5********6********7********8
       implicit none
       integer matom,natom
       integer i,list(matom)
       real tmax,tmin,temp(matom),tnorm,tshift
******c***1********2*******3********4********5********6********7********8
       tmax=-1.e35
       tmin= 1.e35
       do 25 i=1,natom
        tmax=amax1(tmax,temp(list(i)))
	tmin=amin1(tmin,temp(list(i)))
c        print *,temp(list(i))
25     continue
       tnorm=tmax-tmin
       if(tnorm.ne.0.)then
	tnorm=1./tnorm
       endif
       tshift=-tmin
       do 26 i=1,natom
	temp(list(i))=(temp(list(i))+tshift)*tnorm
	if(temp(list(i)).le.0.05)temp(list(i))=0.05
c        print *,temp(list(i))
26     continue
       return
       end
